/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.client.animation;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.GsonHelper;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.TransformSheet;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.DirectStaticAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.JsonAssetLoader;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.client.animation.property.ClientAnimationProperties;
import yesman.epicfight.api.client.animation.property.JointMaskEntry;
import yesman.epicfight.api.client.animation.property.JointMaskReloadListener;
import yesman.epicfight.api.client.animation.property.LayerInfo;
import yesman.epicfight.api.client.animation.property.TrailInfo;
import yesman.epicfight.api.exception.AssetLoadingException;
import yesman.epicfight.api.utils.ParseUtil;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class AnimationSubFileReader {
    public static final SubFileType<ClientProperty> SUBFILE_CLIENT_PROPERTY = new ClientPropertyType();
    public static final SubFileType<PovSettings> SUBFILE_POV_ANIMATION = new PovAnimationType();

    public static void readAndApply(StaticAnimation animation, Resource iresource, SubFileType<?> subFileType) {
        InputStream inputstream = null;
        try {
            inputstream = iresource.open();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        assert (inputstream != null) : "Input stream is null";
        try {
            subFileType.apply(inputstream, animation);
        }
        catch (JsonParseException e) {
            EpicFightMod.LOGGER.warn("Can't read sub file " + subFileType.directory + " for " + String.valueOf(animation));
            e.printStackTrace();
        }
    }

    public static abstract class SubFileType<T> {
        private final String directory;
        private final AnimationSubFileDeserializer<T> deserializer;

        private SubFileType(String directory, AnimationSubFileDeserializer<T> deserializer) {
            this.directory = directory;
            this.deserializer = deserializer;
        }

        public void apply(InputStream inputstream, StaticAnimation animation) {
            InputStreamReader reader = new InputStreamReader(inputstream, StandardCharsets.UTF_8);
            JsonReader jsonReader = new JsonReader((Reader)reader);
            jsonReader.setLenient(true);
            T deserialized = this.deserializer.deserialize(animation, Streams.parse((JsonReader)jsonReader));
            this.applySubFileInfo(deserialized, animation);
        }

        public void apply(JsonElement jsonElement, StaticAnimation animation) {
            T deserialized = this.deserializer.deserialize(animation, jsonElement);
            this.applySubFileInfo(deserialized, animation);
        }

        protected abstract void applySubFileInfo(T var1, StaticAnimation var2);

        public String getDirectory() {
            return this.directory;
        }
    }

    private static class ClientPropertyType
    extends SubFileType<ClientProperty> {
        private ClientPropertyType() {
            super("data", new ClientAnimationPropertyDeserializer());
        }

        @Override
        public void applySubFileInfo(ClientProperty deserialized, StaticAnimation animation) {
            if (deserialized.layerInfo() != null) {
                if (deserialized.layerInfo().jointMaskEntry.isValid()) {
                    animation.addProperty(ClientAnimationProperties.JOINT_MASK, deserialized.layerInfo().jointMaskEntry);
                }
                animation.addProperty(ClientAnimationProperties.LAYER_TYPE, deserialized.layerInfo().layerType);
                animation.addProperty(ClientAnimationProperties.PRIORITY, deserialized.layerInfo().priority);
            }
            if (deserialized.multilayerInfo() != null) {
                DirectStaticAnimation multilayerAnimation = new DirectStaticAnimation(animation.getLocation(), animation.getTransitionTime(), animation.isRepeat(), animation.getRegistryName().toString() + "_multilayer", animation.getArmature());
                if (deserialized.multilayerInfo().jointMaskEntry.isValid()) {
                    multilayerAnimation.addProperty(ClientAnimationProperties.JOINT_MASK, deserialized.multilayerInfo().jointMaskEntry);
                }
                multilayerAnimation.addProperty(ClientAnimationProperties.LAYER_TYPE, deserialized.multilayerInfo().layerType);
                multilayerAnimation.addProperty(ClientAnimationProperties.PRIORITY, deserialized.multilayerInfo().priority);
                multilayerAnimation.addProperty(AnimationProperty.StaticAnimationProperty.ELAPSED_TIME_MODIFIER, (self, entitypatch, speed, prevElapsedTime, elapsedTime) -> {
                    Layer.BaseLayer baseLayer = entitypatch.getClientAnimator().baseLayer;
                    if (baseLayer.animationPlayer.getAnimation().get().getRealAnimation().get() != animation) {
                        return Pair.of((Object)Float.valueOf(prevElapsedTime), (Object)Float.valueOf(elapsedTime));
                    }
                    if (!self.isStaticAnimation() && baseLayer.animationPlayer.getAnimation().get().isStaticAnimation()) {
                        return Pair.of((Object)Float.valueOf(prevElapsedTime + speed), (Object)Float.valueOf(elapsedTime + speed));
                    }
                    return Pair.of((Object)Float.valueOf(baseLayer.animationPlayer.getPrevElapsedTime()), (Object)Float.valueOf(baseLayer.animationPlayer.getElapsedTime()));
                });
                animation.addProperty(ClientAnimationProperties.MULTILAYER_ANIMATION, multilayerAnimation);
            }
            if (deserialized.trailInfo().size() > 0) {
                animation.addProperty(ClientAnimationProperties.TRAIL_EFFECT, deserialized.trailInfo());
            }
        }
    }

    private static class PovAnimationType
    extends SubFileType<PovSettings> {
        private PovAnimationType() {
            super("pov", new PovAnimationDeserializer());
        }

        @Override
        public void applySubFileInfo(PovSettings deserialized, final StaticAnimation animation) {
            ResourceLocation povAnimationLocation = deserialized.hasUniqueAnimation() ? AnimationManager.getSubAnimationFileLocation(animation.getLocation(), SUBFILE_POV_ANIMATION) : animation.getLocation();
            DirectStaticAnimation povAnimation = new DirectStaticAnimation(this, povAnimationLocation, animation.getTransitionTime(), animation.isRepeat(), animation.getRegistryName().toString() + "_pov", animation.getArmature()){

                @Override
                public float getPlaySpeed(LivingEntityPatch<?> entitypatch, DynamicAnimation pAnimation) {
                    return animation.getPlaySpeed(entitypatch, pAnimation);
                }
            };
            animation.getProperty(AnimationProperty.StaticAnimationProperty.PLAY_SPEED_MODIFIER).ifPresent(speedModifier -> povAnimation.addProperty(AnimationProperty.StaticAnimationProperty.PLAY_SPEED_MODIFIER, speedModifier));
            if (deserialized.syncFrame()) {
                animation.getProperty(AnimationProperty.StaticAnimationProperty.ELAPSED_TIME_MODIFIER).ifPresent(elapsedTimeModifier -> povAnimation.addProperty(AnimationProperty.StaticAnimationProperty.ELAPSED_TIME_MODIFIER, elapsedTimeModifier));
            }
            animation.addProperty(ClientAnimationProperties.POV_ANIMATION, povAnimation);
            animation.addProperty(ClientAnimationProperties.POV_SETTINGS, deserialized);
        }
    }

    public static interface AnimationSubFileDeserializer<T> {
        public T deserialize(StaticAnimation var1, JsonElement var2) throws JsonParseException;
    }

    private static class PovAnimationDeserializer
    implements AnimationSubFileDeserializer<PovSettings> {
        private PovAnimationDeserializer() {
        }

        @Override
        public PovSettings deserialize(StaticAnimation animation, JsonElement json) throws AssetLoadingException, JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            TransformSheet cameraTransform = null;
            PovSettings.ViewLimit viewLimit = null;
            PovSettings.RootTransformation rootTrasnformation = null;
            rootTrasnformation = jObject.has("root") ? PovSettings.RootTransformation.valueOf(ParseUtil.toUpperCase(GsonHelper.getAsString((JsonObject)jObject, (String)"root"))) : (animation instanceof ActionAnimation ? PovSettings.RootTransformation.WORLD : PovSettings.RootTransformation.CAMERA);
            if (jObject.has("camera")) {
                JsonObject cameraTransformJObject = jObject.getAsJsonObject("camera");
                cameraTransform = JsonAssetLoader.getTransformSheet(cameraTransformJObject, null, false, JsonAssetLoader.TransformFormat.ATTRIBUTES);
            }
            ImmutableMap.Builder visibilitiesBuilder = ImmutableMap.builder();
            boolean others = false;
            if (jObject.has("visibilities")) {
                JsonObject visibilitiesObject = jObject.getAsJsonObject("visibilities");
                visibilitiesObject.entrySet().stream().filter(e -> !"others".equals(e.getKey())).forEach(entry -> visibilitiesBuilder.put((Object)((String)entry.getKey()), (Object)((JsonElement)entry.getValue()).getAsBoolean()));
                others = visibilitiesObject.get("others").getAsBoolean();
            } else {
                visibilitiesBuilder.put((Object)"leftArm", (Object)true);
                visibilitiesBuilder.put((Object)"leftSleeve", (Object)true);
                visibilitiesBuilder.put((Object)"rightArm", (Object)true);
                visibilitiesBuilder.put((Object)"rightSleeve", (Object)true);
            }
            if (jObject.has("limited_view_degrees")) {
                JsonObject limitedViewDegrees = jObject.getAsJsonObject("limited_view_degrees");
                JsonArray xRot = limitedViewDegrees.get("xRot").getAsJsonArray();
                JsonArray yRot = limitedViewDegrees.get("yRot").getAsJsonArray();
                float xRotMin = Math.min(xRot.get(0).getAsFloat(), xRot.get(1).getAsFloat());
                float xRotMax = Math.max(xRot.get(0).getAsFloat(), xRot.get(1).getAsFloat());
                float yRotMin = Math.min(yRot.get(0).getAsFloat(), yRot.get(1).getAsFloat());
                float yRotMax = Math.max(yRot.get(0).getAsFloat(), yRot.get(1).getAsFloat());
                viewLimit = new PovSettings.ViewLimit(xRotMin, xRotMax, yRotMin, yRotMax);
            }
            return new PovSettings(cameraTransform, (Map<String, Boolean>)visibilitiesBuilder.build(), rootTrasnformation, viewLimit, others, jObject.has("animation"), GsonHelper.getAsBoolean((JsonObject)jObject, (String)"sync_frame", (boolean)false));
        }
    }

    public record PovSettings(@Nullable TransformSheet cameraTransform, Map<String, Boolean> visibilities, RootTransformation rootTransformation, @Nullable ViewLimit viewLimit, boolean visibilityOthers, boolean hasUniqueAnimation, boolean syncFrame) {

        public static enum RootTransformation {
            CAMERA,
            WORLD;

        }

        public record ViewLimit(float xRotMin, float xRotMax, float yRotMin, float yRotMax) {
        }
    }

    private static class ClientAnimationPropertyDeserializer
    implements AnimationSubFileDeserializer<ClientProperty> {
        private ClientAnimationPropertyDeserializer() {
        }

        private static LayerInfo deserializeLayerInfo(JsonObject jsonObject) {
            return ClientAnimationPropertyDeserializer.deserializeLayerInfo(jsonObject, null);
        }

        private static LayerInfo deserializeLayerInfo(JsonObject jsonObject, @Nullable Layer.LayerType defaultLayerType) {
            JsonArray maskArray;
            Layer.LayerType layerType;
            JointMaskEntry.Builder builder = JointMaskEntry.builder();
            Layer.Priority priority = jsonObject.has("priority") ? Layer.Priority.valueOf(GsonHelper.getAsString((JsonObject)jsonObject, (String)"priority")) : null;
            Layer.LayerType layerType2 = layerType = jsonObject.has("layer") ? Layer.LayerType.valueOf(GsonHelper.getAsString((JsonObject)jsonObject, (String)"layer")) : Layer.LayerType.BASE_LAYER;
            if (jsonObject.has("masks") && !(maskArray = jsonObject.get("masks").getAsJsonArray()).isEmpty()) {
                builder.defaultMask(JointMaskReloadListener.getNoneMask());
                maskArray.forEach(element -> {
                    JsonObject jointMaskEntry = element.getAsJsonObject();
                    String livingMotionName = GsonHelper.getAsString((JsonObject)jointMaskEntry, (String)"livingmotion");
                    String type = GsonHelper.getAsString((JsonObject)jointMaskEntry, (String)"type");
                    if (!type.contains(":")) {
                        type = "epicfight" + ":" + type;
                    }
                    if (livingMotionName.equals("ALL")) {
                        builder.defaultMask(JointMaskReloadListener.getJointMaskEntry(type));
                    } else {
                        builder.mask(LivingMotion.ENUM_MANAGER.getOrThrow(livingMotionName), JointMaskReloadListener.getJointMaskEntry(type));
                    }
                });
            }
            return new LayerInfo(builder.create(), priority, defaultLayerType == null ? layerType : defaultLayerType);
        }

        @Override
        public ClientProperty deserialize(StaticAnimation animation, JsonElement json) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            LayerInfo layerInfo = null;
            LayerInfo multilayerInfo = null;
            if (jsonObject.has("multilayer")) {
                JsonObject multiplayerJson = jsonObject.get("multilayer").getAsJsonObject();
                layerInfo = ClientAnimationPropertyDeserializer.deserializeLayerInfo(multiplayerJson.get("base").getAsJsonObject());
                multilayerInfo = ClientAnimationPropertyDeserializer.deserializeLayerInfo(multiplayerJson.get("composite").getAsJsonObject(), Layer.LayerType.COMPOSITE_LAYER);
            } else {
                layerInfo = ClientAnimationPropertyDeserializer.deserializeLayerInfo(jsonObject);
            }
            ArrayList trailInfos = Lists.newArrayList();
            if (jsonObject.has("trail_effects")) {
                JsonArray trailArray = jsonObject.get("trail_effects").getAsJsonArray();
                trailArray.forEach(element -> trailInfos.add(TrailInfo.deserialize(element)));
            }
            return new ClientProperty(layerInfo, multilayerInfo, trailInfos);
        }
    }

    private record ClientProperty(LayerInfo layerInfo, LayerInfo multilayerInfo, List<TrailInfo> trailInfo) {
    }
}

