/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.client.input;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import yesman.epicfight.api.client.input.DiscreteActionHandler;
import yesman.epicfight.api.client.input.InputMode;
import yesman.epicfight.api.client.input.PlayerInputState;
import yesman.epicfight.api.client.input.action.InputAction;
import yesman.epicfight.api.client.input.controller.ControllerBinding;
import yesman.epicfight.api.client.input.controller.EpicFightControllerModProvider;
import yesman.epicfight.api.client.input.controller.IEpicFightControllerMod;
import yesman.epicfight.client.input.DiscreteInputActionTrigger;

@ApiStatus.Experimental
public final class InputManager {
    private InputManager() {
    }

    @Nullable
    private static IEpicFightControllerMod getControllerModApi() {
        return EpicFightControllerModProvider.get();
    }

    @NotNull
    public static InputMode getInputMode() {
        IEpicFightControllerMod controllerMod = InputManager.getControllerModApi();
        return controllerMod == null ? InputMode.KEYBOARD_MOUSE : controllerMod.getInputMode();
    }

    public static boolean supportsControllerInput() {
        return InputManager.getInputMode().supportsController();
    }

    public static boolean isActionActive(@NotNull InputAction action) {
        return InputManager.checkAction(action, InputManager::isKeyDown);
    }

    public static boolean isActionPhysicallyActive(@NotNull InputAction action) {
        return InputManager.checkAction(action, InputManager::isPhysicalKeyDown);
    }

    private static boolean checkAction(@NotNull InputAction action, @NotNull Function<KeyMapping, Boolean> keyboardCheck) {
        IEpicFightControllerMod controllerMod = InputManager.getControllerModApi();
        if (controllerMod == null) {
            return keyboardCheck.apply(action.keyMapping());
        }
        return switch (controllerMod.getInputMode()) {
            default -> throw new MatchException(null, null);
            case InputMode.KEYBOARD_MOUSE -> keyboardCheck.apply(action.keyMapping());
            case InputMode.CONTROLLER -> action.controllerBinding().map(ControllerBinding::isDigitalActiveNow).orElse(keyboardCheck.apply(action.keyMapping()));
            case InputMode.MIXED -> keyboardCheck.apply(action.keyMapping()) != false || action.controllerBinding().map(ControllerBinding::isDigitalActiveNow).orElse(false) != false;
        };
    }

    public static void triggerOnPress(@NotNull InputAction action, @NotNull DiscreteActionHandler handler) {
        DiscreteInputActionTrigger.triggerOnPress(action, handler);
    }

    public static void triggerOnPress(@NotNull InputAction action, @NotNull Runnable runnable) {
        InputManager.triggerOnPress(action, (DiscreteActionHandler.Context context) -> runnable.run());
    }

    public static boolean isBoundToSamePhysicalInput(@NotNull InputAction action, @NotNull InputAction action2) {
        IEpicFightControllerMod controllerMod = InputManager.getControllerModApi();
        if (controllerMod != null && controllerMod.getInputMode() == InputMode.CONTROLLER) {
            Optional<ControllerBinding> optionalControllerBinding = action.controllerBinding();
            Optional<ControllerBinding> optionalControllerBinding2 = action2.controllerBinding();
            if (optionalControllerBinding.isPresent() && optionalControllerBinding2.isPresent()) {
                return optionalControllerBinding.get().isBoundToSamePhysicalInput(optionalControllerBinding2.get());
            }
        }
        KeyMapping keyMapping1 = action.keyMapping();
        KeyMapping keyMapping2 = action2.keyMapping();
        return keyMapping1.getKey() == keyMapping2.getKey();
    }

    @NotNull
    public static PlayerInputState getInputState(@NotNull Input vanillaInput) {
        IEpicFightControllerMod controllerMod = InputManager.getControllerModApi();
        if (controllerMod != null && controllerMod.getInputMode() == InputMode.CONTROLLER) {
            return controllerMod.getInputState();
        }
        return PlayerInputState.fromVanillaInput(vanillaInput);
    }

    @NotNull
    public static PlayerInputState getInputState(@NotNull LocalPlayer localPlayer) {
        return InputManager.getInputState(localPlayer.input);
    }

    public static void setInputState(@NotNull PlayerInputState inputState) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            Input input = player.input;
            PlayerInputState.applyToVanillaInput(inputState, input);
        }
    }

    private static boolean isKeyDown(@NotNull KeyMapping keyMapping) {
        boolean isDown = keyMapping.isDown();
        if (!isDown && keyMapping.getKey().getType() == InputConstants.Type.MOUSE) {
            return InputManager.isPhysicalKeyDown(keyMapping);
        }
        return isDown;
    }

    @ApiStatus.Internal
    private static boolean isPhysicalKeyDown(@NotNull KeyMapping keyMapping) {
        InputConstants.Key key = keyMapping.getKey();
        int keyValue = key.getValue();
        long windowPointer = Minecraft.getInstance().getWindow().getWindow();
        if (key.getType() == InputConstants.Type.KEYSYM) {
            return GLFW.glfwGetKey((long)windowPointer, (int)keyValue) > 0;
        }
        if (key.getType() == InputConstants.Type.MOUSE) {
            return GLFW.glfwGetMouseButton((long)windowPointer, (int)keyValue) > 0;
        }
        return false;
    }
}

