/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.collider;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.TransformSheet;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.collider.MultiCollider;
import yesman.epicfight.api.collider.OBBCollider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class MultiOBBCollider
extends MultiCollider<OBBCollider> {
    public MultiOBBCollider(int arrayLength, double vertexX, double vertexY, double vertexZ, double centerX, double centerY, double centerZ) {
        super(arrayLength, centerX, centerY, centerZ, null);
        AABB aabb = OBBCollider.getInitialAABB(vertexX, vertexY, vertexZ, centerX, centerY, centerZ);
        OBBCollider colliderForAll = new OBBCollider(aabb, vertexX, vertexY, vertexZ, centerX, centerY, centerZ);
        for (int i = 0; i < arrayLength; ++i) {
            this.colliders.add(colliderForAll);
        }
    }

    public MultiOBBCollider(OBBCollider ... colliders) {
        super((Collider[])colliders);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(PoseStack poseStack, MultiBufferSource buffer, LivingEntityPatch<?> entitypatch, AttackAnimation animation, Joint joint, float prevElapsedTime, float elapsedTime, float partialTicks, float attackSpeed) {
        int colliderCount = Math.max(Math.round((float)(this.numberOfColliders + animation.getProperty(AnimationProperty.AttackAnimationProperty.EXTRA_COLLIDERS).orElse(0)) * attackSpeed), this.numberOfColliders);
        float partialScale = 1.0f / (float)(colliderCount - 1);
        float interpolation = 0.0f;
        Armature armature = entitypatch.getArmature();
        EntityState state = animation.getState(entitypatch, elapsedTime);
        EntityState prevState = animation.getState(entitypatch, prevElapsedTime);
        boolean attacking = prevState.attacking() || state.attacking() || prevState.getLevel() < 2 && state.getLevel() > 2;
        ArrayList colliders = Lists.newArrayList();
        float index = 0.0f;
        float interIndex = Math.min((float)(this.numberOfColliders - 1) / (float)(colliderCount - 1), 1.0f);
        for (int i = 0; i < colliderCount; ++i) {
            colliders.add(((OBBCollider)this.colliders.get((int)index)).deepCopy());
            index += interIndex;
        }
        for (OBBCollider obbCollider : colliders) {
            Pose pose;
            float pt1 = prevElapsedTime + (elapsedTime - prevElapsedTime) * partialTicks;
            float pt2 = prevElapsedTime + (elapsedTime - prevElapsedTime) * interpolation;
            TransformSheet coordTransform = animation.getCoord();
            Vec3f p1 = coordTransform.getInterpolatedTranslation(pt1);
            Vec3f p2 = coordTransform.getInterpolatedTranslation(pt2);
            poseStack.pushPose();
            poseStack.translate(p2.x - p1.x, p2.y - p1.y, p2.z - p1.z);
            if (armature.rootJoint.getName().equals(joint.getName())) {
                pose = new Pose();
                pose.putJointData("Root", JointTransform.empty());
                animation.modifyPose(animation, pose, entitypatch, elapsedTime, 1.0f);
            } else {
                pose = animation.getPoseByTime(entitypatch, pt2, 1.0f);
            }
            obbCollider.drawInternal(poseStack, buffer.getBuffer(this.getRenderType()), armature, joint, pose, pose, 1.0f, attacking ? -65536 : -1);
            poseStack.popPose();
            interpolation += partialScale;
        }
    }

    @Override
    public CompoundTag serialize(CompoundTag resultTag) {
        if (resultTag == null) {
            resultTag = new CompoundTag();
        }
        resultTag.putInt("number", this.numberOfColliders);
        ListTag center = new ListTag();
        center.add((Object)DoubleTag.valueOf((double)this.modelCenter.x));
        center.add((Object)DoubleTag.valueOf((double)this.modelCenter.y));
        center.add((Object)DoubleTag.valueOf((double)this.modelCenter.z));
        resultTag.put("center", (Tag)center);
        ListTag size = new ListTag();
        size.add((Object)DoubleTag.valueOf((double)((OBBCollider)this.colliders.get((int)0)).modelVertices[1].x));
        size.add((Object)DoubleTag.valueOf((double)((OBBCollider)this.colliders.get((int)0)).modelVertices[1].y));
        size.add((Object)DoubleTag.valueOf((double)((OBBCollider)this.colliders.get((int)0)).modelVertices[1].z));
        resultTag.put("size", (Tag)size);
        return resultTag;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public RenderType getRenderType() {
        return ((OBBCollider)this.colliders.get(0)).getRenderType();
    }
}

