/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.data.reloader;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.network.server.SPDatapackSync;
import yesman.epicfight.registry.EpicFightRegistries;
import yesman.epicfight.registry.entries.EpicFightSkills;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.capabilities.skill.PlayerSkills;

public class SkillReloadListener
extends SimpleJsonResourceReloadListener {
    private static final List<CompoundTag> SKILL_PARAMS = Lists.newArrayList();
    private static final Gson GSON = new GsonBuilder().create();
    private static final SkillReloadListener INSTANCE = new SkillReloadListener();

    public static List<CompoundTag> getSkillParams() {
        return Collections.unmodifiableList(SKILL_PARAMS);
    }

    public static Skill getSkill(String name) {
        ResourceLocation rl = name.indexOf(58) >= 0 ? ResourceLocation.parse((String)name) : EpicFightMod.identifier(name);
        if (EpicFightRegistries.SKILL.containsKey(rl)) {
            return (Skill)EpicFightRegistries.SKILL.get(rl);
        }
        return null;
    }

    public static Collection<Skill> getSkills(Predicate<Skill> predicate) {
        return EpicFightRegistries.SKILL.holders().map(Holder::value).filter(skill -> predicate.test((Skill)skill)).toList();
    }

    public static Stream<ResourceLocation> getSkillNames(Predicate<Skill> predicate) {
        return EpicFightRegistries.SKILL.holders().map(Holder::value).filter(skill -> predicate.test((Skill)skill)).map(skill -> skill.getRegistryName());
    }

    public static void reloadAllSkillsAnimations() {
        EpicFightRegistries.SKILL.holders().map(Holder::value).forEach(skill -> skill.registerPropertiesToAnimation());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void processServerPacket(SPDatapackSync packet) {
        for (CompoundTag tag : packet.tags()) {
            if (!EpicFightRegistries.SKILL.containsKey(ResourceLocation.parse((String)tag.getString("id")))) {
                EpicFightMod.LOGGER.warn("Failed to syncronize Datapack for skill: " + tag.getString("id"));
                continue;
            }
            ((Skill)EpicFightRegistries.SKILL.get(ResourceLocation.parse((String)tag.getString("id")))).loadDatapackParameters(tag);
        }
        LocalPlayerPatch localplayerpatch = ClientEngine.getInstance().getPlayerPatch();
        if (localplayerpatch != null) {
            PlayerSkills skillCapability = localplayerpatch.getPlayerSkills();
            for (SkillContainer skill : skillCapability.skillContainers) {
                if (skill.getSkill() == null) continue;
                skill.setSkill(SkillReloadListener.getSkill(skill.getSkill().toString()), true);
            }
            skillCapability.skillContainers[SkillCategories.BASIC_ATTACK.universalOrdinal()].setSkill((Skill)EpicFightSkills.COMBO_ATTACKS.get());
            skillCapability.skillContainers[SkillCategories.KNOCKDOWN_WAKEUP.universalOrdinal()].setSkill((Skill)EpicFightSkills.KNOCKDOWN_WAKEUP.get());
        }
    }

    private static Pair<ResourceLocation, CompoundTag> parseParameters(Map.Entry<ResourceLocation, JsonElement> entry) {
        try {
            CompoundTag tag = TagParser.parseTag((String)entry.getValue().toString());
            tag.putString("id", entry.getKey().toString());
            SKILL_PARAMS.add(tag);
            return Pair.of((Object)entry.getKey(), (Object)tag);
        }
        catch (CommandSyntaxException e) {
            EpicFightMod.LOGGER.warn("Can't parse skill parameter for " + String.valueOf(entry.getKey()) + " because of " + e.getMessage());
            e.printStackTrace();
            return Pair.of((Object)entry.getKey(), (Object)new CompoundTag());
        }
    }

    public static SkillReloadListener getInstance() {
        return INSTANCE;
    }

    public SkillReloadListener() {
        super(GSON, "skill_parameters");
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectIn, ResourceManager resourceManager, ProfilerFiller profileFiller) {
        SKILL_PARAMS.clear();
        objectIn.entrySet().stream().filter(entry -> {
            if (!EpicFightRegistries.SKILL.containsKey((ResourceLocation)entry.getKey())) {
                EpicFightMod.LOGGER.warn("Skill " + String.valueOf(entry.getKey()) + " doesn't exist in the registry.");
                return false;
            }
            return true;
        }).map(SkillReloadListener::parseParameters).forEach(pair -> ((Skill)EpicFightRegistries.SKILL.get((ResourceLocation)pair.getFirst())).loadDatapackParameters((CompoundTag)pair.getSecond()));
    }
}

