/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.event;

import yesman.epicfight.api.event.Event;
import yesman.epicfight.api.event.EventContext;
import yesman.epicfight.api.event.EventHook;
import yesman.epicfight.api.event.EventListener;
import yesman.epicfight.api.event.subscriptions.ContextAwareEventSubscription;
import yesman.epicfight.api.event.subscriptions.DefaultEventSubscription;
import yesman.epicfight.api.event.subscriptions.EventSubscription;

public class CancelableEventHook<T extends Event>
extends EventHook<T> {
    @Override
    public boolean post(T eventInstance) {
        EventContext eventContext = ((Event)eventInstance).getEventContext();
        for (EventListener subscriber : this.subscriptions.values()) {
            eventContext.subscriptionStart(subscriber.name());
            EventSubscription eventSubscription = subscriber.subscription();
            if (eventSubscription instanceof DefaultEventSubscription) {
                DefaultEventSubscription passiveSubscription = (DefaultEventSubscription)eventSubscription;
                if (((Event)eventInstance).hasCanceled()) continue;
                passiveSubscription.fire(eventInstance);
                eventContext.onCalled();
                continue;
            }
            eventSubscription = subscriber.subscription();
            if (!(eventSubscription instanceof ContextAwareEventSubscription)) continue;
            ContextAwareEventSubscription contextAwareSubscription = (ContextAwareEventSubscription)eventSubscription;
            contextAwareSubscription.fire(eventInstance, eventContext);
            eventContext.onCalled();
        }
        eventContext.subscriptionEnd();
        return ((Event)eventInstance).hasCanceled();
    }

    public void registerContextAwareEvent(ContextAwareEventSubscription<T> subscription) {
        this.registerContextAwareEvent(subscription, CancelableEventHook.getDefaultSubscriberName(), 0);
    }

    public void registerContextAwareEvent(ContextAwareEventSubscription<T> subscription, int priority) {
        this.registerContextAwareEvent(subscription, CancelableEventHook.getDefaultSubscriberName(), priority);
    }

    public void registerContextAwareEvent(ContextAwareEventSubscription<T> subscription, String name) {
        this.registerContextAwareEvent(subscription, name, 0);
    }

    public void registerContextAwareEvent(ContextAwareEventSubscription<T> subscription, String name, int priority) {
        this.subscriptions.put(priority, new EventListener<T>(name, subscription));
    }

    public static <T extends Event> CancelableEventHook<T> createCancelableEventHook() {
        return new CancelableEventHook<T>();
    }
}

