/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import yesman.epicfight.api.utils.math.QuaternionUtils;
import yesman.epicfight.api.utils.math.Vec2i;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPCreateTerrainFracture;
import yesman.epicfight.registry.entries.EpicFightParticles;
import yesman.epicfight.registry.entries.EpicFightSounds;
import yesman.epicfight.world.damagesource.EpicFightDamageSources;
import yesman.epicfight.world.damagesource.EpicFightDamageTypeTags;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.level.block.FractureBlock;
import yesman.epicfight.world.level.block.FractureBlockState;

public class LevelUtil {
    private static final Vec3 IMPACT_DIRECTION = new Vec3(0.0, -1.0, 0.0);

    public static int calculateLivingEntityFallDamage(LivingEntity livingEntity, float distance, float modifier) {
        if (livingEntity.getType().is(EntityTypeTags.FALL_DAMAGE_IMMUNE)) {
            return 0;
        }
        MobEffectInstance mobeffectinstance = livingEntity.getEffect(MobEffects.JUMP);
        float f = mobeffectinstance == null ? 0.0f : (float)(mobeffectinstance.getAmplifier() + 1);
        return Mth.ceil((float)((distance - 3.0f - f) * modifier));
    }

    public static void spreadShockwave(Level level, Vec3 center, Vec3 direction, double length, int edgeX, int edgeZ, List<Entity> entityBeingHit) {
        Vec3 edgeOfShockwave = center.add(direction.normalize().scale((double)((float)length)));
        int xFrom = (int)Math.min(Math.floor(center.x), (double)edgeX);
        int xTo = (int)Math.max(Math.floor(center.x), (double)edgeX);
        int zFrom = (int)Math.min(Math.floor(center.z), (double)edgeZ);
        int zTo = (int)Math.max(Math.floor(center.z), (double)edgeZ);
        ArrayList affectedBlocks = Lists.newArrayList();
        List entitiesInArea = level.isClientSide ? null : level.getEntities(null, new AABB((double)xFrom, center.y - length, (double)zFrom, (double)xTo, center.y + length, (double)zTo));
        double bounceExponentCoef = Math.min(1.0 / (length * length), 0.1);
        for (int k = zFrom; k <= zTo; ++k) {
            for (int l = xFrom; l <= xTo; ++l) {
                Vec2i blockCoord = new Vec2i(l, k);
                if (!LevelUtil.isBlockOverlapLine(blockCoord, center, edgeOfShockwave)) continue;
                affectedBlocks.add(blockCoord);
            }
        }
        affectedBlocks.sort((v1, v2) -> {
            double v2DistSqr;
            double v1DistSqr = Math.pow((double)v1.x - center.x, 2.0) + Math.pow((double)v1.y - center.z, 2.0);
            if (v1DistSqr > (v2DistSqr = Math.pow((double)v2.x - center.x, 2.0) + Math.pow((double)v2.y - center.z, 2.0))) {
                return 1;
            }
            if (v1DistSqr == v2DistSqr) {
                return 0;
            }
            return -1;
        });
        double y = center.y;
        for (Vec2i block : affectedBlocks) {
            Vec3 blockCenter;
            Vec3 centerToBlock;
            double distance;
            BlockState aboveState;
            BlockPos.MutableBlockPos bp = new BlockPos.MutableBlockPos((double)block.x, y, (double)block.y);
            BlockState bs = level.getBlockState((BlockPos)bp);
            BlockPos aboveBp = bp.above();
            if (LevelUtil.canTransferShockWave(level, aboveBp, aboveState = level.getBlockState(aboveBp))) {
                BlockState aboveTwoState;
                BlockPos aboveTwoBp = aboveBp.above();
                if (LevelUtil.canTransferShockWave(level, aboveTwoBp, aboveTwoState = level.getBlockState(aboveTwoBp))) break;
                y += 1.0;
                bp = aboveBp;
                bs = aboveState;
            } else if (!level.isClientSide && aboveState.getCollisionShape((BlockGetter)level, aboveBp, CollisionContext.empty()).isEmpty() && level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                level.destroyBlock(aboveBp, level.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS));
            }
            if (!LevelUtil.canTransferShockWave(level, (BlockPos)bp, bs)) {
                BlockState belowState;
                BlockPos belowBp = bp.below();
                if (!LevelUtil.canTransferShockWave(level, belowBp, belowState = level.getBlockState(belowBp))) break;
                y -= 1.0;
                bp = belowBp;
                bs = belowState;
            }
            if (length < (distance = (centerToBlock = (blockCenter = new Vec3((double)bp.getX() + 0.5, (double)bp.getY(), (double)bp.getZ() + 0.5)).subtract(center)).horizontalDistance())) continue;
            if (level.isClientSide) {
                if (!LevelUtil.canTransferShockWave(level, (BlockPos)bp, bs) || bs instanceof FractureBlockState || bs.getBlock() instanceof EntityBlock) continue;
                Vec3 rotAxis = IMPACT_DIRECTION.cross(centerToBlock).normalize();
                Vector3f axis = new Vector3f((float)rotAxis.x, (float)rotAxis.y, (float)rotAxis.z);
                Vector3f translator = new Vector3f(0.0f, Math.max(0.0f, (float)(distance / length) - 0.5f) * 0.5f, 0.0f);
                Quaternionf rotator = QuaternionUtils.rotationDegrees(axis, (float)(distance / length) * 15.0f + level.random.nextFloat() * 10.0f - 5.0f);
                rotator.mul((Quaternionfc)QuaternionUtils.XP.rotationDegrees(level.random.nextFloat() * 15.0f - 7.5f));
                rotator.mul((Quaternionfc)QuaternionUtils.YP.rotationDegrees(level.random.nextFloat() * 40.0f - 20.0f));
                rotator.mul((Quaternionfc)QuaternionUtils.ZP.rotationDegrees(level.random.nextFloat() * 15.0f - 7.5f));
                int lifeTime = 30 + level.random.nextInt((int)length * 80);
                double bouncing = Math.pow(distance, 2.0) * bounceExponentCoef;
                FractureBlockState fractureBlockState = FractureBlock.getDefaultFractureBlockState(null);
                fractureBlockState.setFractureInfo((BlockPos)bp, bs, translator, rotator, bouncing, lifeTime);
                level.setBlock((BlockPos)bp, (BlockState)fractureBlockState, 0);
                if (!bs.shouldSpawnTerrainParticles()) continue;
                LevelUtil.createParticle(level, (BlockPos)bp, bs);
                continue;
            }
            for (Entity entity : entitiesInArea) {
                boolean inSameY;
                boolean bl = inSameY = (double)(bp.getY() + 1) >= entity.getY() && (double)bp.getY() <= entity.getY();
                if (bp.getX() != entity.getBlockX() || !inSameY || bp.getZ() != entity.getBlockZ() || entityBeingHit.contains(entity)) continue;
                entityBeingHit.add(entity);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void createParticle(Level level, BlockPos bp, BlockState bs) {
        for (int i = 0; i < 4; i += level.getRandom().nextInt(4)) {
            double x = bp.getX() + i % 2;
            double z = bp.getZ() + 1 - i % 2;
            TerrainParticle blockParticle = new TerrainParticle((ClientLevel)level, x, (double)(bp.getY() + 1), z, 0.0, 0.0, 0.0, bs, bp);
            blockParticle.setParticleSpeed((Math.random() - 0.5) * 0.3, Math.random() * 0.5, (Math.random() - 0.5) * 0.3);
            blockParticle.setLifetime(10 + new Random().nextInt(60));
            Minecraft mc = Minecraft.getInstance();
            mc.particleEngine.add((Particle)blockParticle);
        }
    }

    public static boolean circleSlamFracture(@Nullable LivingEntity caster, Level level, Vec3 center, double radius) {
        return LevelUtil.circleSlamFracture(caster, level, center, radius, false, false, true);
    }

    public static boolean circleSlamFracture(@Nullable LivingEntity caster, Level level, Vec3 center, double radius, boolean hurtEntities) {
        return LevelUtil.circleSlamFracture(caster, level, center, radius, false, false, hurtEntities);
    }

    public static boolean circleSlamFracture(@Nullable LivingEntity caster, Level level, Vec3 center, double radius, boolean noSound, boolean noParticle) {
        return LevelUtil.circleSlamFracture(caster, level, center, radius, noSound, noParticle, true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean circleSlamFracture(@Nullable LivingEntity caster, ClientLevel level, Vec3 center, double radius, boolean noSound, boolean noParticle) {
        return LevelUtil.circleSlamFracture(caster, (Level)level, center, radius, noSound, noParticle, true);
    }

    public static boolean circleSlamFracture(@Nullable LivingEntity caster, Level level, Vec3 center, double radius, boolean noSound, boolean noParticle, boolean hurtEntities) {
        Vec3 closestEdge = new Vec3((double)Math.round(center.x), Math.floor(center.y), (double)Math.round(center.z));
        Vec3 centerOfBlock = new Vec3(Math.floor(center.x) + 0.5, Math.floor(center.y), Math.floor(center.z) + 0.5);
        center = closestEdge.distanceToSqr(center) < centerOfBlock.distanceToSqr(center) ? closestEdge : centerOfBlock;
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(center.x, center.y, center.z);
        BlockState originBlockState = level.getBlockState((BlockPos)blockPos);
        if (!LevelUtil.canTransferShockWave(level, (BlockPos)blockPos, originBlockState)) {
            return false;
        }
        radius = Math.max(0.5, radius);
        if (!level.isClientSide) {
            EpicFightNetworkManager.sendToAllPlayerTrackingThisChunkWithSelf(new SPCreateTerrainFracture(center, radius, noSound, noParticle), (ServerLevel)level, new ChunkPos((BlockPos)blockPos), new CustomPacketPayload[0]);
        }
        int xFrom = (int)Math.floor(center.x - radius);
        int xTo = (int)Math.ceil(center.x + radius);
        int zFrom = (int)Math.floor(center.z - radius);
        int zTo = (int)Math.ceil(center.z + radius);
        ArrayList entityBeingHit = Lists.newArrayList();
        for (int i = zFrom; i <= zTo; ++i) {
            for (int j = xFrom; j <= xTo; j += i == zFrom || i == zTo ? 1 : xTo - xFrom) {
                Vec3 direction = new Vec3((double)j - center.x + 0.1, 0.0, (double)i - center.z);
                LevelUtil.spreadShockwave(level, center, direction, radius, j, i, entityBeingHit);
            }
        }
        if (!level.isClientSide && hurtEntities) {
            for (Entity entity : entityBeingHit) {
                if (entity.is((Entity)caster)) continue;
                double damageInflict = 1.0 - (entity.position().distanceTo(center) - radius * 0.5) / radius;
                float damage = (float)(radius * 2.0 * Math.min(damageInflict, 1.0));
                entity.hurt((DamageSource)EpicFightDamageSources.shockwave(caster).setAnimation(Animations.EMPTY_ANIMATION).setInitialPosition(center).addRuntimeTag(EpicFightDamageTypeTags.FINISHER).addRuntimeTag((TagKey<DamageType>)DamageTypeTags.IS_EXPLOSION).setStunType(StunType.KNOCKDOWN), damage);
            }
        } else {
            boolean smallSlam;
            boolean bl = smallSlam = radius < 1.5;
            if (!noSound) {
                level.playLocalSound(center.x, center.y, center.z, smallSlam ? (SoundEvent)EpicFightSounds.SLAM_LIGHT.get() : (SoundEvent)EpicFightSounds.SLAM_HEAVY.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            if (!smallSlam && !noParticle) {
                level.addParticle((ParticleOptions)EpicFightParticles.GROUND_SLAM.get(), center.x, center.y, center.z, 1.0, radius * 10.0, 0.5);
            }
        }
        return true;
    }

    public static boolean canTransferShockWave(Level level, BlockPos blockPos, BlockState blockState) {
        return Block.isFaceFull((VoxelShape)blockState.getCollisionShape((BlockGetter)level, blockPos, CollisionContext.empty()), (Direction)Direction.DOWN) || blockState instanceof FractureBlockState;
    }

    private static boolean isBlockOverlapLine(Vec2i vec2, Vec3 from, Vec3 to) {
        return LevelUtil.isLinesCross(vec2.x, vec2.y, vec2.x + 1, vec2.y, from.x, from.z, to.x, to.z) || LevelUtil.isLinesCross(vec2.x, vec2.y, vec2.x, vec2.y + 1, from.x, from.z, to.x, to.z) || LevelUtil.isLinesCross(vec2.x + 1, vec2.y, vec2.x + 1, vec2.y + 1, from.x, from.z, to.x, to.z) || LevelUtil.isLinesCross(vec2.x, vec2.y + 1, vec2.x + 1, vec2.y + 1, from.x, from.z, to.x, to.z);
    }

    private static boolean isLinesCross(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        double u = ((x4 - x3) * (y1 - y3) - (y4 - y3) * (x1 - x3)) / ((x2 - x1) * (y4 - y3) - (x4 - x3) * (y2 - y1));
        double v = ((x2 - x1) * (y1 - y3) - (y2 - y1) * (x1 - x3)) / ((x2 - x1) * (y4 - y3) - (x4 - x3) * (y2 - y1));
        return 0.0 < u && u < 1.0 && 0.0 < v && v < 1.0;
    }
}

