/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.events;

import com.mojang.datafixers.util.Pair;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.UseAnim;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.LogicalSide;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import yesman.epicfight.api.client.camera.EpicFightCameraAPI;
import yesman.epicfight.api.data.reloader.ItemCapabilityReloadListener;
import yesman.epicfight.api.neoevent.playerpatch.StartActionEvent;
import yesman.epicfight.client.events.engine.ControlEngine;
import yesman.epicfight.client.events.engine.RenderEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.WeaponTypeReloadListener;
import yesman.epicfight.world.gamerule.EpicFightGameRules;
import yesman.epicfight.world.level.block.FractureBlockState;

@EventBusSubscriber(modid="epicfight", value={Dist.CLIENT})
public final class ClientEvents {
    private static final Pair<ResourceLocation, ResourceLocation> OFFHAND_TEXTURE = Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_SHIELD);
    private static final Minecraft MINECRAFT = Minecraft.getInstance();
    @Deprecated
    public static ClientboundRespawnPacket packet;

    private ClientEvents() {
    }

    @SubscribeEvent
    public static void epicfight$mouseButtonPressedInScreenPre(ScreenEvent.MouseButtonPressed.Pre event) {
        CapabilityItem cap;
        Slot slot;
        if (event.getScreen() instanceof AbstractContainerScreen && (slot = ((AbstractContainerScreen)event.getScreen()).getSlotUnderMouse()) != null && !(cap = EpicFightCapabilities.getItemStackCapability(ClientEvents.MINECRAFT.player.containerMenu.getCarried())).canBePlacedOffhand() && slot.getNoItemIcon() != null && slot.getNoItemIcon().equals(OFFHAND_TEXTURE)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void epicfight$mouseButtonReleasedInScreenPre(ScreenEvent.MouseButtonReleased.Pre event) {
        CapabilityItem cap;
        Slot slot;
        if (event.getScreen() instanceof AbstractContainerScreen && (slot = ((AbstractContainerScreen)event.getScreen()).getSlotUnderMouse()) != null && !(cap = EpicFightCapabilities.getItemStackCapability(ClientEvents.MINECRAFT.player.containerMenu.getCarried())).canBePlacedOffhand() && slot.getNoItemIcon() != null && slot.getNoItemIcon().equals(OFFHAND_TEXTURE)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void epicfight$keyPressedInScreenPre(ScreenEvent.KeyPressed.Pre event) {
        Slot slot;
        CapabilityItem itemCapability = CapabilityItem.EMPTY;
        if (event.getKeyCode() == ClientEvents.MINECRAFT.options.keySwapOffhand.getKey().getValue()) {
            Slot slot2;
            if (event.getScreen() instanceof AbstractContainerScreen && (slot2 = ((AbstractContainerScreen)event.getScreen()).getSlotUnderMouse()) != null && slot2.hasItem() && !(itemCapability = EpicFightCapabilities.getItemStackCapability(slot2.getItem())).canBePlacedOffhand()) {
                event.setCanceled(true);
            }
        } else if (event.getKeyCode() >= 49 && event.getKeyCode() <= 57 && event.getScreen() instanceof AbstractContainerScreen && (slot = ((AbstractContainerScreen)event.getScreen()).getSlotUnderMouse()) != null && slot.getNoItemIcon() != null && slot.getNoItemIcon().equals(OFFHAND_TEXTURE) && !(itemCapability = EpicFightCapabilities.getItemStackCapability(ClientEvents.MINECRAFT.player.getInventory().getItem(event.getKeyCode() - 49))).canBePlacedOffhand()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void epicfight$rightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (event.getSide() == LogicalSide.SERVER) {
            return;
        }
        EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)event.getEntity(), LocalPlayerPatch.class).ifPresent(playerpatch -> {
            if (!playerpatch.getEntityState().canUseItem()) {
                event.setCanceled(true);
            } else if (((LocalPlayer)playerpatch.getOriginal()).getOffhandItem().getUseAnimation() == UseAnim.NONE) {
                boolean canceled = playerpatch.getPlayerSkills().fireSkillEvents("epicfight", event).isCanceled();
                if (playerpatch.getEntityState().movementLocked()) {
                    canceled = true;
                }
                event.setCanceled(canceled);
            }
            if (!event.isCanceled()) {
                EpicFightCameraAPI.getInstance().onItemUseEvent(event.getEntity(), (PlayerPatch<?>)playerpatch, event.getItemStack(), event.getHand());
            }
        });
    }

    @SubscribeEvent
    public static void epicfight$loggingIn(ClientPlayerNetworkEvent.LoggingIn event) {
        EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)event.getPlayer(), LocalPlayerPatch.class).ifPresent(entitypatch -> {
            ControlEngine.getInstance().reloadPlayerPatch((LocalPlayerPatch)entitypatch);
            RenderEngine.getInstance().initHUD((LocalPlayerPatch)entitypatch);
        });
    }

    @SubscribeEvent
    public static void epicfight$clonePlayer(ClientPlayerNetworkEvent.Clone event) {
        LocalPlayerPatch oldCap = EpicFightCapabilities.getEntityPatch((Entity)event.getOldPlayer(), LocalPlayerPatch.class);
        LocalPlayerPatch newCap = EpicFightCapabilities.getEntityPatch((Entity)event.getNewPlayer(), LocalPlayerPatch.class);
        if (oldCap != null && newCap != null) {
            if (packet != null && packet.shouldKeep((byte)3)) {
                event.getNewPlayer().tickCount = event.getOldPlayer().tickCount;
                newCap.copyOldData(oldCap, false);
            }
            packet = null;
            newCap.onRespawnLocalPlayer(event);
            newCap.toMode(oldCap.getPlayerMode(), false);
        }
        EpicFightGameRules.GAME_RULES.values().forEach(gamerule -> {
            Object val = gamerule.getRuleValue(event.getOldPlayer().level());
            gamerule.setRuleValue(event.getNewPlayer().level(), val);
        });
        ControlEngine.getInstance().reloadPlayerPatch(newCap);
        RenderEngine.getInstance().initHUD(newCap);
    }

    @SubscribeEvent
    public static void epicfight$loggingOut(ClientPlayerNetworkEvent.LoggingOut event) {
        if (event.getPlayer() != null) {
            ItemCapabilityReloadListener.reset();
            EpicFightCapabilities.ITEM_CAPABILITY_PROVIDER.clear();
            EpicFightCapabilities.ENTITY_PATCH_PROVIDER.clearDatapackEntities();
            WeaponTypeReloadListener.clear();
            RenderEngine.getInstance().clear();
            FractureBlockState.reset();
        }
    }

    @SubscribeEvent
    public static void epicfight$startActionEvent(StartActionEvent event) {
        event.runOnLocalClient(playerpatch -> ControlEngine.getInstance().unlockHotkeys());
    }
}

