/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.events.engine;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.LogicalSide;
import net.neoforged.fml.ModLoader;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.CustomizeGuiOverlayEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RenderFrameEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.RenderHandEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.RenderLivingEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.animation.AnimationSubFileReader;
import yesman.epicfight.api.client.camera.EpicFightCameraAPI;
import yesman.epicfight.api.client.input.InputManager;
import yesman.epicfight.api.client.input.action.EpicFightInputAction;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.client.neoevent.PatchedRenderersEvent;
import yesman.epicfight.api.client.neoevent.RenderEnderDragonEvent;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.events.engine.IEventBasedEngine;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.client.gui.EntityUI;
import yesman.epicfight.client.gui.VersionNotifier;
import yesman.epicfight.client.gui.screen.overlay.OverlayManager;
import yesman.epicfight.client.input.EpicFightKeyMappings;
import yesman.epicfight.client.mesh.HumanoidMesh;
import yesman.epicfight.client.mesh.PiglinMesh;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;
import yesman.epicfight.client.renderer.FakeBlockRenderer;
import yesman.epicfight.client.renderer.FirstPersonRenderer;
import yesman.epicfight.client.renderer.VanillaFakeBlockRenderer;
import yesman.epicfight.client.renderer.patched.entity.PCreeperRenderer;
import yesman.epicfight.client.renderer.patched.entity.PCustomEntityRenderer;
import yesman.epicfight.client.renderer.patched.entity.PCustomHumanoidEntityRenderer;
import yesman.epicfight.client.renderer.patched.entity.PDrownedRenderer;
import yesman.epicfight.client.renderer.patched.entity.PEnderDragonRenderer;
import yesman.epicfight.client.renderer.patched.entity.PEndermanRenderer;
import yesman.epicfight.client.renderer.patched.entity.PHoglinRenderer;
import yesman.epicfight.client.renderer.patched.entity.PHumanoidRenderer;
import yesman.epicfight.client.renderer.patched.entity.PIllagerRenderer;
import yesman.epicfight.client.renderer.patched.entity.PIronGolemRenderer;
import yesman.epicfight.client.renderer.patched.entity.PPlayerRenderer;
import yesman.epicfight.client.renderer.patched.entity.PRavagerRenderer;
import yesman.epicfight.client.renderer.patched.entity.PSpiderRenderer;
import yesman.epicfight.client.renderer.patched.entity.PStrayRenderer;
import yesman.epicfight.client.renderer.patched.entity.PVexRenderer;
import yesman.epicfight.client.renderer.patched.entity.PVindicatorRenderer;
import yesman.epicfight.client.renderer.patched.entity.PWitchRenderer;
import yesman.epicfight.client.renderer.patched.entity.PWitherRenderer;
import yesman.epicfight.client.renderer.patched.entity.PWitherSkeletonMinionRenderer;
import yesman.epicfight.client.renderer.patched.entity.PZombieVillagerRenderer;
import yesman.epicfight.client.renderer.patched.entity.PatchedEntityRenderer;
import yesman.epicfight.client.renderer.patched.entity.PatchedLivingEntityRenderer;
import yesman.epicfight.client.renderer.patched.entity.PresetRenderer;
import yesman.epicfight.client.renderer.patched.entity.WitherGhostCloneRenderer;
import yesman.epicfight.client.renderer.patched.item.RenderFilledMap;
import yesman.epicfight.client.renderer.patched.item.RenderItemBase;
import yesman.epicfight.client.renderer.patched.item.RenderKatana;
import yesman.epicfight.client.renderer.patched.item.RenderShield;
import yesman.epicfight.client.renderer.patched.item.RenderTrident;
import yesman.epicfight.client.renderer.patched.item.RenderTwoHandedRangedWeapon;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.config.ClientConfig;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.registry.entries.EpicFightEntityTypes;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.boss.BossPatch;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.EnderDragonPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.BowCapability;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.CrossbowCapability;
import yesman.epicfight.world.capabilities.item.MapCapability;
import yesman.epicfight.world.capabilities.item.ShieldCapability;
import yesman.epicfight.world.capabilities.item.TridentCapability;
import yesman.epicfight.world.gamerule.EpicFightGameRules;

public class RenderEngine
implements IEventBasedEngine {
    private static final RenderEngine INSTANCE = new RenderEngine();
    public final BattleModeGui battleModeHUD;
    public final VersionNotifier versionNotifier;
    public final Minecraft minecraft;
    private final BiMap<EntityType<?>, Function<EntityType<?>, PatchedEntityRenderer>> entityRendererProvider;
    private final Map<EntityType<?>, PatchedEntityRenderer> entityRendererCache;
    private final Map<Item, RenderItemBase> itemRendererMapByInstance;
    private final Map<Class<?>, RenderItemBase> itemRendererMapByClass;
    private final Map<UUID, BossPatch> bossEventOwners = new ConcurrentHashMap<UUID, BossPatch>();
    private final OverlayManager overlayManager;
    private FakeBlockRenderer fakeBlockRenderer;
    private Map<ResourceLocation, Function<JsonElement, RenderItemBase>> itemRenderers;
    private FirstPersonRenderer firstPersonRenderer;
    private PHumanoidRenderer<?, ?, ?, ?, ?> basicHumanoidRenderer;
    private int modelInitTimer;
    private static final Vector3f CAMERA_ROTATION_EULER = new Vector3f();
    private static final OpenMatrix4f PLAYER_ROTATION = new OpenMatrix4f();
    private static final ResourceLocation YELLOWBAR_BACKGROUND = ResourceLocation.withDefaultNamespace((String)"boss_bar/yellow_background");
    private static final ResourceLocation YELLOWBAR_PROGRESS = ResourceLocation.withDefaultNamespace((String)"boss_bar/yellow_progress");
    private static final ResourceLocation GUI_ICONS = ResourceLocation.withDefaultNamespace((String)"textures/gui/icons.png");

    public static RenderEngine getInstance() {
        return INSTANCE;
    }

    private RenderEngine() {
        this.minecraft = Minecraft.getInstance();
        this.battleModeHUD = new BattleModeGui(this.minecraft);
        this.versionNotifier = new VersionNotifier(this.minecraft);
        this.entityRendererProvider = HashBiMap.create();
        this.entityRendererCache = new HashMap();
        this.itemRendererMapByInstance = new HashMap<Item, RenderItemBase>();
        this.itemRendererMapByClass = new HashMap();
        this.overlayManager = new OverlayManager();
        this.fakeBlockRenderer = new VanillaFakeBlockRenderer();
    }

    public void initialize() {
        HashMap<ResourceLocation, Function<JsonElement, RenderItemBase>> builder = new HashMap<ResourceLocation, Function<JsonElement, RenderItemBase>>();
        builder.put(ResourceLocation.withDefaultNamespace((String)"base"), RenderItemBase::new);
        builder.put(ResourceLocation.withDefaultNamespace((String)"ranged"), RenderTwoHandedRangedWeapon::new);
        builder.put(ResourceLocation.withDefaultNamespace((String)"map"), RenderFilledMap::new);
        builder.put(ResourceLocation.withDefaultNamespace((String)"shield"), RenderShield::new);
        builder.put(ResourceLocation.withDefaultNamespace((String)"trident"), RenderTrident::new);
        builder.put(EpicFightMod.identifier("uchigatana"), RenderKatana::new);
        ModLoader.postEvent((Event)new PatchedRenderersEvent.RegisterItemRenderer(builder));
        this.itemRenderers = ImmutableMap.copyOf(builder);
    }

    public void reloadFakeBlockRenderer(FakeBlockRenderer fakeBlockRenderer) {
        this.fakeBlockRenderer = fakeBlockRenderer;
    }

    public void reloadItemRenderers(Map<ResourceLocation, JsonElement> objects) {
        this.itemRendererMapByInstance.clear();
        this.itemRendererMapByClass.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : objects.entrySet()) {
            Function<JsonElement, RenderItemBase> rendererProvider;
            ResourceLocation rl = entry.getKey();
            String pathString = rl.getPath();
            ResourceLocation registryName = ResourceLocation.fromNamespaceAndPath((String)rl.getNamespace(), (String)pathString);
            if (!BuiltInRegistries.ITEM.containsKey(registryName)) {
                EpicFightMod.LOGGER.warn("Failed to load item skin: no item named " + String.valueOf(registryName));
                continue;
            }
            Item item = (Item)BuiltInRegistries.ITEM.get(registryName);
            if (entry.getValue().getAsJsonObject().has("renderer")) {
                ResourceLocation rendererName = ResourceLocation.parse((String)entry.getValue().getAsJsonObject().get("renderer").getAsString());
                if (this.itemRenderers.containsKey(rendererName)) {
                    rendererProvider = this.itemRenderers.get(rendererName);
                } else {
                    EpicFightMod.LOGGER.warn("No renderer named " + String.valueOf(rendererName));
                    rendererProvider = RenderItemBase::new;
                }
            } else {
                rendererProvider = RenderItemBase::new;
            }
            RenderItemBase itemRenderer = rendererProvider.apply(entry.getValue());
            this.itemRendererMapByInstance.put(item, itemRenderer);
        }
        RenderItemBase baseRenderer = new RenderItemBase((JsonElement)new JsonObject());
        RenderTwoHandedRangedWeapon bowRenderer = new RenderTwoHandedRangedWeapon((JsonElement)objects.get(BuiltInRegistries.ITEM.getKey((Object)Items.BOW)).getAsJsonObject());
        RenderTwoHandedRangedWeapon crossbowRenderer = new RenderTwoHandedRangedWeapon((JsonElement)objects.get(BuiltInRegistries.ITEM.getKey((Object)Items.CROSSBOW)).getAsJsonObject());
        RenderTrident tridentRenderer = new RenderTrident((JsonElement)objects.get(BuiltInRegistries.ITEM.getKey((Object)Items.TRIDENT)).getAsJsonObject());
        RenderFilledMap mapRenderer = new RenderFilledMap((JsonElement)objects.get(BuiltInRegistries.ITEM.getKey((Object)Items.FILLED_MAP)).getAsJsonObject());
        RenderShield shieldRenderer = new RenderShield((JsonElement)objects.get(BuiltInRegistries.ITEM.getKey((Object)Items.SHIELD)).getAsJsonObject());
        this.itemRendererMapByClass.put(BowItem.class, bowRenderer);
        this.itemRendererMapByClass.put(CrossbowItem.class, crossbowRenderer);
        this.itemRendererMapByClass.put(ShieldItem.class, baseRenderer);
        this.itemRendererMapByClass.put(TridentItem.class, tridentRenderer);
        this.itemRendererMapByClass.put(ShieldItem.class, shieldRenderer);
        this.itemRendererMapByClass.put(BowCapability.class, bowRenderer);
        this.itemRendererMapByClass.put(CrossbowCapability.class, crossbowRenderer);
        this.itemRendererMapByClass.put(TridentCapability.class, tridentRenderer);
        this.itemRendererMapByClass.put(MapCapability.class, mapRenderer);
        this.itemRendererMapByClass.put(ShieldCapability.class, shieldRenderer);
    }

    public void resetRenderers() {
        this.entityRendererCache.clear();
        for (Map.Entry entry : this.entityRendererProvider.entrySet()) {
            this.entityRendererCache.put((EntityType)entry.getKey(), (PatchedEntityRenderer)((Function)entry.getValue()).apply((EntityType)entry.getKey()));
        }
        ModLoader.postEvent((Event)new PatchedRenderersEvent.Modify(this.entityRendererCache));
    }

    public void registerCustomEntityRenderer(EntityType<?> entityType, String rendererName, CompoundTag compound) {
        if (StringUtil.isNullOrEmpty((String)rendererName)) {
            return;
        }
        EntityRenderDispatcher erd = this.minecraft.getEntityRenderDispatcher();
        EntityRendererProvider.Context context = new EntityRendererProvider.Context(erd, this.minecraft.getItemRenderer(), this.minecraft.getBlockRenderer(), erd.getItemInHandRenderer(), this.minecraft.getResourceManager(), this.minecraft.getEntityModels(), this.minecraft.font);
        if ("player".equals(rendererName)) {
            this.entityRendererCache.put(entityType, this.basicHumanoidRenderer);
        } else if ("epicfight:custom".equals(rendererName)) {
            if (compound.getBoolean("humanoid")) {
                this.entityRendererCache.put(entityType, new PCustomHumanoidEntityRenderer<HumanoidMesh>(Meshes.getOrCreate(ResourceLocation.parse((String)compound.getString("model")), jsonAssetLoader -> jsonAssetLoader.loadSkinnedMesh(HumanoidMesh::new)), context, entityType));
            } else {
                this.entityRendererCache.put(entityType, new PCustomEntityRenderer(Meshes.getOrCreate(ResourceLocation.parse((String)compound.getString("model")), jsonAssetLoader -> jsonAssetLoader.loadSkinnedMesh(HumanoidMesh::new)), context));
            }
        } else {
            EntityType presetEntityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)rendererName));
            if (this.entityRendererProvider.containsKey((Object)presetEntityType)) {
                PatchedEntityRenderer renderer = (PatchedEntityRenderer)((Function)this.entityRendererProvider.get((Object)presetEntityType)).apply(entityType);
                if (!(this.minecraft.getEntityRenderDispatcher().renderers.get(entityType) instanceof LivingEntityRenderer) && renderer instanceof PatchedLivingEntityRenderer) {
                    PatchedLivingEntityRenderer patchedLivingEntityRenderer = (PatchedLivingEntityRenderer)renderer;
                    this.entityRendererCache.put(entityType, new PresetRenderer(context, entityType, (LivingEntityRenderer<LivingEntity, EntityModel<LivingEntity>>)((LivingEntityRenderer)context.getEntityRenderDispatcher().renderers.get(presetEntityType)), patchedLivingEntityRenderer.getDefaultMesh()));
                } else {
                    this.entityRendererCache.put(entityType, (PatchedEntityRenderer)((Function)this.entityRendererProvider.get((Object)presetEntityType)).apply(entityType));
                }
            } else {
                throw new IllegalArgumentException("Datapack Mob Patch Crash: Invalid Renderer type " + rendererName);
            }
        }
    }

    public RenderItemBase getItemRenderer(ItemStack itemstack) {
        RenderItemBase renderItem = this.itemRendererMapByInstance.get(itemstack.getItem());
        if (renderItem == null) {
            renderItem = this.findMatchingRendererByClass(itemstack.getItem().getClass());
            if (renderItem == null) {
                CapabilityItem itemCap = EpicFightCapabilities.getItemStackCapability(itemstack);
                renderItem = this.findMatchingRendererByClass(itemCap.getClass());
            }
            if (renderItem == null) {
                renderItem = this.itemRendererMapByInstance.get(Items.AIR);
            }
            this.itemRendererMapByInstance.put(itemstack.getItem(), renderItem);
        }
        return renderItem;
    }

    private RenderItemBase findMatchingRendererByClass(Class<?> clazz) {
        RenderItemBase renderer = null;
        while (clazz != null && renderer == null) {
            renderer = this.itemRendererMapByClass.get(clazz);
            clazz = clazz.getSuperclass();
        }
        return renderer;
    }

    public void renderEntityArmatureModel(LivingEntity livingEntity, LivingEntityPatch<?> entitypatch, EntityRenderer<? extends Entity> renderer, MultiBufferSource buffer, PoseStack matStack, int packedLight, float partialTicks) {
        this.getEntityRenderer((Entity)livingEntity).render(livingEntity, entitypatch, renderer, buffer, matStack, packedLight, partialTicks);
    }

    public PatchedEntityRenderer getEntityRenderer(Entity entity) {
        return this.getEntityRenderer(entity.getType());
    }

    public PatchedEntityRenderer getEntityRenderer(EntityType entityType) {
        return this.entityRendererCache.get(entityType);
    }

    public boolean hasRendererFor(Entity entity) {
        return this.entityRendererCache.computeIfAbsent(entity.getType(), key -> this.entityRendererProvider.containsKey(key) ? (PatchedEntityRenderer)((Function)this.entityRendererProvider.get((Object)entity.getType())).apply(entity.getType()) : null) != null;
    }

    public Set<ResourceLocation> getRendererEntries() {
        Set<ResourceLocation> availableRendererEntities = this.entityRendererProvider.keySet().stream().map(entityType -> EntityType.getKey((EntityType)entityType)).collect(Collectors.toSet());
        availableRendererEntities.add(EpicFightMod.identifier("custom"));
        return availableRendererEntities;
    }

    public void setModelInitializerTimer(int tick) {
        this.modelInitTimer = tick;
    }

    public OverlayManager getOverlayManager() {
        return this.overlayManager;
    }

    public FirstPersonRenderer getFirstPersonRenderer() {
        return this.firstPersonRenderer;
    }

    public boolean shouldRenderVanillaModel() {
        return ClientEngine.getInstance().isVanillaModelDebuggingMode() || this.modelInitTimer > 0;
    }

    public void addBossEventOwner(UUID uuid, BossPatch bosspatch) {
        this.bossEventOwners.put(uuid, bosspatch);
    }

    public void removeBossEventOwner(UUID uuid, BossPatch bosspatch) {
        this.bossEventOwners.remove(uuid);
    }

    public void initHUD(LocalPlayerPatch playerpatch) {
        this.battleModeHUD.init(playerpatch);
        this.versionNotifier.init();
    }

    private void freeUnusedSources() {
        this.bossEventOwners.entrySet().removeIf(entry -> {
            Object entity = ((EntityPatch)((BossPatch)entry.getValue()).cast()).getOriginal();
            return !entity.isAlive() || entity.isRemoved();
        });
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> EpicFightRenderTypes.freeUnusedWorldRenderTypes());
        } else {
            EpicFightRenderTypes.freeUnusedWorldRenderTypes();
        }
    }

    public void clear() {
        EpicFightCameraAPI.getInstance().zoomOut(0);
        this.bossEventOwners.clear();
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                this.resetRenderers();
                EpicFightRenderTypes.clearWorldRenderTypes();
            });
        } else {
            this.resetRenderers();
            EpicFightRenderTypes.clearWorldRenderTypes();
        }
    }

    public static boolean hitResultEquals(@Nullable HitResult hitResult, HitResult.Type hitType) {
        return hitResult == null ? false : hitType.equals((Object)hitResult.getType());
    }

    public static boolean hitResultNotEquals(@Nullable HitResult hitResult, HitResult.Type hitType) {
        return hitResult == null ? true : !hitType.equals((Object)hitResult.getType());
    }

    @Deprecated(forRemoval=true)
    public void correctCamera(ViewportEvent.ComputeCameraAngles event, float partialTicks) {
        event.getCamera().setRotation(1.0f, 1.0f);
    }

    @Deprecated(forRemoval=true)
    public void setRangedWeaponThirdPerson(ViewportEvent.ComputeCameraAngles event, CameraType pov, double partialTicks) {
    }

    private void epicfight$renderLivingPre(RenderLivingEvent.Pre<? extends LivingEntity, ? extends EntityModel<? extends LivingEntity>> event) {
        LivingEntity livingentity = event.getEntity();
        if (livingentity.level() == null) {
            return;
        }
        if (this.hasRendererFor((Entity)livingentity)) {
            LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch((Entity)livingentity, LivingEntityPatch.class);
            float originalYRot = 0.0f;
            if ((event.getPartialTick() == 0.0f || event.getPartialTick() == 1.0f) && entitypatch instanceof LocalPlayerPatch) {
                LocalPlayerPatch localPlayerPatch = (LocalPlayerPatch)entitypatch;
                if (entitypatch.overrideRender()) {
                    originalYRot = localPlayerPatch.getModelYRot();
                    localPlayerPatch.setModelYRotInGui(livingentity.getYRot());
                    event.getPoseStack().translate(0.0, 0.1, 0.0);
                    boolean compusteShaderSetting = ClientConfig.activateComputeShader;
                    ClientConfig.activateComputeShader = false;
                    this.renderEntityArmatureModel(livingentity, entitypatch, (EntityRenderer<? extends Entity>)event.getRenderer(), event.getMultiBufferSource(), event.getPoseStack(), event.getPackedLight(), event.getPartialTick());
                    ClientConfig.activateComputeShader = compusteShaderSetting;
                    event.setCanceled(true);
                    localPlayerPatch.disableModelYRotInGui(originalYRot);
                }
                return;
            }
            if (entitypatch != null && entitypatch.overrideRender()) {
                this.renderEntityArmatureModel(livingentity, entitypatch, (EntityRenderer<? extends Entity>)event.getRenderer(), event.getMultiBufferSource(), event.getPoseStack(), event.getPackedLight(), event.getPartialTick());
                if (this.shouldRenderVanillaModel()) {
                    event.getPoseStack().translate(this.modelInitTimer > 0 ? 10000.0f : 1.5f, 0.0f, 0.0f);
                    --this.modelInitTimer;
                } else {
                    event.setCanceled(true);
                }
            }
        }
        if (!this.minecraft.options.hideGui && !EpicFightGameRules.DISABLE_ENTITY_UI.getRuleValue(livingentity.level()).booleanValue()) {
            EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)this.minecraft.player, LocalPlayerPatch.class).ifPresent(playerpatch -> {
                LivingEntityPatch entityPatch = EpicFightCapabilities.getEntityPatch((Entity)livingentity, LivingEntityPatch.class);
                for (EntityUI entityIndicator : EntityUI.ENTITY_UI_LIST) {
                    if (!entityIndicator.shouldDraw(livingentity, entityPatch, (LocalPlayerPatch)playerpatch, event.getPartialTick())) continue;
                    entityIndicator.draw(livingentity, entityPatch, (LocalPlayerPatch)playerpatch, event.getPoseStack(), event.getMultiBufferSource(), event.getPartialTick());
                }
            });
        }
    }

    private void epicfight$itemTooltip(ItemTooltipEvent event) {
        if (ClientConfig.showEpicFightAttributesInTooltip && event.getEntity() != null && event.getEntity().level().isClientSide) {
            EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)event.getEntity(), LocalPlayerPatch.class).ifPresent(playerpatch -> EpicFightCapabilities.getItemCapability(event.getItemStack()).ifPresent(itemCapability -> {
                if (InputManager.isActionPhysicallyActive(EpicFightInputAction.WEAPON_INNATE_SKILL_TOOLTIP)) {
                    Skill weaponInnateSkill = itemCapability.getInnateSkill((PlayerPatch<?>)playerpatch, event.getItemStack());
                    if (weaponInnateSkill != null) {
                        event.getToolTip().clear();
                        List<Component> skilltooltip = weaponInnateSkill.getTooltipOnItem(event.getItemStack(), (CapabilityItem)itemCapability, (PlayerPatch<?>)playerpatch);
                        for (Component s : skilltooltip) {
                            event.getToolTip().add(s);
                        }
                    }
                } else {
                    List tooltip = event.getToolTip();
                    itemCapability.modifyItemTooltip(event.getItemStack(), event.getToolTip(), (LivingEntityPatch<?>)playerpatch);
                    for (int i = 0; i < tooltip.size(); ++i) {
                        MutableComponent mutableComponent$2;
                        ComponentContents patt2$temp;
                        Object patt1$temp;
                        TranslatableContents translatableContent;
                        MutableComponent mutableComponent;
                        ComponentContents patt0$temp;
                        Component sibling;
                        Component textComp = (Component)tooltip.get(i);
                        if (textComp.getSiblings().isEmpty() || !((sibling = (Component)textComp.getSiblings().get(0)) instanceof MutableComponent) || !((patt0$temp = (mutableComponent = (MutableComponent)sibling).getContents()) instanceof TranslatableContents) || (translatableContent = (TranslatableContents)patt0$temp).getArgs().length <= 1 || !((patt1$temp = translatableContent.getArgs()[1]) instanceof MutableComponent) || !((patt2$temp = (mutableComponent$2 = (MutableComponent)patt1$temp).getContents()) instanceof TranslatableContents)) continue;
                        TranslatableContents translatableContent$2 = (TranslatableContents)patt2$temp;
                        if (translatableContent$2.getKey().equals(((Attribute)Attributes.ATTACK_SPEED.value()).getDescriptionId())) {
                            float weaponSpeed = (float)playerpatch.getWeaponAttribute((Holder<Attribute>)Attributes.ATTACK_SPEED, event.getItemStack());
                            tooltip.remove(i);
                            tooltip.add(i, Component.literal((String)String.format(" %.2f ", Float.valueOf(playerpatch.getModifiedAttackSpeed((CapabilityItem)itemCapability, weaponSpeed)))).append((Component)Component.translatable((String)((Attribute)Attributes.ATTACK_SPEED.value()).getDescriptionId())));
                            continue;
                        }
                        if (!translatableContent$2.getKey().equals(((Attribute)Attributes.ATTACK_DAMAGE.value()).getDescriptionId())) continue;
                        float weaponDamage = (float)playerpatch.getWeaponAttribute((Holder<Attribute>)Attributes.ATTACK_DAMAGE, event.getItemStack());
                        String damageFormat = ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(playerpatch.getModifiedBaseDamage(weaponDamage));
                        tooltip.remove(i);
                        tooltip.add(i, Component.literal((String)String.format(" %s ", damageFormat)).append((Component)Component.translatable((String)((Attribute)Attributes.ATTACK_DAMAGE.value()).getDescriptionId())).withStyle(ChatFormatting.DARK_GREEN));
                    }
                    Skill weaponInnateSkill = itemCapability.getInnateSkill((PlayerPatch<?>)playerpatch, event.getItemStack());
                    if (weaponInnateSkill != null) {
                        event.getToolTip().add(Component.translatable((String)"inventory.epicfight.guide_innate_tooltip", (Object[])new Object[]{EpicFightKeyMappings.WEAPON_INNATE_SKILL_TOOLTIP.getKey().getDisplayName()}).withStyle(ChatFormatting.DARK_GRAY));
                    }
                }
            }));
        }
    }

    private void epicfight$computeCameraAngles(ViewportEvent.ComputeCameraAngles event) {
        EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)this.minecraft.player, LocalPlayerPatch.class).ifPresent(playerpatch -> {
            if (ClientConfig.enablePovAction && this.minecraft.options.getCameraType().isFirstPerson() && playerpatch.isEpicFightMode() && !playerpatch.getFirstPersonLayer().isOff()) {
                float partialTick = (float)event.getPartialTick();
                EpicFightCameraAPI cameraApi = EpicFightCameraAPI.getInstance();
                if (cameraApi.isLerpingFpv()) {
                    float xRot = cameraApi.getLerpedFpvXRot(partialTick);
                    float yRot = cameraApi.getLerpedFpvYRot(partialTick);
                    this.minecraft.cameraEntity.setXRot(xRot);
                    this.minecraft.cameraEntity.setYRot(yRot);
                } else {
                    AnimationSubFileReader.PovSettings.ViewLimit viewLimit = playerpatch.getPovSettings().viewLimit();
                    if (viewLimit != null) {
                        float clampedXRot = Mth.clamp((float)event.getPitch(), (float)viewLimit.xRotMin(), (float)viewLimit.xRotMax());
                        float bodyY = MathUtils.findNearestRotation(event.getYaw(), playerpatch.getYRot());
                        float clampedYRot = Mth.clamp((float)event.getYaw(), (float)(bodyY + viewLimit.yRotMin()), (float)(bodyY + viewLimit.yRotMax()));
                        if (Float.compare(clampedXRot, event.getPitch()) != 0 || Float.compare(clampedYRot, event.getYaw()) != 0) {
                            cameraApi.fixFpvRotation(clampedXRot, playerpatch.getYRot(), 5);
                        }
                    }
                }
                if (playerpatch.hasCameraAnimation()) {
                    float time = Mth.lerp((float)partialTick, (float)playerpatch.getFirstPersonLayer().animationPlayer.getPrevElapsedTime(), (float)playerpatch.getFirstPersonLayer().animationPlayer.getElapsedTime());
                    JointTransform cameraTransform = playerpatch.getFirstPersonLayer().animationPlayer.getAnimation().get().isLinkAnimation() || playerpatch.getPovSettings() == null ? playerpatch.getFirstPersonLayer().getLinkCameraTransform().getInterpolatedTransform(time) : playerpatch.getPovSettings().cameraTransform().getInterpolatedTransform(time);
                    float xRot = ((LocalPlayer)playerpatch.getOriginal()).getXRot();
                    float yRot = ((LocalPlayer)playerpatch.getOriginal()).getYRot();
                    Vec3f translation = OpenMatrix4f.transform3v(OpenMatrix4f.ofRotationDegree(yRot, Vec3f.Y_AXIS, PLAYER_ROTATION).rotate(xRot, Vec3f.X_AXIS), cameraTransform.translation(), null);
                    Quaternionf rot = cameraTransform.rotation();
                    rot.getEulerAnglesXYZ(CAMERA_ROTATION_EULER);
                    RenderEngine.CAMERA_ROTATION_EULER.x = (float)Math.toDegrees(RenderEngine.CAMERA_ROTATION_EULER.x);
                    RenderEngine.CAMERA_ROTATION_EULER.y = (float)Math.toDegrees(RenderEngine.CAMERA_ROTATION_EULER.y);
                    RenderEngine.CAMERA_ROTATION_EULER.z = (float)Math.toDegrees(RenderEngine.CAMERA_ROTATION_EULER.z);
                    event.getCamera().move(translation.x, translation.y, translation.z);
                    event.setPitch(event.getPitch() + RenderEngine.CAMERA_ROTATION_EULER.x);
                    event.setYaw(event.getYaw() + RenderEngine.CAMERA_ROTATION_EULER.y);
                    event.setRoll(event.getRoll() + RenderEngine.CAMERA_ROTATION_EULER.z);
                }
            }
        });
    }

    private void epicfight$renderGuiPre(RenderGuiEvent.Pre event) {
        Window window = Minecraft.getInstance().getWindow();
        LocalPlayerPatch playerpatch = ClientEngine.getInstance().getPlayerPatch();
        if (playerpatch != null) {
            playerpatch.getPlayerSkills().listSkillContainers().filter(skillContainer -> skillContainer.getSkill() != null).forEach(skillContainer -> skillContainer.getSkill().onScreen(playerpatch, window.getGuiScaledWidth(), window.getGuiScaledHeight()));
            this.overlayManager.renderTick(window.getGuiScaledWidth(), window.getGuiScaledHeight());
            this.versionNotifier.render(event.getGuiGraphics(), true);
        }
    }

    private void epicfight$bossEventProgress(CustomizeGuiOverlayEvent.BossEventProgress event) {
        Object entitypatch;
        float stunShield;
        if (event.getBossEvent().getName().getString().equals("Ender Dragon") && this.bossEventOwners.containsKey(event.getBossEvent().getId()) && (stunShield = ((LivingEntityPatch)(entitypatch = this.bossEventOwners.get(event.getBossEvent().getId()).cast())).getStunShield()) > 0.0f) {
            float progression = stunShield / ((LivingEntityPatch)entitypatch).getMaxStunShield();
            int x = event.getX();
            int y = event.getY();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            event.getGuiGraphics().blitSprite(YELLOWBAR_BACKGROUND, 182, 5, 0, 0, x, y + 6, 182, 5);
            event.getGuiGraphics().blitSprite(YELLOWBAR_PROGRESS, 182, 5, 0, 0, x, y + 6, (int)(182.0f * progression), 5);
        }
    }

    private void epicfight$renderHand(RenderHandEvent event) {
        LocalPlayerPatch playerpatch = ClientEngine.getInstance().getPlayerPatch();
        if (playerpatch != null && playerpatch.isEpicFightMode() && ClientConfig.enableAnimatedFirstPersonModel) {
            boolean useEpicFightModel;
            RenderItemBase mainhandItemSkin = this.getItemRenderer(((LocalPlayer)playerpatch.getOriginal()).getMainHandItem());
            RenderItemBase offhandItemSkin = this.getItemRenderer(((LocalPlayer)playerpatch.getOriginal()).getOffhandItem());
            boolean bl = useEpicFightModel = !(mainhandItemSkin != null && mainhandItemSkin.forceVanillaFirstPerson() || offhandItemSkin != null && offhandItemSkin.forceVanillaFirstPerson());
            if (useEpicFightModel) {
                if (event.getHand() == InteractionHand.MAIN_HAND) {
                    this.firstPersonRenderer.render((LocalPlayer)playerpatch.getOriginal(), playerpatch, (LivingEntityRenderer<LocalPlayer, PlayerModel<LocalPlayer>>)((LivingEntityRenderer)this.minecraft.getEntityRenderDispatcher().getRenderer((Entity)((LocalPlayer)playerpatch.getOriginal()))), event.getMultiBufferSource(), event.getPoseStack(), event.getPackedLight(), event.getPartialTick());
                }
                event.setCanceled(true);
            }
        }
    }

    private void epicfight$renderAfterLevel(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS && ClientConfig.mineBlockGuideOption.showBlockHighlight() && RenderEngine.hitResultEquals(this.minecraft.hitResult, HitResult.Type.BLOCK)) {
            EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)this.minecraft.player, LocalPlayerPatch.class).ifPresent(playerpatch -> {
                if (!playerpatch.canPlayAttackAnimation() && playerpatch.isEpicFightMode()) {
                    this.fakeBlockRenderer.render(event.getCamera(), event.getPoseStack(), (MultiBufferSource)this.minecraft.renderBuffers().bufferSource(), (Level)this.minecraft.level, ((BlockHitResult)this.minecraft.hitResult).getBlockPos(), 1.0f, 1.0f, 1.0f, 0.4f);
                }
            });
        }
    }

    private void epicfight$renderEnderDragon(RenderEnderDragonEvent event) {
        EnderDragon livingentity = event.getEntity();
        if (this.hasRendererFor((Entity)livingentity)) {
            EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)livingentity, EnderDragonPatch.class).ifPresent(enderdragonpatch -> {
                event.setCanceled(true);
                this.getEntityRenderer((Entity)livingentity).render(livingentity, enderdragonpatch, event.getRenderer(), event.getBuffers(), event.getPoseStack(), event.getLight(), event.getPartialRenderTick());
            });
        }
    }

    private void epicfight$rightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getSide() == LogicalSide.SERVER || !EpicFightCameraAPI.getInstance().isTPSMode()) {
            return;
        }
        EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)this.minecraft.player, LocalPlayerPatch.class).ifPresent(playerpatch -> {
            Vec3 toHit = event.getHitVec().getLocation().subtract(((LocalPlayer)playerpatch.getOriginal()).getEyePosition());
            ((LocalPlayer)playerpatch.getOriginal()).setXRot((float)MathUtils.getXRotOfVector(toHit));
            ((LocalPlayer)playerpatch.getOriginal()).setYRot((float)MathUtils.getYRotOfVector(toHit));
        });
    }

    private void epicfight$renderTickPre(RenderFrameEvent.Pre event) {
        EntityUI.HEALTH_BAR.reset();
    }

    private void epicfight$renderTickPost(RenderFrameEvent.Post event) {
        EntityUI.HEALTH_BAR.remove();
    }

    private void epicfight$clientTick$Pre(ClientTickEvent.Pre event) {
        EpicFightCameraAPI.getInstance().preClientTick();
        EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)this.minecraft.player, LocalPlayerPatch.class).ifPresent(this.battleModeHUD::tick);
        this.freeUnusedSources();
    }

    private void epicfight$clientTick$Post(ClientTickEvent.Post event) {
        EpicFightCameraAPI.getInstance().postClientTick();
    }

    private void epicfight$levelTickPost(LevelTickEvent.Post event) {
        if (!event.getLevel().isClientSide()) {
            return;
        }
        EntityUI.HEALTH_BAR.tick();
    }

    private void epicfight$renderBlockHighlight(RenderHighlightEvent.Block event) {
        EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)this.minecraft.player, LocalPlayerPatch.class).ifPresent(playerpatch -> {
            if (playerpatch.canPlayAttackAnimation()) {
                event.setCanceled(true);
            }
        });
    }

    private void epicfight$renderGuiLayer$Pre(RenderGuiLayerEvent.Pre event) {
        if (event.getName().equals((Object)VanillaGuiLayers.CROSSHAIR)) {
            CameraType cameraType = this.minecraft.options.getCameraType();
            if (event.isCanceled() && cameraType.isFirstPerson()) {
                return;
            }
            if (cameraType.isFirstPerson() || EpicFightCameraAPI.getInstance().isTPSMode()) {
                MutableBoolean itemAction = new MutableBoolean(true);
                if (ClientConfig.mineBlockGuideOption.switchCrosshair()) {
                    EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)this.minecraft.player, LocalPlayerPatch.class).ifPresent(playerpatch -> itemAction.setValue(playerpatch.canPlayAttackAnimation() || playerpatch.isVanillaMode()));
                }
                RenderSystem.enableBlend();
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                if (itemAction.booleanValue()) {
                    event.getGuiGraphics().blitSprite(Gui.CROSSHAIR_SPRITE, (event.getGuiGraphics().guiWidth() - 15) / 2, (event.getGuiGraphics().guiHeight() - 15) / 2, 15, 15);
                } else {
                    event.getGuiGraphics().blit(EntityUI.BATTLE_ICON, (event.getGuiGraphics().guiWidth() - 15) / 2, (event.getGuiGraphics().guiHeight() - 15) / 2, 0, 240, 15, 15);
                }
                RenderSystem.defaultBlendFunc();
                RenderSystem.disableBlend();
                event.setCanceled(true);
            }
        }
    }

    private void epicfight$addLayers(EntityRenderersEvent.AddLayers event) {
        EntityRendererProvider.Context context = event.getContext();
        this.entityRendererProvider.clear();
        this.entityRendererProvider.put((Object)EntityType.CREEPER, entityType -> new PCreeperRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.ENDERMAN, entityType -> new PEndermanRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.ZOMBIE, entityType -> new PHumanoidRenderer((AssetAccessor<HumanoidMesh>)Meshes.BIPED_OLD_TEX, context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.ZOMBIE_VILLAGER, entityType -> new PZombieVillagerRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.ZOMBIFIED_PIGLIN, entityType -> new PHumanoidRenderer((AssetAccessor<PiglinMesh>)Meshes.PIGLIN, context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.HUSK, entityType -> new PHumanoidRenderer((AssetAccessor<HumanoidMesh>)Meshes.BIPED_OLD_TEX, context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.SKELETON, entityType -> new PHumanoidRenderer((AssetAccessor<HumanoidMesh>)Meshes.SKELETON, context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.WITHER_SKELETON, entityType -> new PHumanoidRenderer((AssetAccessor<HumanoidMesh>)Meshes.SKELETON, context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.STRAY, entityType -> new PStrayRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.PLAYER, entityType -> new PPlayerRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.SPIDER, entityType -> new PSpiderRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.CAVE_SPIDER, entityType -> new PSpiderRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.IRON_GOLEM, entityType -> new PIronGolemRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.VINDICATOR, entityType -> new PVindicatorRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.EVOKER, entityType -> new PIllagerRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.WITCH, entityType -> new PWitchRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.DROWNED, entityType -> new PDrownedRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.PILLAGER, entityType -> new PIllagerRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.RAVAGER, entityType -> new PRavagerRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.VEX, entityType -> new PVexRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.PIGLIN, entityType -> new PHumanoidRenderer((AssetAccessor<PiglinMesh>)Meshes.PIGLIN, context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.PIGLIN_BRUTE, entityType -> new PHumanoidRenderer((AssetAccessor<PiglinMesh>)Meshes.PIGLIN, context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.HOGLIN, entityType -> new PHoglinRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.ZOGLIN, entityType -> new PHoglinRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.ENDER_DRAGON, entityType -> new PEnderDragonRenderer());
        this.entityRendererProvider.put((Object)EntityType.WITHER, entityType -> new PWitherRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)((EntityType)EpicFightEntityTypes.WITHER_SKELETON_MINION.get()), entityType -> new PWitherSkeletonMinionRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)((EntityType)EpicFightEntityTypes.WITHER_GHOST_CLONE.get()), entityType -> new WitherGhostCloneRenderer());
        this.firstPersonRenderer = new FirstPersonRenderer(context, EntityType.PLAYER);
        this.basicHumanoidRenderer = new PHumanoidRenderer(Meshes.BIPED, context, EntityType.PLAYER);
        ModLoader.postEvent((Event)new PatchedRenderersEvent.Add((Map<EntityType<?>, Function<EntityType<?>, PatchedEntityRenderer>>)this.entityRendererProvider, context));
        this.resetRenderers();
    }

    @Override
    public void gameEventBus(IEventBus gameEventBus) {
        gameEventBus.addListener(this::epicfight$bossEventProgress);
        gameEventBus.addListener(this::epicfight$renderLivingPre);
        gameEventBus.addListener(this::epicfight$itemTooltip);
        gameEventBus.addListener(this::epicfight$computeCameraAngles);
        gameEventBus.addListener(this::epicfight$renderGuiPre);
        gameEventBus.addListener(this::epicfight$renderHand);
        gameEventBus.addListener(this::epicfight$renderAfterLevel);
        gameEventBus.addListener(this::epicfight$renderEnderDragon);
        gameEventBus.addListener(this::epicfight$rightClickBlock);
        gameEventBus.addListener(this::epicfight$renderTickPre);
        gameEventBus.addListener(this::epicfight$renderTickPost);
        gameEventBus.addListener(this::epicfight$clientTick$Pre);
        gameEventBus.addListener(this::epicfight$clientTick$Post);
        gameEventBus.addListener(this::epicfight$levelTickPost);
        gameEventBus.addListener(this::epicfight$renderBlockHighlight);
        gameEventBus.addListener(this::epicfight$renderGuiLayer$Pre);
    }

    @Override
    public void modEventBus(IEventBus modEventBus) {
        modEventBus.addListener(this::epicfight$addLayers);
    }

    @Deprecated(forRemoval=true)
    public void zoomIn() {
        EpicFightCameraAPI.getInstance().zoomIn();
    }

    @Deprecated(forRemoval=true)
    public void zoomOut(int zoomOutTicks) {
        EpicFightCameraAPI.getInstance().zoomOut(zoomOutTicks);
    }
}

