/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.datapack.screen;

import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringUtil;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.client.gui.datapack.screen.DatapackEditScreen;
import yesman.epicfight.client.gui.datapack.screen.ImportModelScreen;
import yesman.epicfight.client.gui.datapack.screen.MessageScreen;
import yesman.epicfight.client.gui.datapack.widgets.ModelPreviewer;

public class SelectModelScreen
extends Screen {
    private final Screen parentScreen;
    private final ModelList modelList;
    private final ModelPreviewer modelPreviewer;
    private final EditBox searchBox;
    private final BiConsumer<String, AssetAccessor<SkinnedMesh>> selectCallback;
    private final BiConsumer<String, AssetAccessor<SkinnedMesh>> cancelCallback;

    public SelectModelScreen(Screen parentScreen, BiConsumer<String, AssetAccessor<SkinnedMesh>> selectCallback, BiConsumer<String, AssetAccessor<SkinnedMesh>> cancelCallback) {
        super((Component)Component.translatable((String)"gui.epicfight.select.models"));
        this.parentScreen = parentScreen;
        this.minecraft = parentScreen.getMinecraft();
        this.font = parentScreen.getMinecraft().font;
        this.modelPreviewer = new ModelPreviewer(10, 20, 36, 60, null, null, null, null);
        this.modelList = new ModelList(this.minecraft, this.width, this.height - 52, 36, 21);
        this.searchBox = new EditBox(this.font, this.width / 2, 12, this.width / 2 - 12, 16, (Component)Component.literal((String)"datapack_edit.keyword"));
        this.searchBox.setResponder(this.modelList::refreshModelList);
        this.selectCallback = selectCallback;
        this.cancelCallback = cancelCallback;
        this.modelList.refreshModelList(null);
    }

    public void refreshModelList() {
        this.modelList.refreshModelList(this.searchBox.getValue());
    }

    protected void init() {
        int split = this.width / 2 - 80;
        this.modelPreviewer._setWidth(split - 10);
        this.modelPreviewer._setHeight(this.height - 68);
        this.modelPreviewer.resize(null);
        this.modelList.updateSizeAndPosition(this.width - split, this.height - 68, 36);
        this.modelList.setX(split);
        this.searchBox.setX(this.width / 2);
        this.searchBox.setY(12);
        this.searchBox.setWidth(this.width / 2 - 12);
        this.searchBox.setHeight(16);
        this.addRenderableWidget((GuiEventListener)this.searchBox);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"datapack_edit.import_model"), button -> Minecraft.getInstance().setScreen((Screen)new ImportModelScreen(this))).pos(10, 10).size(100, 21).build());
        this.addRenderableWidget(this.modelPreviewer);
        this.addRenderableWidget((GuiEventListener)this.modelList);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_OK, button -> {
            if (this.modelList.getSelected() == null) {
                this.minecraft.setScreen(new MessageScreen("", "Select an item from the list", (Screen)this, button$2 -> this.minecraft.setScreen((Screen)this), 180, 60));
            } else {
                try {
                    this.selectCallback.accept(((ModelList.ModelEntry)this.modelList.getSelected()).registryName, ((ModelList.ModelEntry)this.modelList.getSelected()).mesh);
                    this.onClose();
                }
                catch (Exception e) {
                    this.minecraft.setScreen(new MessageScreen("", e.getMessage(), this.parentScreen, button$2 -> this.minecraft.setScreen(this.parentScreen), 180, 70).autoCalculateHeight());
                }
            }
        }).pos(this.width / 2 - 162, this.height - 28).size(160, 21).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> {
            this.cancelCallback.accept("", null);
            this.onClose();
        }).pos(this.width / 2 + 2, this.height - 28).size(160, 21).build());
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dx, double dy) {
        if (this.modelPreviewer.mouseDragged(mouseX, mouseY, button, dx, dy)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dx, dy);
    }

    public void onClose() {
        this.minecraft.setScreen(this.parentScreen);
        this.modelPreviewer.onDestroy();
    }

    public void tick() {
        this.modelPreviewer._tick();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    class ModelList
    extends ObjectSelectionList<ModelEntry> {
        public ModelList(Minecraft minecraft, int width, int height, int y, int itemHeight) {
            super(minecraft, width, height, y, itemHeight);
        }

        public void setSelected(@Nullable ModelEntry selEntry) {
            super.setSelected((AbstractSelectionList.Entry)selEntry);
            SelectModelScreen.this.modelPreviewer.setMesh(selEntry.mesh);
        }

        public int getRowWidth() {
            return this.width;
        }

        protected int getScrollbarPosition() {
            return this.getRight() - 6;
        }

        protected void renderListBackground(GuiGraphics guiGraphics) {
        }

        protected void renderListSeparators(GuiGraphics guiGraphics) {
        }

        public void refreshModelList(String keyward) {
            this.setScrollAmount(0.0);
            this.children().clear();
            Set skinnedMeshes = Meshes.entry(SkinnedMesh.class);
            DatapackEditScreen.getCurrentScreen().getUserMeshes().values().forEach(accessor -> skinnedMeshes.add(accessor));
            skinnedMeshes.stream().filter(accessor -> StringUtil.isNullOrEmpty((String)keyward) ? true : accessor.registryName().toString().contains(keyward)).map(accessor -> new ModelEntry(accessor.registryName().toString(), (AssetAccessor<SkinnedMesh>)accessor)).sorted((entry$1, entry$2) -> entry$1.registryName.compareTo(entry$2.registryName)).forEach(x$0 -> this.addEntry((AbstractSelectionList.Entry)x$0));
        }

        class ModelEntry
        extends ObjectSelectionList.Entry<ModelEntry> {
            private final String registryName;
            private final AssetAccessor<SkinnedMesh> mesh;

            public ModelEntry(String registryName, AssetAccessor<SkinnedMesh> mesh) {
                this.registryName = registryName;
                this.mesh = mesh;
            }

            public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
                guiGraphics.drawString(((SelectModelScreen)SelectModelScreen.this).minecraft.font, this.registryName, left + 5, top + 5, 0xFFFFFF, false);
            }

            public Component getNarration() {
                return Component.translatable((String)"narrator.select");
            }

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                if (button == 0) {
                    if (ModelList.this.getSelected() == this) {
                        try {
                            SelectModelScreen.this.selectCallback.accept(this.registryName, this.mesh);
                            SelectModelScreen.this.onClose();
                        }
                        catch (Exception e) {
                            SelectModelScreen.this.minecraft.setScreen(new MessageScreen("", e.getMessage(), SelectModelScreen.this.parentScreen, button$2 -> SelectModelScreen.this.minecraft.setScreen(SelectModelScreen.this.parentScreen), 180, 70).autoCalculateHeight());
                        }
                        return true;
                    }
                    ModelList.this.setSelected(this);
                    return true;
                }
                return false;
            }
        }
    }
}

