/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import yesman.epicfight.api.data.reloader.SkillReloadListener;
import yesman.epicfight.client.gui.screen.SkillBookScreen;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPChangeSkill;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.world.capabilities.skill.PlayerSkills;
import yesman.epicfight.world.gamerule.EpicFightGameRules;

public class SkillEditScreen
extends Screen {
    public static final ResourceLocation EMPTY_SKILL_SLOT_ICON = EpicFightMod.identifier("textures/gui/empty.png");
    public static final ResourceLocation SCROLL_ARROW_UP = EpicFightMod.identifier("textures/gui/scroll_arrow_up.png");
    public static final ResourceLocation SCROLL_ARROW_DOWN = EpicFightMod.identifier("textures/gui/scroll_arrow_down.png");
    private static final ResourceLocation SKILL_EDIT_UI = EpicFightMod.identifier("textures/gui/screen/skill_edit.png");
    private static final MutableComponent NO_SKILLS = Component.translatable((String)EpicFightMod.format("gui.%s.no_skills"));
    private static final int MAX_SKILL_OPTIONS_ROWS = 6;
    private static final int MAX_SLOT_ROWS = 9;
    private static final int STRIDE = 18;
    private final Player player;
    private final PlayerSkills skills;
    private final Map<SkillSlot, SlotButton> slotButtons = new LinkedHashMap<SkillSlot, SlotButton>();
    private final List<EquipSkillButton> equipSkillButtons = new ArrayList<EquipSkillButton>();
    private ScrollArrow up;
    private ScrollArrow down;
    private SlotButton selectedSlotButton;
    private int start;
    private int maxScroll;
    private int scroll = 0;

    public SkillEditScreen(Player player, PlayerSkills skills) {
        super((Component)Component.translatable((String)EpicFightMod.format("gui.%s.skill_edit")));
        this.player = player;
        this.skills = skills;
    }

    public void init() {
        this.slotButtons.clear();
        this.equipSkillButtons.clear();
        this.up = null;
        this.down = null;
        this.maxScroll = Math.max(SkillSlot.ENUM_MANAGER.universalValues().stream().filter(skillSlot -> skillSlot.category().learnable()).toList().size() - 9, 0);
        if (this.maxScroll > 0) {
            this.up = new ScrollArrow(this.width / 2 - 95, this.height / 2 - 114, 16, 16, button -> this.scrollUp(), true);
            this.down = new ScrollArrow(this.width / 2 - 95, this.height / 2 + 98, 16, 16, button -> this.scrollDown(), false);
            this.addRenderableWidget((GuiEventListener)this.up);
            this.addRenderableWidget((GuiEventListener)this.down);
        }
        int left = this.width / 2 - 96;
        int top = this.height / 2 - 82;
        for (SkillSlot skillSlot2 : SkillSlot.ENUM_MANAGER.universalValues()) {
            if ((this.player.isCreative() || !this.skills.getSkillContainersFor(skillSlot2.category()).isEmpty()) && skillSlot2.category().learnable()) {
                SkillContainer skillContainer = this.skills.getSkillContainerFor(skillSlot2);
                SlotButton slotButton = new SlotButton(left, top, skillContainer, button -> {
                    this.start = 0;
                    for (Button button2 : this.equipSkillButtons) {
                        this.children().remove(button2);
                    }
                    this.equipSkillButtons.clear();
                    int k = this.width / 2 - 69;
                    MutableInt mutableInt = new MutableInt(this.height / 2 - 78);
                    Stream<Skill> learnedSkill = this.player.isCreative() ? SkillReloadListener.getSkills(skill -> skill.getCategory() == skillSlot2.category()).stream() : this.skills.listAcquiredSkills().filter(skill -> skill.getCategory() == skillSlot2.category());
                    learnedSkill.forEach(skill -> {
                        this.equipSkillButtons.add(new EquipSkillButton(k, widgetHeight.intValue(), 147, 24, (Skill)skill, (Component)Component.translatable((String)skill.getTranslationKey()), replaceSkillButton -> {
                            if (!this.isButtonVisible(replaceSkillButton)) {
                                return;
                            }
                            skillContainer.setSkill((Skill)skill);
                            EpicFightNetworkManager.sendToServer(new CPChangeSkill(skillSlot2, skill.holder(), -1), new CustomPacketPayload[0]);
                            this.skills.addLearnedSkill((Skill)skill);
                            this.onClose();
                        }).setActive(this.skills.getSkillContainer((Skill)skill) == null));
                        widgetHeight.add(26);
                    });
                    for (Button button3 : this.equipSkillButtons) {
                        this.addRenderableWidget((GuiEventListener)button3);
                    }
                    this.selectedSlotButton = (SlotButton)button;
                }, (Component)Component.translatable((String)SkillSlot.ENUM_MANAGER.toTranslated(skillSlot2)));
                this.slotButtons.put(skillSlot2, slotButton);
                this.addRenderableWidget((GuiEventListener)slotButton);
                top += 18;
            }
            this.scroll = 0;
            this.setScrollVisibilities();
        }
        if (this.selectedSlotButton != null) {
            this.selectedSlotButton = this.slotButtons.get(this.selectedSlotButton.skillContainer.getSlot());
            this.selectedSlotButton.onPress();
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        if (this.canScroll()) {
            int scrollPosition = (int)(140.0f * ((float)this.start / (float)(this.equipSkillButtons.size() - 6)));
            guiGraphics.blit(SKILL_EDIT_UI, this.width / 2 + 80, this.height / 2 - 80 + scrollPosition, 12, 15, 231.0f, 2.0f, 12, 15, 256, 256);
        }
        int maxShowingButtons = Math.min(this.equipSkillButtons.size(), 6);
        for (int i = this.start; i < maxShowingButtons + this.start; ++i) {
            this.equipSkillButtons.get(i).render(guiGraphics, mouseX, mouseY, partialTick);
        }
        for (SlotButton sb : this.slotButtons.values()) {
            sb.render(guiGraphics, mouseX, mouseY, partialTick);
        }
        if (this.up != null) {
            this.up.render(guiGraphics, mouseX, mouseY, partialTick);
        }
        if (this.down != null) {
            this.down.render(guiGraphics, mouseX, mouseY, partialTick);
        }
        if (this.slotButtons.isEmpty()) {
            int lineHeight = 0;
            for (FormattedCharSequence s : this.font.split((FormattedText)NO_SKILLS, 140)) {
                guiGraphics.drawString(this.font, s, this.width / 2 - 65, this.height / 2 - 72 + lineHeight, 0x303030, false);
                lineHeight += 10;
            }
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
        guiGraphics.blit(SKILL_EDIT_UI, this.width / 2 - 104, this.height / 2 - 100, 0, 0, 208, 200);
    }

    private boolean canScroll() {
        return this.equipSkillButtons.size() > 6;
    }

    private boolean isButtonVisible(Button button) {
        int buttonOrder = this.equipSkillButtons.indexOf(button);
        return buttonOrder >= this.start && buttonOrder <= this.start + 6;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double xScroll, double yScroll) {
        int left = this.width / 2 - 96;
        int top = this.height / 2 - 82;
        if ((double)left <= mouseX && (double)top <= mouseY && (double)(left + 18) >= mouseX && (double)(top + 162) >= mouseY) {
            if (yScroll > 0.0) {
                this.scrollUp();
            } else {
                this.scrollDown();
            }
            return true;
        }
        if (!this.canScroll()) {
            return false;
        }
        if (yScroll > 0.0) {
            if (this.start > 0) {
                --this.start;
                for (Button button : this.equipSkillButtons) {
                    button.setY(button.getY() + 26);
                }
                return true;
            }
        } else if (this.start < this.equipSkillButtons.size() - 6) {
            ++this.start;
            for (Button button : this.equipSkillButtons) {
                button.setY(button.getY() - 26);
            }
            return true;
        }
        return false;
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void scrollUp() {
        int nextScroll = Mth.clamp((int)(this.scroll - 1), (int)0, (int)this.maxScroll);
        if (this.scroll != nextScroll) {
            this.scroll = nextScroll;
            this.slotButtons.values().forEach(button -> button.setY(button.getY() + 18));
            this.setScrollVisibilities();
        }
    }

    protected void scrollDown() {
        int nextScroll = Mth.clamp((int)(this.scroll + 1), (int)0, (int)this.maxScroll);
        if (this.scroll != nextScroll) {
            this.scroll = nextScroll;
            this.slotButtons.values().forEach(button -> button.setY(button.getY() - 18));
            this.setScrollVisibilities();
        }
    }

    protected void setScrollVisibilities() {
        int i = 0;
        for (SlotButton slotButton : this.slotButtons.values()) {
            slotButton.visible = i >= this.scroll && i < this.scroll + 9;
            ++i;
        }
    }

    class SlotButton
    extends Button {
        private static final int SIZE = 18;
        private final SkillContainer skillContainer;
        private final Component slotExplanation;

        public SlotButton(int x, int y, SkillContainer skillContainer, Button.OnPress pressedAction, Component tooltipMessage) {
            super(x, y, 18, 18, (Component)Component.empty(), pressedAction, Button.DEFAULT_NARRATION);
            this.skillContainer = skillContainer;
            this.slotExplanation = tooltipMessage;
            this.setTooltip(Tooltip.create((Component)this.slotExplanation));
        }

        protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.active = !this.skillContainer.onReplaceCooldown();
            int y = (this.isHoveredOrFocused() || SkillEditScreen.this.selectedSlotButton == this) && !this.skillContainer.onReplaceCooldown() ? 35 : 17;
            guiGraphics.blit(SKILL_EDIT_UI, this.getX(), this.getY(), 237, y, this.width, this.height);
            if (!this.skillContainer.isEmpty()) {
                RenderSystem.enableBlend();
                guiGraphics.blit(this.skillContainer.getSkill().getSkillTexture(), this.getX() + 1, this.getY() + 1, this.getWidth() - 2, this.getHeight() - 2, 0.0f, 0.0f, 128, 128, 128, 128);
                RenderSystem.disableBlend();
            } else {
                guiGraphics.blit(EMPTY_SKILL_SLOT_ICON, this.getX() + 1, this.getY() + 1, this.getWidth() - 2, this.getHeight() - 2, 0.0f, 0.0f, 128, 128, 128, 128);
            }
            if (this.skillContainer.onReplaceCooldown()) {
                int maxCooldown = EpicFightGameRules.SKILL_REPLACE_COOLDOWN.getRuleValue(SkillEditScreen.this.player.level());
                float lerp = Mth.clampedLerp((float)0.0f, (float)16.0f, (float)(1.0f - (float)this.skillContainer.getReplaceCooldown() / (float)maxCooldown));
                guiGraphics.fill(this.getX() + 1, this.getY() + 1 + (int)lerp, this.getX() + 17, this.getY() + 17, 0x78000000);
                if (this.isHoveredOrFocused()) {
                    this.setTooltip(Tooltip.create((Component)Component.translatable((String)EpicFightMod.format("gui.%s.container_on_cooldown"), (Object[])new Object[]{this.skillContainer.getReplaceCooldown() / 20})));
                }
            } else {
                this.setTooltip(Tooltip.create((Component)this.slotExplanation));
            }
        }

        public void setFocused(boolean focused) {
            super.setFocused(focused);
            this.maybeScroll();
        }

        private void maybeScroll() {
            boolean needsScrollTop;
            if (SkillEditScreen.this.maxScroll == 0) {
                return;
            }
            int scroll = SkillEditScreen.this.scroll;
            int index = SkillEditScreen.this.slotButtons.values().stream().toList().indexOf((Object)this);
            int relativeIndex = index - scroll;
            boolean needsScrollDown = relativeIndex >= 8;
            boolean bl = needsScrollTop = relativeIndex == 0;
            if (needsScrollDown || needsScrollTop) {
                if (needsScrollDown) {
                    SkillEditScreen.this.scrollDown();
                } else {
                    SkillEditScreen.this.scrollUp();
                }
            }
        }
    }

    class ScrollArrow
    extends Button {
        final boolean up;

        protected ScrollArrow(int x, int y, int width, int height, Button.OnPress onPress, boolean up) {
            super(x, y, width, height, (Component)Component.empty(), onPress, Button.DEFAULT_NARRATION);
            this.up = up;
        }

        protected void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            if (this.up && SkillEditScreen.this.scroll != 0) {
                guiGraphics.blit(SCROLL_ARROW_UP, this.getX(), this.getY(), this.width, this.height, 0.0f, 0.0f, 16, 16, 16, 16);
            } else if (!this.up && SkillEditScreen.this.scroll != SkillEditScreen.this.maxScroll) {
                guiGraphics.blit(SCROLL_ARROW_DOWN, this.getX(), this.getY(), this.width, this.height, 0.0f, 0.0f, 16, 16, 16, 16);
            }
        }

        protected boolean clicked(double mouseX, double mouseY) {
            return super.clicked(mouseX, mouseY) && (this.up && SkillEditScreen.this.scroll != 0 || !this.up && SkillEditScreen.this.scroll != SkillEditScreen.this.maxScroll);
        }
    }

    public class EquipSkillButton
    extends Button {
        private static final int SPACING = 26;
        private final Skill skill;

        public EquipSkillButton(int x, int y, int width, int height, Skill skill, Component title, Button.OnPress pressedAction) {
            super(x, y, width, height, title, pressedAction, Button.DEFAULT_NARRATION);
            this.skill = skill;
        }

        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.isHovered = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
            int texY = this.isHoveredOrFocused() || !this.active ? 224 : 200;
            guiGraphics.blit(SKILL_EDIT_UI, this.getX(), this.getY(), 0, texY, this.width, this.height);
            RenderSystem.enableBlend();
            guiGraphics.blit(this.skill.getSkillTexture(), this.getX() + 5, this.getY() + 4, 16, 16, 0.0f, 0.0f, 128, 128, 128, 128);
            guiGraphics.drawString(SkillEditScreen.this.font, this.getMessage(), this.getX() + 26, this.getY() + 2, -1, false);
            if (!this.active) {
                guiGraphics.drawString(SkillEditScreen.this.font, (Component)Component.literal((String)SkillEditScreen.this.skills.getSkillContainer(this.skill).getSlot().toString().toLowerCase(Locale.ROOT)), this.getX() + 26, this.getY() + 12, 0xFF6060, false);
            }
        }

        public boolean mouseClicked(double x, double y, int pressType) {
            boolean flag;
            if (this.visible && pressType == 1 && (flag = this.clickedNoCountActive(x, y))) {
                this.openSkillInfoScreen();
                return true;
            }
            return super.mouseClicked(x, y, pressType);
        }

        public void openSkillInfoScreen() {
            this.playDownSound(Minecraft.getInstance().getSoundManager());
            SkillEditScreen.this.minecraft.setScreen((Screen)new SkillBookScreen(SkillEditScreen.this.player, this.skill, null, SkillEditScreen.this));
        }

        public void setFocused(boolean focused) {
            super.setFocused(focused);
            this.maybeScroll();
        }

        private void maybeScroll() {
            boolean isOutsideVisibleRowsAtTop;
            List<EquipSkillButton> buttons = SkillEditScreen.this.equipSkillButtons;
            int start = SkillEditScreen.this.start;
            int maxRows = 6;
            int i = buttons.indexOf((Object)this);
            boolean isOutsideVisibleRowsAtBottom = i >= start + 6;
            boolean bl = isOutsideVisibleRowsAtTop = i < start;
            if (isOutsideVisibleRowsAtBottom || isOutsideVisibleRowsAtTop) {
                int nextStart = isOutsideVisibleRowsAtBottom ? Math.max(0, i - 6 + 1) : i;
                int diff = start - nextStart;
                for (Button button : buttons) {
                    button.setY(button.getY() + 26 * diff);
                }
                SkillEditScreen.this.start = nextStart;
            }
        }

        protected boolean clickedNoCountActive(double x, double y) {
            return this.visible && x >= (double)this.getX() && y >= (double)this.getY() && x < (double)(this.getX() + this.width) && y < (double)(this.getY() + this.height);
        }

        public EquipSkillButton setActive(boolean active) {
            this.active = active;
            return this;
        }
    }
}

