/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import yesman.epicfight.api.utils.math.Vec2i;
import yesman.epicfight.client.gui.ScreenCalculations;
import yesman.epicfight.client.gui.screen.config.UISetupScreen;
import yesman.epicfight.client.gui.widgets.UIComponentPop;
import yesman.epicfight.config.OptionHandler;

public class UIComponent
extends Button {
    protected final UISetupScreen parentScreen;
    protected final ResourceLocation texture;
    protected int texU;
    protected int texV;
    protected int texW;
    protected int texH;
    protected int resolutionDivW;
    protected int resolutionDivH;
    protected int draggingTime;
    protected float r;
    protected float g;
    protected float b;
    private double pressX;
    private double pressY;
    public final OptionHandler<Integer> xCoord;
    public final OptionHandler<Integer> yCoord;
    public final OptionHandler<ScreenCalculations.HorizontalBasis> horizontalBasis;
    public final OptionHandler<ScreenCalculations.VerticalBasis> verticalBasis;
    public UIComponentPop<?> popupScreen;

    public UIComponent(int x, int y, OptionHandler<Integer> xCoord, OptionHandler<Integer> yCoord, OptionHandler<ScreenCalculations.HorizontalBasis> horizontalBasis, OptionHandler<ScreenCalculations.VerticalBasis> verticalBasis, int width, int height, int texU, int texV, int texW, int texH, int resolutionDivW, int resolutionDivH, int r, int g, int b, UISetupScreen parentScreen, ResourceLocation texture) {
        super(x, y, width, height, (Component)Component.literal((String)""), button -> {}, Button.DEFAULT_NARRATION);
        this.texture = texture;
        this.texU = texU;
        this.texV = texV;
        this.texW = texW;
        this.texH = texH;
        this.resolutionDivW = resolutionDivW;
        this.resolutionDivH = resolutionDivH;
        this.r = (float)r / 255.0f;
        this.g = (float)g / 255.0f;
        this.b = (float)b / 255.0f;
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.horizontalBasis = horizontalBasis;
        this.verticalBasis = verticalBasis;
        this.parentScreen = parentScreen;
        this.popupScreen = new UIComponentPop<UIComponent>(30, 30, this);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.active && this.visible) {
            if (this.isValidClickButton(button)) {
                this.draggingTime = 0;
                if (this.clicked(mouseX, mouseY)) {
                    this.parentScreen.beginToDrag(this);
                    this.pressX = mouseX - (double)this.getX();
                    this.pressY = mouseY - (double)this.getY();
                    this.playDownSound(Minecraft.getInstance().getSoundManager());
                    if (!this.popupScreen.isHoverd(this.getX(), this.getY())) {
                        this.popupScreen.closePop();
                    }
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    protected void onDrag(double x, double y, double dx, double dy) {
        if (this.parentScreen.isDraggingComponent(this)) {
            this.setX((int)(x - this.pressX));
            this.setY((int)(y - this.pressY));
            ++this.draggingTime;
        }
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.isValidClickButton(button)) {
            this.onRelease(mouseX, mouseY);
            this.parentScreen.endDragging();
            int xCoord = this.horizontalBasis.getValue().saveCoordGetter.apply(this.parentScreen.width, this.getX());
            int yCoord = this.verticalBasis.getValue().saveCoordGetter.apply(this.parentScreen.height, this.getY());
            this.xCoord.setValue(xCoord);
            this.yCoord.setValue(yCoord);
            return true;
        }
        return false;
    }

    public void onRelease(double x, double y) {
        if (!this.popupScreen.isOpen() && this.draggingTime < 2) {
            this.popupScreen.x = x + (double)this.popupScreen.width > (double)this.parentScreen.width ? (int)x - this.popupScreen.width : (int)x;
            this.popupScreen.y = y + (double)this.popupScreen.height > (double)this.parentScreen.height ? (int)y - this.popupScreen.height : (int)y;
            this.popupScreen.openPop();
        }
    }

    public void drawOutline(GuiGraphics guiGraphics) {
        PoseStack poseStack = guiGraphics.pose();
        float screenX = this.getX() - 1;
        float screenXEnd = this.getX() + this.width + 1;
        float screenY = this.getY() - 1;
        float screenYEnd = this.getY() + this.height + 1;
        RenderSystem.disableCull();
        RenderSystem.lineWidth((float)2.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::getRendertypeLinesShader);
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.LINES, DefaultVertexFormat.POSITION_COLOR_NORMAL);
        bufferbuilder.addVertex(poseStack.last().pose(), screenX, screenY, 0.0f).setColor(69, 166, 244, 255).setNormal(1.0f, 0.0f, 0.0f);
        bufferbuilder.addVertex(poseStack.last().pose(), screenXEnd, screenY, 0.0f).setColor(69, 166, 244, 255).setNormal(1.0f, 0.0f, 0.0f);
        bufferbuilder.addVertex(poseStack.last().pose(), screenXEnd, screenY, 0.0f).setColor(69, 166, 244, 255).setNormal(0.0f, -1.0f, 0.0f);
        bufferbuilder.addVertex(poseStack.last().pose(), screenXEnd, screenYEnd, 0.0f).setColor(69, 166, 244, 255).setNormal(0.0f, -1.0f, 0.0f);
        bufferbuilder.addVertex(poseStack.last().pose(), screenXEnd, screenYEnd, 0.0f).setColor(69, 166, 244, 255).setNormal(-1.0f, 0.0f, 0.0f);
        bufferbuilder.addVertex(poseStack.last().pose(), screenX, screenYEnd, 0.0f).setColor(69, 166, 244, 255).setNormal(-1.0f, 0.0f, 0.0f);
        bufferbuilder.addVertex(poseStack.last().pose(), screenX, screenYEnd, 0.0f).setColor(69, 166, 244, 255).setNormal(0.0f, 1.0f, 0.0f);
        bufferbuilder.addVertex(poseStack.last().pose(), screenX, screenY, 0.0f).setColor(69, 166, 244, 255).setNormal(0.0f, 1.0f, 0.0f);
        if (this.horizontalBasis.getValue() == ScreenCalculations.HorizontalBasis.CENTER) {
            bufferbuilder.addVertex(poseStack.last().pose(), screenX + (screenXEnd - screenX) / 2.0f, screenY + (screenYEnd - screenY) / 2.0f, 0.0f).setColor(69, 166, 244, 255).setNormal(1.0f, 0.0f, 0.0f);
            bufferbuilder.addVertex(poseStack.last().pose(), (float)(this.parentScreen.width / 2), screenY + (screenYEnd - screenY) / 2.0f, 0.0f).setColor(69, 166, 244, 255).setNormal(1.0f, 0.0f, 0.0f);
        } else if (this.horizontalBasis.getValue() == ScreenCalculations.HorizontalBasis.LEFT) {
            bufferbuilder.addVertex(poseStack.last().pose(), screenX, screenY, 0.0f).setColor(69, 166, 244, 255).setNormal(1.0f, 0.0f, 0.0f);
            bufferbuilder.addVertex(poseStack.last().pose(), 0.0f, screenY, 0.0f).setColor(69, 166, 244, 255).setNormal(1.0f, 0.0f, 0.0f);
        } else if (this.horizontalBasis.getValue() == ScreenCalculations.HorizontalBasis.RIGHT) {
            bufferbuilder.addVertex(poseStack.last().pose(), screenX, screenY, 0.0f).setColor(69, 166, 244, 255).setNormal(1.0f, 0.0f, 0.0f);
            bufferbuilder.addVertex(poseStack.last().pose(), (float)this.parentScreen.width, screenY, 0.0f).setColor(69, 166, 244, 255).setNormal(1.0f, 0.0f, 0.0f);
        }
        if (this.verticalBasis.getValue() == ScreenCalculations.VerticalBasis.CENTER) {
            bufferbuilder.addVertex(poseStack.last().pose(), screenX + (screenXEnd - screenX) / 2.0f, screenY + (screenYEnd - screenY) / 2.0f, 0.0f).setColor(69, 166, 244, 255).setNormal(0.0f, 1.0f, 0.0f);
            bufferbuilder.addVertex(poseStack.last().pose(), screenX + (screenXEnd - screenX) / 2.0f, (float)(this.parentScreen.height / 2), 0.0f).setColor(69, 166, 244, 255).setNormal(0.0f, 1.0f, 0.0f);
        } else if (this.verticalBasis.getValue() == ScreenCalculations.VerticalBasis.TOP) {
            bufferbuilder.addVertex(poseStack.last().pose(), screenX, screenY, 0.0f).setColor(69, 166, 244, 255).setNormal(0.0f, 1.0f, 0.0f);
            bufferbuilder.addVertex(poseStack.last().pose(), screenX, 0.0f, 0.0f).setColor(69, 166, 244, 255).setNormal(0.0f, 1.0f, 0.0f);
        } else if (this.verticalBasis.getValue() == ScreenCalculations.VerticalBasis.BOTTOM) {
            bufferbuilder.addVertex(poseStack.last().pose(), screenX, screenY, 0.0f).setColor(69, 166, 244, 255).setNormal(0.0f, 1.0f, 0.0f);
            bufferbuilder.addVertex(poseStack.last().pose(), screenX, (float)this.parentScreen.height, 0.0f).setColor(69, 166, 244, 255).setNormal(0.0f, 1.0f, 0.0f);
        }
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
    }

    protected void renderWidget(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)this.r, (float)this.g, (float)this.b, (float)this.alpha);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        guiGraphics.blit(this.texture, this.getX(), this.getY(), this.width, this.height, (float)this.texU, (float)this.texV, this.texW, this.texH, this.resolutionDivW, this.resolutionDivH);
        if (this.isHoveredOrFocused() || this.popupScreen.isOpen()) {
            this.drawOutline(guiGraphics);
        }
        if (this.popupScreen.isOpen()) {
            this.popupScreen.render(guiGraphics, x, y, partialTicks);
        }
    }

    public static class PassiveUIComponent
    extends UIComponent {
        public final OptionHandler<ScreenCalculations.AlignDirection> alignDirection;
        protected final ResourceLocation texture2;

        public PassiveUIComponent(int x, int y, OptionHandler<Integer> xCoord, OptionHandler<Integer> yCoord, OptionHandler<ScreenCalculations.HorizontalBasis> horizontalBasis, OptionHandler<ScreenCalculations.VerticalBasis> verticalBasis, OptionHandler<ScreenCalculations.AlignDirection> alignDirection, int width, int height, int texU, int texV, int texW, int texH, int resolutionDivW, int resolutionDivH, int r, int g, int b, UISetupScreen parentScreen, ResourceLocation texture, ResourceLocation texture2) {
            super(x, y, xCoord, yCoord, horizontalBasis, verticalBasis, width, height, texU, texV, texW, texH, resolutionDivW, resolutionDivH, r, g, b, parentScreen, texture);
            this.popupScreen = new UIComponentPop.PassivesUIComponentPop(30, 44, this);
            this.alignDirection = alignDirection;
            this.texture2 = texture2;
        }

        @Override
        protected void renderWidget(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
            Vec2i startPos = this.alignDirection.getValue().startCoordGetter.get(this.getX(), this.getY(), this.width, this.height, 2, (ScreenCalculations.HorizontalBasis)((Object)this.horizontalBasis.getValue()), (ScreenCalculations.VerticalBasis)((Object)this.verticalBasis.getValue()));
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderColor((float)this.r, (float)this.g, (float)this.b, (float)this.alpha);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            guiGraphics.blit(this.texture, startPos.x, startPos.y, this.width, this.height, (float)this.texU, (float)this.texV, this.texW, this.texH, this.resolutionDivW, this.resolutionDivH);
            if (this.isHoveredOrFocused() || this.popupScreen.isOpen()) {
                this.drawOutline(guiGraphics);
            }
            if (this.popupScreen.isOpen()) {
                this.popupScreen.render(guiGraphics, x, y, partialTicks);
            }
            Vec2i nextPos = this.alignDirection.getValue().nextPositionGetter.getNext((ScreenCalculations.HorizontalBasis)((Object)this.horizontalBasis.getValue()), (ScreenCalculations.VerticalBasis)((Object)this.verticalBasis.getValue()), startPos, this.width, this.height);
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderColor((float)this.r, (float)this.g, (float)this.b, (float)this.alpha);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            guiGraphics.blit(this.texture2, nextPos.x, nextPos.y, this.width, this.height, (float)this.texU, (float)this.texV, this.texW, this.texH, this.resolutionDivW, this.resolutionDivH);
        }
    }
}

