/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.NoRenderParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.registry.entries.EpicFightParticles;

public class DustParticle
extends TextureSheetParticle {
    private final PhysicsType physicsType;

    public DustParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, PhysicsType physicsType) {
        super(level, x, y, z);
        float angle;
        this.x = x;
        this.y = y;
        this.z = z;
        this.rCol = 1.0f;
        this.gCol = 1.0f;
        this.bCol = 1.0f;
        this.quadSize = physicsType == PhysicsType.NORMAL ? this.random.nextFloat() * 0.01f + 0.01f : this.random.nextFloat() * 0.02f + 0.02f;
        this.lifetime = (physicsType == PhysicsType.NORMAL ? 12 : 2) + this.random.nextInt(6);
        this.hasPhysics = physicsType == PhysicsType.NORMAL;
        this.gravity = physicsType == PhysicsType.NORMAL ? 0.68f : 0.0f;
        this.roll = angle = this.random.nextFloat() * 360.0f;
        this.oRoll = angle;
        Vec3 deltaMovement = physicsType.function.getDeltaMovement(xd, yd, zd);
        this.xd = deltaMovement.x;
        this.yd = deltaMovement.y;
        this.zd = deltaMovement.z;
        this.physicsType = physicsType;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void tick() {
        super.tick();
        if (this.physicsType == PhysicsType.EXPANSIVE) {
            this.xd *= 0.48;
            this.yd *= 0.48;
            this.zd *= 0.48;
        } else if (this.physicsType == PhysicsType.CONTRACTIVE) {
            this.xd *= 1.35;
            this.yd *= 1.35;
            this.zd *= 1.35;
        }
    }

    private static enum PhysicsType {
        EXPANSIVE((dx, dy, dz) -> new Vec3(dx, dy, dz)),
        CONTRACTIVE((dx, dy, dz) -> new Vec3(dx * 0.02, dy * 0.02, dz * 0.02)),
        NORMAL((dx, dy, dz) -> new Vec3(dx, dy, dz));

        DeltaMovementFunction function;

        private PhysicsType(DeltaMovementFunction function) {
            this.function = function;
        }
    }

    @FunctionalInterface
    static interface DeltaMovementFunction {
        public Vec3 getDeltaMovement(double var1, double var3, double var5);
    }

    public static class NormalDustProvider
    implements ParticleProvider<SimpleParticleType> {
        protected SpriteSet sprite;

        public NormalDustProvider(SpriteSet sprite) {
            this.sprite = sprite;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            DustParticle dustParticle = new DustParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, PhysicsType.NORMAL);
            dustParticle.pickSprite(this.sprite);
            return dustParticle;
        }
    }

    public static class ContractiveDustProvider
    implements ParticleProvider<SimpleParticleType> {
        protected SpriteSet sprite;

        public ContractiveDustProvider(SpriteSet sprite) {
            this.sprite = sprite;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            DustParticle dustParticle = new DustParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, PhysicsType.CONTRACTIVE);
            dustParticle.pickSprite(this.sprite);
            return dustParticle;
        }
    }

    public static class ExpansiveDustProvider
    implements ParticleProvider<SimpleParticleType> {
        protected SpriteSet sprite;

        public ExpansiveDustProvider(SpriteSet sprite) {
            this.sprite = sprite;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            DustParticle dustParticle = new DustParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, PhysicsType.EXPANSIVE);
            dustParticle.pickSprite(this.sprite);
            return dustParticle;
        }
    }

    public static class ContractiveMetaParticle
    extends NoRenderParticle {
        private final double radius;
        private final int density;

        public ContractiveMetaParticle(ClientLevel level, double x, double y, double z, double radius, int lifetime, int density) {
            super(level, x, y, z);
            this.radius = radius;
            this.lifetime = lifetime;
            this.density = density;
        }

        public void tick() {
            super.tick();
            for (int x = -1; x <= 1; x += 2) {
                for (int y = -1; y <= 1; y += 2) {
                    for (int z = -1; z <= 1; z += 2) {
                        for (int i = 0; i < this.density; ++i) {
                            Vec3 rand = new Vec3(Math.random() * (double)x, Math.random() * (double)y, Math.random() * (double)z).normalize().scale(this.radius);
                            this.level.addParticle((ParticleOptions)EpicFightParticles.DUST_CONTRACTIVE.get(), this.x + rand.x, this.y + rand.y, this.z + rand.z, -rand.x, -rand.y, -rand.z);
                        }
                    }
                }
            }
        }

        public static class Provider
        implements ParticleProvider<SimpleParticleType> {
            public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
                ContractiveMetaParticle particle = new ContractiveMetaParticle(worldIn, x, y, z, xSpeed, (int)Double.doubleToLongBits(ySpeed), (int)Double.doubleToLongBits(zSpeed));
                return particle;
            }
        }
    }

    public static class ExpansiveMetaParticle
    extends NoRenderParticle {
        public ExpansiveMetaParticle(ClientLevel level, double x, double y, double z, double radius, int density) {
            super(level, x, y, z);
            for (int vx = -1; vx <= 1; vx += 2) {
                for (int vz = -1; vz <= 1; vz += 2) {
                    for (int i = 0; i < density; ++i) {
                        Vec3 rand = new Vec3(Math.random() * (double)vx, Math.random(), Math.random() * (double)vz).normalize().scale(radius);
                        level.addParticle((ParticleOptions)EpicFightParticles.DUST_EXPANSIVE.get(), x, y, z, rand.x, rand.y, rand.z);
                    }
                }
            }
        }

        public static class Provider
        implements ParticleProvider<SimpleParticleType> {
            public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
                ExpansiveMetaParticle particle = new ExpansiveMetaParticle(worldIn, x, y, z, xSpeed, (int)Double.doubleToLongBits(ySpeed));
                return particle;
            }
        }
    }
}

