/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.particle;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import yesman.epicfight.api.client.model.ClassicMesh;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.utils.math.QuaternionUtils;
import yesman.epicfight.client.particle.CustomModelParticle;
import yesman.epicfight.client.particle.EpicFightParticleRenderTypes;

public class LaserParticle
extends CustomModelParticle<ClassicMesh> {
    private final float length;
    private final float xRot;
    private final float yRot;

    public LaserParticle(ClientLevel level, double x, double y, double z, double toX, double toY, double toZ) {
        super(level, x, y, z, 0.0, 0.0, 0.0, Meshes.LASER);
        this.lifetime = 5;
        Vec3 direction = new Vec3(toX - x, toY - y, toZ - z);
        Vec3 start = new Vec3(x, y, z);
        Vec3 destination = start.add(direction.normalize().scale(200.0));
        BlockHitResult hitResult = level.clip(new ClipContext(start, destination, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.empty()));
        double xLength = hitResult.getLocation().x - x;
        double yLength = hitResult.getLocation().y - y;
        double zLength = hitResult.getLocation().z - z;
        double horizontalDistance = (float)Math.sqrt(xLength * xLength + zLength * zLength);
        this.length = (float)Math.sqrt(xLength * xLength + yLength * yLength + zLength * zLength);
        this.yRot = (float)(Math.atan2(zLength, xLength) * 57.29577951308232) + 90.0f + 180.0f;
        this.xRot = (float)(Math.atan2(yLength, horizontalDistance) * 57.29577951308232);
        int smokeCount = (int)this.length * 4;
        for (int i = 0; i < smokeCount; ++i) {
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x + xLength / (double)smokeCount * (double)i, y + yLength / (double)smokeCount * (double)i, z + zLength / (double)smokeCount * (double)i, 0.0, 0.0, 0.0);
        }
        this.setBoundingBox(new AABB(x, y, z, toX, toY, toZ));
    }

    @Override
    protected void setupPoseStack(PoseStack poseStack, Camera camera, float partialTick) {
        poseStack.pushPose();
        Vec3 cameraPosition = camera.getPosition();
        float x = (float)(Mth.lerp((double)partialTick, (double)this.xo, (double)this.x) - cameraPosition.x());
        float y = (float)(Mth.lerp((double)partialTick, (double)this.yo, (double)this.y) - cameraPosition.y());
        float z = (float)(Mth.lerp((double)partialTick, (double)this.zo, (double)this.z) - cameraPosition.z());
        poseStack.translate(x, y, z);
        poseStack.mulPose(QuaternionUtils.YP.rotationDegrees(180.0f - this.yRot));
        poseStack.mulPose(QuaternionUtils.XP.rotationDegrees(this.xRot));
        float progression = ((float)this.age + partialTick) / (float)(this.lifetime + 1);
        float scale = Mth.sin((float)(progression * (float)Math.PI));
        float zScale = progression > 0.5f ? 1.0f : Mth.sin((float)(progression * (float)Math.PI));
        poseStack.scale(scale, scale, zScale * this.length);
    }

    public ParticleRenderType getRenderType() {
        return EpicFightParticleRenderTypes.TRANSLUCENT_GLOWING;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel level, double startX, double startY, double startZ, double endX, double endY, double endZ) {
            return new LaserParticle(level, startX, startY, startZ, endX, endY, endZ);
        }
    }
}

