/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer.patched.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.api.client.neoevent.PrepareModelEvent;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.client.renderer.patched.entity.PatchedEntityRenderer;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class PCustomEntityRenderer
extends PatchedEntityRenderer<LivingEntity, LivingEntityPatch<LivingEntity>, EntityRenderer<LivingEntity>, SkinnedMesh> {
    private final AssetAccessor<SkinnedMesh> mesh;

    public PCustomEntityRenderer(AssetAccessor<SkinnedMesh> mesh, EntityRendererProvider.Context context) {
        this.mesh = mesh;
    }

    @Override
    public void render(LivingEntity entity, LivingEntityPatch<LivingEntity> entitypatch, EntityRenderer<LivingEntity> renderer, MultiBufferSource buffer, PoseStack poseStack, int packedLight, float partialTicks) {
        SkinnedMesh mesh;
        PrepareModelEvent prepareModelEvent;
        super.render(entity, entitypatch, renderer, buffer, poseStack, packedLight, partialTicks);
        Minecraft mc = Minecraft.getInstance();
        boolean isGlowing = mc.shouldEntityAppearGlowing((Entity)entity);
        ResourceLocation textureLocation = renderer.getTextureLocation((Entity)entity);
        RenderType renderType = isGlowing ? RenderType.outline((ResourceLocation)textureLocation) : RenderType.entityCutoutNoCull((ResourceLocation)textureLocation);
        Armature armature = entitypatch.getArmature();
        poseStack.pushPose();
        this.mulPoseStack(poseStack, armature, entity, entitypatch, partialTicks);
        this.setArmaturePose(entitypatch, armature, partialTicks);
        if (renderType != null && !((PrepareModelEvent)NeoForge.EVENT_BUS.post((Event)(prepareModelEvent = new PrepareModelEvent(this, mesh = this.mesh.get(), entitypatch, buffer, poseStack, packedLight, partialTicks)))).isCanceled()) {
            mesh.draw(poseStack, buffer, renderType, packedLight, 1.0f, 1.0f, 1.0f, !entity.isInvisibleTo((Player)mc.player) ? 0.15f : 1.0f, this.getOverlayCoord(entity, entitypatch, partialTicks), armature, armature.getPoseMatrices());
        }
        if (Minecraft.getInstance().getEntityRenderDispatcher().shouldRenderHitBoxes()) {
            entitypatch.getClientAnimator().renderDebuggingInfoForAllLayers(poseStack, buffer, partialTicks);
        }
        poseStack.popPose();
    }

    protected int getOverlayCoord(LivingEntity entity, LivingEntityPatch<LivingEntity> entitypatch, float partialTicks) {
        return OverlayTexture.pack((int)0, (int)OverlayTexture.v((entity.hurtTime > 5 ? 1 : 0) != 0));
    }

    @Override
    public AssetAccessor<SkinnedMesh> getDefaultMesh() {
        return this.mesh;
    }
}

