/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer.patched.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.layers.BeeStingerLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import yesman.epicfight.client.renderer.patched.layer.PatchedStuckInBodyLayer;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class PatchedBeeStingerLayer<E extends LivingEntity, T extends LivingEntityPatch<E>, M extends PlayerModel<E>>
extends PatchedStuckInBodyLayer<E, T, M, BeeStingerLayer<E, M>> {
    private static final ResourceLocation BEE_STINGER_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/bee/bee_stinger.png");

    @Override
    protected void renderStuckItem(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Entity entity, float pf1, float pf2, float pf3, float partialTick) {
        float f = Mth.sqrt((float)(pf1 * pf1 + pf3 * pf3));
        float f1 = (float)(Math.atan2(pf1, pf3) * 57.2957763671875);
        float f2 = (float)(Math.atan2(pf2, f) * 57.2957763671875);
        poseStack.translate(0.0f, 0.0f, 0.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(f1 - 90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(f2));
        poseStack.mulPose(Axis.XP.rotationDegrees(45.0f));
        poseStack.scale(0.03125f, 0.03125f, 0.03125f);
        poseStack.translate(2.5f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)BEE_STINGER_LOCATION));
        for (int i = 0; i < 4; ++i) {
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            PoseStack.Pose posestack$pose = poseStack.last();
            PatchedBeeStingerLayer.vertex(vertexconsumer, posestack$pose, -4.5f, -1, 0.0f, 0.0f, packedLight);
            PatchedBeeStingerLayer.vertex(vertexconsumer, posestack$pose, 4.5f, -1, 0.125f, 0.0f, packedLight);
            PatchedBeeStingerLayer.vertex(vertexconsumer, posestack$pose, 4.5f, 1, 0.125f, 0.0625f, packedLight);
            PatchedBeeStingerLayer.vertex(vertexconsumer, posestack$pose, -4.5f, 1, 0.0f, 0.0625f, packedLight);
        }
    }

    private static void vertex(VertexConsumer vertexConsumer, PoseStack.Pose pose, float x, int y, float z, float u, int v) {
        vertexConsumer.addVertex(pose, x, (float)y, 0.0f).setColor(255, 255, 255, 255).setUv(z, u).setOverlay(OverlayTexture.NO_OVERLAY).setLight(v).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }

    @Override
    protected int numStuck(E entity) {
        return entity.getStingerCount();
    }
}

