/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.compat;

import java.lang.reflect.Constructor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingException;
import net.neoforged.neoforge.common.NeoForge;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.main.EpicFightSharedConstants;

public interface ICompatModule {
    public static void loadCompatModule(IEventBus modEventBus, Class<? extends ICompatModule> compatModule) {
        try {
            Constructor<? extends ICompatModule> constructor = compatModule.getConstructor(new Class[0]);
            ICompatModule compatModuleInstance = constructor.newInstance(new Object[0]);
            compatModuleInstance.onModEventBus(modEventBus);
            compatModuleInstance.onGameEventBus(NeoForge.EVENT_BUS);
            if (EpicFightSharedConstants.isPhysicalClient()) {
                compatModuleInstance.onModEventBusClient(modEventBus);
                compatModuleInstance.onGameEventBusClient(NeoForge.EVENT_BUS);
            }
            EpicFightMod.LOGGER.info("Loaded mod compatibility module: {}", (Object)compatModule.getSimpleName());
        }
        catch (ModLoadingException e) {
            throw e;
        }
        catch (Exception e) {
            EpicFightMod.LOGGER.error("Failed to load mod compatibility module: {}", (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    public void onModEventBus(IEventBus var1);

    public void onGameEventBus(IEventBus var1);

    @OnlyIn(value=Dist.CLIENT)
    public void onModEventBusClient(IEventBus var1);

    @OnlyIn(value=Dist.CLIENT)
    public void onGameEventBusClient(IEventBus var1);
}

