/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.data.conditions.entity;

import io.netty.util.internal.StringUtil;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.api.utils.ParseUtil;
import yesman.epicfight.client.gui.datapack.widgets.ComboBox;
import yesman.epicfight.client.gui.datapack.widgets.ResizableEditBox;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class HealthPoint
extends Condition.EntityPatchCondition {
    private double health;
    private Comparator comparator;

    public HealthPoint() {
        this.health = 0.0;
    }

    public HealthPoint(double health, Comparator comparator) {
        this.health = health;
        this.comparator = comparator;
    }

    public HealthPoint read(CompoundTag tag) {
        this.health = this.assertTag("health", "decimal", tag, NumericTag.class, CompoundTag::getDouble);
        this.comparator = this.assertEnumTag("comparator", Comparator.class, tag);
        return this;
    }

    @Override
    public CompoundTag serializePredicate() {
        CompoundTag tag = new CompoundTag();
        tag.putString("comparator", ParseUtil.toLowerCase(this.comparator.toString()));
        tag.putDouble("health", this.health);
        return tag;
    }

    @Override
    public boolean predicate(LivingEntityPatch<?> target) {
        switch (this.comparator.ordinal()) {
            case 1: {
                return this.health > (double)((LivingEntity)target.getOriginal()).getHealth();
            }
            case 0: {
                return this.health < (double)((LivingEntity)target.getOriginal()).getHealth();
            }
            case 3: {
                return this.health > (double)(((LivingEntity)target.getOriginal()).getHealth() / ((LivingEntity)target.getOriginal()).getMaxHealth());
            }
            case 2: {
                return this.health < (double)(((LivingEntity)target.getOriginal()).getHealth() / ((LivingEntity)target.getOriginal()).getMaxHealth());
            }
        }
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Condition.ParameterEditor> getAcceptingParameters(Screen screen) {
        ResizableEditBox editbox = new ResizableEditBox(screen.getMinecraft().font, 0, 0, 0, 0, (Component)Component.literal((String)"health"), null, null);
        ComboBox<Comparator> comboBox = new ComboBox<Comparator>(screen, screen.getMinecraft().font, 0, 0, 0, 0, null, null, 4, (Component)Component.literal((String)"comparator"), List.of(Comparator.values()), ParseUtil::snakeToSpacedCamel, null);
        editbox.setFilter(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsable(context, Double::parseDouble));
        return List.of(Condition.ParameterEditor.of(value -> (Tag)ParseUtil.parseOrGet(value.toString(), v -> DoubleTag.valueOf((double)Double.parseDouble(value.toString())), StringTag.valueOf((String)"")), tag -> ParseUtil.valueOfOmittingType(ParseUtil.nullOrToString(tag, Tag::getAsString)), (AbstractWidget)editbox), Condition.ParameterEditor.of(value -> StringTag.valueOf((String)value.toString().toLowerCase(Locale.ROOT)), tag -> ParseUtil.enumValueOfOrNull(Comparator.class, ParseUtil.nullOrToString(tag, Tag::getAsString)), comboBox));
    }

    public static enum Comparator {
        GREATER_ABSOLUTE,
        LESS_ABSOLUTE,
        GREATER_RATIO,
        LESS_RATIO;

    }
}

