/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.events;

import java.io.File;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.LogicalSide;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.player.ArrowLooseEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.common.AbstractAnimatorControl;
import yesman.epicfight.network.server.SPAbsorption;
import yesman.epicfight.network.server.SPAnimatorControl;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.gamerule.EpicFightGameRules;

@EventBusSubscriber(modid="epicfight")
public final class PlayerEvents {
    public static final PlayerPatch.PlayerMode[] PLAYER_MODE_ENUM = PlayerPatch.PlayerMode.values();

    private PlayerEvents() {
    }

    @SubscribeEvent
    public static void arrowLoose(ArrowLooseEvent event) {
        EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)event.getEntity(), PlayerPatch.class).ifPresent(playerpatch -> {
            if (playerpatch.isLogicalClient()) {
                ((Animator)playerpatch.getAnimator()).playShootingAnimation();
            } else {
                EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(new SPAnimatorControl(AbstractAnimatorControl.Action.SHOT, (AssetAccessor<? extends StaticAnimation>)Animations.EMPTY_ANIMATION, event.getEntity().getId(), 0.0f, false), (Entity)event.getEntity(), new CustomPacketPayload[0]);
            }
        });
    }

    @SubscribeEvent
    public static void startTrackingEvent(PlayerEvent.StartTracking event) {
        LivingEntity livingEntity;
        Entity entity = event.getTarget();
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).getAbsorptionAmount() > 0.0f) {
            EpicFightNetworkManager.sendToPlayer(new SPAbsorption(event.getTarget().getId(), livingEntity.getAbsorptionAmount()), (ServerPlayer)event.getEntity(), new CustomPacketPayload[0]);
        }
        EpicFightCapabilities.getUnparameterizedEntityPatch(event.getTarget(), EntityPatch.class).ifPresent(entitypatch -> entitypatch.onStartTracking((ServerPlayer)event.getEntity()));
    }

    @SubscribeEvent
    public static void stopTrackingEvent(PlayerEvent.StopTracking event) {
        EpicFightCapabilities.getUnparameterizedEntityPatch(event.getTarget(), EntityPatch.class).ifPresent(entitypatch -> entitypatch.onStopTracking((ServerPlayer)event.getEntity()));
    }

    @SubscribeEvent
    public static void playerLoadEvent(PlayerEvent.LoadFromFile event) {
        EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)event.getEntity(), ServerPlayerPatch.class).ifPresent(playerpatch -> {
            File file = new File(event.getPlayerDirectory(), event.getPlayerUUID() + ".dat");
            if (!file.exists()) {
                int initialMode = Math.min(EpicFightGameRules.INITIAL_PLAYER_MODE.getRuleValue(event.getEntity().level()), PLAYER_MODE_ENUM.length - 1);
                playerpatch.toMode(PLAYER_MODE_ENUM[initialMode], true);
            }
        });
    }

    @SubscribeEvent
    public static void cloneEvent(PlayerEvent.Clone event) {
        EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)event.getOriginal(), ServerPlayerPatch.class).ifPresent(oldCap -> EpicFightCapabilities.getPlayerPatch((Entity)event.getEntity()).ifPresent(newCap -> {
            if (!event.isWasDeath() || EpicFightGameRules.KEEP_SKILLS.getRuleValue(event.getOriginal().level()).booleanValue()) {
                newCap.copyOldData((PlayerPatch<?>)oldCap, event.isWasDeath());
            }
            newCap.toMode(oldCap.getPlayerMode(), false);
        }));
    }

    @SubscribeEvent
    public static void changeDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)event.getEntity(), ServerPlayerPatch.class).ifPresent(playerpatch -> {
            ((Animator)playerpatch.getAnimator()).resetLivingAnimations();
            playerpatch.modifyLivingMotionByCurrentItem(true);
            EpicFightNetworkManager.PayloadBundleBuilder packetBundleBuilder = EpicFightNetworkManager.PayloadBundleBuilder.create();
            playerpatch.getPlayerSkills().listSkillContainers().filter(SkillContainer::hasSkill).forEach(skillContainer -> skillContainer.getSkill().onTracked((SkillContainer)skillContainer, packetBundleBuilder));
            packetBundleBuilder.send((start, others) -> EpicFightNetworkManager.sendToPlayer(start, (ServerPlayer)playerpatch.getOriginal(), others));
        });
    }

    @SubscribeEvent
    public static void rightClickItemServerEvent(PlayerInteractEvent.RightClickItem event) {
        if (event.getSide() == LogicalSide.CLIENT) {
            return;
        }
        EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)event.getEntity(), ServerPlayerPatch.class).ifPresent(playerpatch -> {
            ItemStack itemstack = ((ServerPlayer)playerpatch.getOriginal()).getOffhandItem();
            if (!playerpatch.getEntityState().canUseItem()) {
                event.setCanceled(true);
            } else if (itemstack.getUseAnimation() == UseAnim.NONE || !playerpatch.getHoldingItemCapability(InteractionHand.MAIN_HAND).getStyle((LivingEntityPatch<?>)playerpatch).canUseOffhand()) {
                boolean canceled = playerpatch.getPlayerSkills().fireSkillEvents("epicfight", event).isCanceled();
                if (playerpatch.getEntityState().movementLocked()) {
                    canceled = true;
                }
                event.setCanceled(canceled);
            }
        });
    }

    @SubscribeEvent
    public static void itemUseStartEvent(LivingEntityUseItemEvent.Start event) {
        EpicFightCapabilities.getPlayerPatch((Entity)event.getEntity()).ifPresent(playerpatch -> {
            InteractionHand hand = ((Player)playerpatch.getOriginal()).getItemInHand(InteractionHand.MAIN_HAND).equals(event.getItem()) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
            CapabilityItem itemCap = playerpatch.getHoldingItemCapability(hand);
            if (!playerpatch.getEntityState().canUseItem()) {
                event.setCanceled(true);
            } else if (event.getItem() == ((Player)playerpatch.getOriginal()).getOffhandItem() && !playerpatch.getHoldingItemCapability(InteractionHand.MAIN_HAND).getStyle((LivingEntityPatch<?>)playerpatch).canUseOffhand()) {
                event.setCanceled(true);
            }
            if (itemCap.getUseAnimation((LivingEntityPatch<?>)playerpatch) == UseAnim.BLOCK) {
                event.setDuration(Integer.MAX_VALUE);
            }
        });
    }

    @SubscribeEvent
    public static void itemUseStopEvent(LivingEntityUseItemEvent.Stop event) {
        EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)event.getEntity(), ServerPlayerPatch.class).ifPresent(playerpatch -> {
            boolean canceled = playerpatch.getPlayerSkills().fireSkillEvents("epicfight", event).isCanceled();
            event.setCanceled(canceled);
        });
    }

    public static boolean fakePlayerCheck(Player source) {
        return source instanceof FakePlayer;
    }
}

