/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.mixin.client;

import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import yesman.epicfight.api.client.camera.EpicFightCameraAPI;
import yesman.epicfight.client.events.engine.ControlEngine;
import yesman.epicfight.config.ClientConfig;

@Mixin(value={Minecraft.class})
public class MixinMinecraft {
    @Shadow
    @Final
    public GameRenderer gameRenderer;
    @Shadow
    @Final
    public Options options;
    @Shadow
    public LocalPlayer player;
    @Shadow
    public ClientLevel level;
    @Shadow
    public HitResult hitResult;

    @Shadow
    public Entity getCameraEntity() {
        throw new AbstractMethodError();
    }

    @Inject(at={@At(value="HEAD")}, method={"handleKeybinds()V"})
    private void epicfight$handleKeybindsHEAD(CallbackInfo info) {
        ControlEngine.getInstance().handleEpicFightKeyMappings();
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/Options;setCameraType(Lnet/minecraft/client/CameraType;)V", shift=At.Shift.AFTER)}, method={"handleKeybinds()V"})
    private void epicfight$handleKeybindsINVOKE(CallbackInfo callbackInfo) {
        EpicFightCameraAPI cameraApi = EpicFightCameraAPI.getInstance();
        if (cameraApi.isTPSMode()) {
            cameraApi.setCameraRotations(this.player.getXRot(), this.player.getYRot(), true);
        }
        if (this.options.getCameraType() != CameraType.THIRD_PERSON_BACK && cameraApi.isLockingOnTarget()) {
            cameraApi.setLockOn(false);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"shouldEntityAppearGlowing(Lnet/minecraft/world/entity/Entity;)Z"}, cancellable=true)
    private void epicfight$shouldEntityAppearGlowing(Entity entity, CallbackInfoReturnable<Boolean> callbackInfo) {
        if (EpicFightCameraAPI.getInstance().shouldHighlightTarget(entity)) {
            callbackInfo.setReturnValue((Object)true);
            callbackInfo.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"startAttack"}, cancellable=true)
    private void onStartVanillaAttack(CallbackInfoReturnable<Boolean> cir) {
        if (ControlEngine.shouldDisableVanillaAttack()) {
            cir.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"continueAttack"}, cancellable=true)
    private void onContinueVanillaAttack(boolean leftClick, CallbackInfo ci) {
        if (ControlEngine.shouldDisableVanillaAttack()) {
            ci.cancel();
        }
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;pick(F)V"), method={"tick()V"})
    private void epicfight$tick(GameRenderer gameRenderer, float partialTick) {
        if (EpicFightCameraAPI.getInstance().isTPSMode()) {
            this.pickInTPSPerspectiveMode();
        } else {
            this.gameRenderer.pick(partialTick);
        }
    }

    @Unique
    private void pickInTPSPerspectiveMode() {
        Entity entity = this.getCameraEntity();
        if (entity != null && this.level != null) {
            this.hitResult = EpicFightCameraAPI.getInstance().getCrosshairHitResult();
            if (this.hitResult != null) {
                double d0 = this.player.blockInteractionRange();
                double entityReach = this.player.entityInteractionRange();
                double distanceLimit = Math.max(d0, entityReach) + (double)ClientConfig.cameraZoom * 0.5;
                Vec3 hitPos = this.hitResult.getLocation();
                if (hitPos.distanceToSqr(this.gameRenderer.getMainCamera().getPosition()) > distanceLimit * distanceLimit) {
                    Vec3 cameraPos = this.gameRenderer.getMainCamera().getPosition();
                    this.hitResult = BlockHitResult.miss((Vec3)hitPos, (Direction)Direction.getNearest((double)cameraPos.x, (double)cameraPos.y, (double)cameraPos.z), (BlockPos)BlockPos.containing((Position)hitPos));
                }
            }
        }
    }
}

