/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.registry.entries;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.registry.entries.EpicFightEntityTypes;
import yesman.epicfight.world.capabilities.entitypatch.boss.WitherGhostPatch;
import yesman.epicfight.world.capabilities.entitypatch.boss.WitherPatch;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.EnderDragonPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.CreeperPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.EndermanPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.HoglinPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.IronGolemPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.PiglinBrutePatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.PiglinPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.RavagerPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.VindicatorPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.WitherSkeletonPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.ZoglinPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.ZombiePatch;
import yesman.epicfight.world.entity.WitherGhostClone;

public final class EpicFightAttributes {
    public static final DeferredRegister<Attribute> REGISTRY;
    public static final DeferredHolder<Attribute, Attribute> MAX_STAMINA;
    public static final DeferredHolder<Attribute, Attribute> STAMINA_REGEN;
    public static final DeferredHolder<Attribute, Attribute> STUN_ARMOR;
    public static final DeferredHolder<Attribute, Attribute> WEIGHT;
    public static final DeferredHolder<Attribute, Attribute> MAX_STRIKES;
    public static final DeferredHolder<Attribute, Attribute> ARMOR_NEGATION;
    public static final DeferredHolder<Attribute, Attribute> IMPACT;
    public static final DeferredHolder<Attribute, Attribute> ASSASSINATION_RESISTANCE;
    public static final DeferredHolder<Attribute, Attribute> OFFHAND_ATTACK_SPEED;
    public static final DeferredHolder<Attribute, Attribute> OFFHAND_MAX_STRIKES;
    public static final DeferredHolder<Attribute, Attribute> OFFHAND_ARMOR_NEGATION;
    public static final DeferredHolder<Attribute, Attribute> OFFHAND_IMPACT;
    public static final ResourceLocation ARMOR_NEGATION_MODIFIER;
    public static final ResourceLocation MAX_STRIKE_MODIFIER;
    public static final ResourceLocation IMPACT_MODIFIER;
    public static final ResourceLocation ATTACK_DAMAGE_MODIFIER;
    public static final ResourceLocation ATTACK_SPEED_MODIFIER;

    private EpicFightAttributes() {
    }

    public static AttributeModifier getArmorNegationModifier(double value) {
        return new AttributeModifier(ARMOR_NEGATION_MODIFIER, value, AttributeModifier.Operation.ADD_VALUE);
    }

    public static AttributeModifier getMaxStrikesModifier(int value) {
        return new AttributeModifier(MAX_STRIKE_MODIFIER, (double)value, AttributeModifier.Operation.ADD_VALUE);
    }

    public static AttributeModifier getImpactModifier(double value) {
        return new AttributeModifier(IMPACT_MODIFIER, value, AttributeModifier.Operation.ADD_VALUE);
    }

    public static AttributeModifier getDamageBonusModifier(double value) {
        return new AttributeModifier(ATTACK_DAMAGE_MODIFIER, value, AttributeModifier.Operation.ADD_VALUE);
    }

    public static AttributeModifier getSpeedBonusModifier(double value) {
        return new AttributeModifier(ATTACK_SPEED_MODIFIER, value, AttributeModifier.Operation.ADD_VALUE);
    }

    static {
        ((Attribute)Attributes.ATTACK_DAMAGE.value()).setSyncable(true);
        REGISTRY = DeferredRegister.create((ResourceKey)Registries.ATTRIBUTE, (String)"epicfight");
        MAX_STAMINA = REGISTRY.register("stamina", () -> new RangedAttribute("attribute.name.epicfight.stamina", 15.0, 0.0, 1024.0).setSyncable(true));
        STAMINA_REGEN = REGISTRY.register("stamina_regen", () -> new RangedAttribute("attribute.name.epicfight.stamina_regen", 1.0, 0.0, 30.0).setSyncable(true));
        STUN_ARMOR = REGISTRY.register("stun_armor", () -> new RangedAttribute("attribute.name.epicfight.stun_armor", 0.0, 0.0, 1024.0).setSyncable(true));
        WEIGHT = REGISTRY.register("weight", () -> new RangedAttribute("attribute.name.epicfight.weight", 0.0, 0.0, 1024.0).setSyncable(true));
        MAX_STRIKES = REGISTRY.register("max_strikes", () -> new RangedAttribute("attribute.name.epicfight.max_strikes", 1.0, 1.0, 1024.0).setSyncable(true));
        ARMOR_NEGATION = REGISTRY.register("armor_negation", () -> new RangedAttribute("attribute.name.epicfight.armor_negation", 0.0, 0.0, 100.0).setSyncable(true));
        IMPACT = REGISTRY.register("impact", () -> new RangedAttribute("attribute.name.epicfight.impact", 0.5, 0.0, 1024.0).setSyncable(true));
        ASSASSINATION_RESISTANCE = REGISTRY.register("execution_resistance", () -> new RangedAttribute("attribute.name.epicfight.execution_resistance", 0.0, 0.0, 10.0).setSyncable(true));
        OFFHAND_ATTACK_SPEED = REGISTRY.register("offhand_attack_speed", () -> new RangedAttribute("attribute.name.epicfight.offhand_attack_speed", 4.0, 0.0, 1024.0).setSyncable(true));
        OFFHAND_MAX_STRIKES = REGISTRY.register("offhand_max_strikes", () -> new RangedAttribute("attribute.name.epicfight.offhand_max_strikes", 1.0, 1.0, 1024.0).setSyncable(true));
        OFFHAND_ARMOR_NEGATION = REGISTRY.register("offhand_armor_negation", () -> new RangedAttribute("attribute.name.epicfight.offhand_armor_negation", 0.0, 0.0, 100.0).setSyncable(true));
        OFFHAND_IMPACT = REGISTRY.register("offhand_impact", () -> new RangedAttribute("attribute.name.epicfight.offhand_impact", 0.5, 0.0, 1024.0).setSyncable(true));
        ARMOR_NEGATION_MODIFIER = EpicFightMod.identifier("armor_negation");
        MAX_STRIKE_MODIFIER = EpicFightMod.identifier("max_strikes");
        IMPACT_MODIFIER = EpicFightMod.identifier("impact");
        ATTACK_DAMAGE_MODIFIER = EpicFightMod.identifier("attack_damage");
        ATTACK_SPEED_MODIFIER = EpicFightMod.identifier("attack_speed");
    }

    @EventBusSubscriber(modid="epicfight")
    public static final class EventBus {
        private EventBus() {
        }

        @SubscribeEvent
        public static void entityAttributeCreationEvent(EntityAttributeCreationEvent event) {
            event.put((EntityType)EpicFightEntityTypes.WITHER_SKELETON_MINION.get(), AbstractSkeleton.createAttributes().build());
            event.put((EntityType)EpicFightEntityTypes.WITHER_GHOST_CLONE.get(), WitherGhostClone.createAttributes().build());
            event.put((EntityType)EpicFightEntityTypes.DODGE_LOCATION_INDICATOR.get(), LivingEntity.createLivingAttributes().build());
        }

        @SubscribeEvent
        public static void entityAttributeModificationEvent(EntityAttributeModificationEvent event) {
            EventBus.common((EntityType<? extends LivingEntity>)EntityType.CAVE_SPIDER, event);
            EventBus.common((EntityType<? extends LivingEntity>)EntityType.EVOKER, event);
            EventBus.common((EntityType<? extends LivingEntity>)EntityType.IRON_GOLEM, event);
            EventBus.humanoid((EntityType<? extends LivingEntity>)EntityType.PILLAGER, event);
            EventBus.common((EntityType<? extends LivingEntity>)EntityType.RAVAGER, event);
            EventBus.common((EntityType<? extends LivingEntity>)EntityType.SPIDER, event);
            EventBus.common((EntityType<? extends LivingEntity>)EntityType.VEX, event);
            EventBus.humanoid((EntityType<? extends LivingEntity>)EntityType.VINDICATOR, event);
            EventBus.humanoid((EntityType<? extends LivingEntity>)EntityType.WITCH, event);
            EventBus.common((EntityType<? extends LivingEntity>)EntityType.HOGLIN, event);
            EventBus.common((EntityType<? extends LivingEntity>)EntityType.ZOGLIN, event);
            EventBus.common((EntityType<? extends LivingEntity>)EntityType.ENDER_DRAGON, event);
            EventBus.common((EntityType<? extends LivingEntity>)EntityType.CREEPER, event);
            EventBus.humanoid((EntityType<? extends LivingEntity>)EntityType.DROWNED, event);
            EventBus.common((EntityType<? extends LivingEntity>)EntityType.ENDERMAN, event);
            EventBus.humanoid((EntityType<? extends LivingEntity>)EntityType.HUSK, event);
            EventBus.humanoid((EntityType<? extends LivingEntity>)EntityType.PIGLIN, event);
            EventBus.humanoid((EntityType<? extends LivingEntity>)EntityType.PIGLIN_BRUTE, event);
            EventBus.humanoid((EntityType<? extends LivingEntity>)EntityType.SKELETON, event);
            EventBus.humanoid((EntityType<? extends LivingEntity>)EntityType.STRAY, event);
            EventBus.humanoid((EntityType<? extends LivingEntity>)EntityType.WITHER_SKELETON, event);
            EventBus.humanoid((EntityType<? extends LivingEntity>)EntityType.ZOMBIE, event);
            EventBus.humanoid((EntityType<? extends LivingEntity>)EntityType.ZOMBIE_VILLAGER, event);
            EventBus.humanoid((EntityType<? extends LivingEntity>)EntityType.ZOMBIFIED_PIGLIN, event);
            EventBus.common((EntityType<? extends LivingEntity>)((EntityType)EpicFightEntityTypes.WITHER_SKELETON_MINION.get()), event);
            EventBus.player((EntityType<? extends LivingEntity>)EntityType.PLAYER, event);
            EventBus.dragon((EntityType<? extends EnderDragon>)EntityType.ENDER_DRAGON, event);
            EventBus.common((EntityType<? extends LivingEntity>)EntityType.WITHER, event);
            CreeperPatch.initAttributes(event);
            EnderDragonPatch.initAttributes(event);
            EndermanPatch.initAttributes(event);
            HoglinPatch.initAttributes(event);
            IronGolemPatch.initAttributes(event);
            PiglinBrutePatch.initAttributes(event);
            PiglinPatch.initAttributes(event);
            RavagerPatch.initAttributes(event);
            VindicatorPatch.initAttributes(event);
            WitherPatch.initAttributes(event);
            WitherGhostPatch.initAttributes(event);
            WitherSkeletonPatch.initAttributes(event);
            ZoglinPatch.initAttributes(event);
            ZombiePatch.initAttributes(event);
        }

        private static void common(EntityType<? extends LivingEntity> entityType, EntityAttributeModificationEvent event) {
            event.add(entityType, WEIGHT);
            event.add(entityType, ARMOR_NEGATION);
            event.add(entityType, IMPACT);
            event.add(entityType, MAX_STRIKES);
            event.add(entityType, STUN_ARMOR);
        }

        private static void humanoid(EntityType<? extends LivingEntity> entityType, EntityAttributeModificationEvent event) {
            EventBus.common(entityType, event);
            event.add(entityType, OFFHAND_ATTACK_SPEED);
            event.add(entityType, OFFHAND_MAX_STRIKES);
            event.add(entityType, OFFHAND_ARMOR_NEGATION);
            event.add(entityType, OFFHAND_IMPACT);
        }

        private static void player(EntityType<? extends LivingEntity> entityType, EntityAttributeModificationEvent event) {
            EventBus.humanoid(entityType, event);
            event.add(entityType, MAX_STAMINA);
            event.add(entityType, STAMINA_REGEN);
        }

        private static void dragon(EntityType<? extends EnderDragon> entityType, EntityAttributeModificationEvent event) {
            EventBus.common(entityType, event);
            event.add(entityType, Attributes.ATTACK_DAMAGE);
        }
    }
}

