/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.passive;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.attributes.Attributes;
import yesman.epicfight.api.neoevent.playerpatch.DodgeSuccessEvent;
import yesman.epicfight.registry.entries.EpicFightParticles;
import yesman.epicfight.registry.entries.EpicFightSounds;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillEvent;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class CatharsisSkill
extends PassiveSkill {
    private float regenBonus;

    public CatharsisSkill(SkillBuilder<?> builder) {
        super((SkillBuilder<? extends SkillBuilder>)builder);
    }

    @Override
    public void loadDatapackParameters(CompoundTag parameters) {
        super.loadDatapackParameters(parameters);
        this.regenBonus = parameters.getFloat("regen_bonus");
    }

    @SkillEvent(caller="epicfight", side=SkillEvent.Side.SERVER)
    public void dodgeSuccessEvent(DodgeSuccessEvent event, SkillContainer container) {
        SkillContainer innateSkillContainer = container.getExecutor().getSkill(SkillSlots.WEAPON_INNATE);
        if (innateSkillContainer.getSkill() != null && innateSkillContainer.getStack() < innateSkillContainer.getSkill().getMaxStack()) {
            ServerPlayer serverplayer = (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
            ((ServerPlayerPatch)event.getPlayerPatch()).playSound((SoundEvent)EpicFightSounds.CATHARSIS.get(), 1.0f, 1.0f, 1.0f);
            serverplayer.serverLevel().sendParticles((ParticleOptions)((SimpleParticleType)EpicFightParticles.CATHARSIS.get()), serverplayer.getX(), serverplayer.getEyeY(), serverplayer.getZ(), 0, 0.0, 0.0, 0.0, 0.0);
            float damage = (float)serverplayer.getAttributeValue(Attributes.ATTACK_DAMAGE);
            innateSkillContainer.getSkill().setConsumptionSynchronize(innateSkillContainer, innateSkillContainer.getResource() + damage + this.consumption * this.regenBonus);
        }
    }
}

