/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.passive;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import yesman.epicfight.api.neoevent.playerpatch.PlayerKilledEvent;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillEvent;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageTypeTags;
import yesman.epicfight.world.entity.DeathHarvestOrb;

public class DeathHarvestSkill
extends PassiveSkill {
    public DeathHarvestSkill(SkillBuilder<?> builder) {
        super((SkillBuilder<? extends SkillBuilder>)builder);
    }

    @SkillEvent(caller="epicfight", side=SkillEvent.Side.SERVER)
    public void dealDamageEvent(PlayerKilledEvent event, SkillContainer skillContainer) {
        PlayerPatch<?> playerpatch = skillContainer.getExecutor();
        Player original = (Player)playerpatch.getOriginal();
        LivingEntity target = event.getKilledEntity();
        if (event.getDamageSource().is(EpicFightDamageTypeTags.WEAPON_INNATE)) {
            original.level().playSound(null, original.getX(), original.getY(), original.getZ(), SoundEvents.WITHER_AMBIENT, original.getSoundSource(), 0.3f, 1.25f);
            int damage = (int)original.getAttributeValue(Attributes.ATTACK_DAMAGE);
            DeathHarvestOrb harvestOrb = new DeathHarvestOrb(original, target.getX(), target.getY() + (double)target.getBbHeight() * 0.5, target.getZ(), damage);
            original.level().addFreshEntity((Entity)harvestOrb);
        }
    }
}

