/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.weaponinnate;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;

public class ConditionalWeaponInnateSkill
extends WeaponInnateSkill {
    protected final AnimationManager.AnimationAccessor<? extends AttackAnimation>[] attackAnimations;
    protected final Function<ServerPlayerPatch, Integer> selector;

    public static Builder createConditionalWeaponInnateBuilder() {
        return (Builder)((Builder)new Builder((Function<Builder, ? extends ConditionalWeaponInnateSkill>)((Function<Builder, ConditionalWeaponInnateSkill>)ConditionalWeaponInnateSkill::new)).setCategory(SkillCategories.WEAPON_INNATE)).setResource(Skill.Resource.WEAPON_CHARGE);
    }

    public static Builder createConditionalWeaponInnateBuilder(Function<Builder, ? extends ConditionalWeaponInnateSkill> constructor) {
        return (Builder)((Builder)new Builder(constructor).setCategory(SkillCategories.WEAPON_INNATE)).setResource(Skill.Resource.WEAPON_CHARGE);
    }

    public ConditionalWeaponInnateSkill(Builder builder) {
        super(builder);
        this.attackAnimations = builder.animations;
        this.selector = builder.selector;
    }

    @Override
    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerCap) {
        List<Component> list = super.getTooltipOnItem(itemStack, cap, playerCap);
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(0), "Each Strikes:");
        return list;
    }

    @Override
    public WeaponInnateSkill registerPropertiesToAnimation() {
        for (AnimationManager.AnimationAccessor<? extends AttackAnimation> animationProvider : this.attackAnimations) {
            AttackAnimation anim = (AttackAnimation)animationProvider.get();
            for (AttackAnimation.Phase phase : anim.phases) {
                phase.addProperties(((Map)this.properties.get(0)).entrySet());
            }
        }
        return this;
    }

    @Override
    public void executeOnServer(SkillContainer containter, CompoundTag arguments) {
        this.playSkillAnimation(containter.getServerExecutor());
        super.executeOnServer(containter, arguments);
    }

    protected int getAnimationInCondition(ServerPlayerPatch executor) {
        return this.selector.apply(executor);
    }

    protected void playSkillAnimation(ServerPlayerPatch executor) {
        executor.playAnimationSynchronized(this.attackAnimations[this.getAnimationInCondition(executor)], 0.0f);
    }

    public static final class Builder
    extends WeaponInnateSkill.Builder<Builder> {
        protected Function<ServerPlayerPatch, Integer> selector;
        protected AnimationManager.AnimationAccessor<? extends AttackAnimation>[] animations;

        public Builder(Function<Builder, ? extends ConditionalWeaponInnateSkill> constructor) {
            super(constructor);
        }

        public Builder setSelector(Function<ServerPlayerPatch, Integer> selector) {
            this.selector = selector;
            return this;
        }

        @SafeVarargs
        public final Builder setAnimations(AnimationManager.AnimationAccessor<? extends AttackAnimation> ... animations) {
            this.animations = animations;
            return this;
        }
    }
}

