/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities;

import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import net.neoforged.neoforge.capabilities.ItemCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.registry.entries.EpicFightAttachmentTypes;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.provider.AttachmentEntityPatchProvider;
import yesman.epicfight.world.capabilities.provider.CommonEntityPatchProvider;
import yesman.epicfight.world.capabilities.provider.CommonItemCapabilityProvider;

@EventBusSubscriber(modid="epicfight")
public class EpicFightCapabilities {
    public static final ItemCapability<CapabilityItem, Void> CAPABILITY_ITEM = ItemCapability.createVoid((ResourceLocation)EpicFightMod.identifier("item_capability"), CapabilityItem.class);
    public static final CommonEntityPatchProvider ENTITY_PATCH_PROVIDER = CommonEntityPatchProvider.INSTANCE;
    public static final CommonItemCapabilityProvider ITEM_CAPABILITY_PROVIDER = CommonItemCapabilityProvider.INSTANCE;

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        BuiltInRegistries.ITEM.forEach(item -> event.registerItem(CAPABILITY_ITEM, (ICapabilityProvider)ITEM_CAPABILITY_PROVIDER, new ItemLike[]{item}));
    }

    @Nullable
    public static CapabilityItem getItemStackCapability(ItemStack stack) {
        return EpicFightCapabilities.getItemCapability(stack).orElse(CapabilityItem.EMPTY);
    }

    public static Optional<CapabilityItem> getItemCapability(ItemStack stack) {
        return Optional.ofNullable((CapabilityItem)stack.getCapability(CAPABILITY_ITEM));
    }

    public static <T extends EntityPatch<?>> T getEntityPatch(Entity entity, Class<T> type) {
        AttachmentEntityPatchProvider attachmentEntitypatchProvider;
        EntityPatch<?> entitypatch;
        if (entity != null && (entitypatch = (attachmentEntitypatchProvider = (AttachmentEntityPatchProvider)entity.getData(EpicFightAttachmentTypes.ENTITY_PATCH)).getCapability()) != null && type.isAssignableFrom(entitypatch.getClass())) {
            return (T)entitypatch;
        }
        return null;
    }

    public static <T extends EntityPatch<?>> Optional<T> getUnparameterizedEntityPatch(Entity entity, Class<T> type) {
        AttachmentEntityPatchProvider attachmentEntitypatchProvider;
        EntityPatch<?> entitypatch;
        if (entity != null && (entitypatch = (attachmentEntitypatchProvider = (AttachmentEntityPatchProvider)entity.getData(EpicFightAttachmentTypes.ENTITY_PATCH)).getCapability()) != null && type.isAssignableFrom(entitypatch.getClass())) {
            return Optional.of(entitypatch);
        }
        return Optional.empty();
    }

    public static <E extends Entity, T extends EntityPatch<E>> Optional<T> getParameterizedEntityPatch(Entity entity, Class<E> entitytype, Class<?> patchtype) {
        AttachmentEntityPatchProvider attachmentEntitypatchProvider;
        EntityPatch<?> entitypatch;
        if (entity != null && entitytype.isAssignableFrom(entity.getClass()) && (entitypatch = (attachmentEntitypatchProvider = (AttachmentEntityPatchProvider)entity.getData(EpicFightAttachmentTypes.ENTITY_PATCH)).getCapability()) != null && patchtype.isAssignableFrom(entitypatch.getClass())) {
            return Optional.of(entitypatch);
        }
        return Optional.empty();
    }

    public static Optional<PlayerPatch<?>> getPlayerPatch(Entity entity) {
        AttachmentEntityPatchProvider attachmentEntitypatchProvider = (AttachmentEntityPatchProvider)entity.getData(EpicFightAttachmentTypes.ENTITY_PATCH);
        EntityPatch<?> entitypatch = attachmentEntitypatchProvider.getCapability();
        if (entitypatch instanceof PlayerPatch) {
            PlayerPatch playerpatch = (PlayerPatch)entitypatch;
            return Optional.of(playerpatch);
        }
        return Optional.empty();
    }

    public static Optional<LocalPlayerPatch> getLocalPlayerPatch(Entity entity) {
        AttachmentEntityPatchProvider attachmentEntitypatchProvider = (AttachmentEntityPatchProvider)entity.getData(EpicFightAttachmentTypes.ENTITY_PATCH);
        EntityPatch<?> entitypatch = attachmentEntitypatchProvider.getCapability();
        if (entitypatch instanceof LocalPlayerPatch) {
            LocalPlayerPatch localplayerpatch = (LocalPlayerPatch)entitypatch;
            return Optional.of(localplayerpatch);
        }
        return Optional.empty();
    }

    public static Optional<ServerPlayerPatch> getServerPlayerPatch(Entity entity) {
        AttachmentEntityPatchProvider attachmentEntitypatchProvider = (AttachmentEntityPatchProvider)entity.getData(EpicFightAttachmentTypes.ENTITY_PATCH);
        EntityPatch<?> entitypatch = attachmentEntitypatchProvider.getCapability();
        if (entitypatch instanceof ServerPlayerPatch) {
            ServerPlayerPatch serverplayerpatch = (ServerPlayerPatch)entitypatch;
            return Optional.of(serverplayerpatch);
        }
        return Optional.empty();
    }
}

