/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPSetAttackTarget;
import yesman.epicfight.registry.entries.EpicFightAttributes;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.Factions;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.item.ArmorCapability;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.entity.ai.goal.AnimatedAttackGoal;
import yesman.epicfight.world.entity.ai.goal.TargetChasingGoal;

public abstract class MobPatch<T extends Mob>
extends LivingEntityPatch<T> {
    protected final Faction mobFaction;

    public MobPatch(T entity) {
        super(entity);
        this.mobFaction = Factions.NEUTRAL;
    }

    public MobPatch(T entity, Faction faction) {
        super(entity);
        this.mobFaction = faction;
    }

    @Override
    public void onJoinWorld(T entity, EntityJoinLevelEvent event) {
        super.onJoinWorld(entity, event);
        if (!entity.level().isClientSide() && !((Mob)this.original).isNoAi()) {
            this.initAI();
        }
    }

    protected void initAI() {
        if (((Mob)this.original).getBrain().availableBehaviorsByPriority.isEmpty()) {
            HashSet toRemove = Sets.newHashSet();
            this.selectGoalToRemove(toRemove);
            toRemove.forEach(arg_0 -> ((GoalSelector)((Mob)this.original).goalSelector).removeGoal(arg_0));
        }
    }

    protected void selectGoalToRemove(Set<Goal> toRemove) {
        for (WrappedGoal wrappedGoal : ((Mob)this.original).goalSelector.getAvailableGoals()) {
            Goal goal = wrappedGoal.getGoal();
            if (!(goal instanceof MeleeAttackGoal) && !(goal instanceof AnimatedAttackGoal) && !(goal instanceof RangedAttackGoal) && !(goal instanceof TargetChasingGoal)) continue;
            toRemove.add(goal);
        }
    }

    protected final void commonMobUpdateMotion(boolean considerInaction) {
        this.currentLivingMotion = ((Mob)this.original).getHealth() <= 0.0f ? LivingMotions.DEATH : (this.state.inaction() && considerInaction ? LivingMotions.INACTION : (((Mob)this.original).getVehicle() != null ? LivingMotions.MOUNT : (((Mob)this.original).getDeltaMovement().y < (double)-0.55f || this.isAirborneState() ? LivingMotions.FALL : (((Mob)this.original).walkAnimation.speed() > 0.01f ? LivingMotions.WALK : LivingMotions.IDLE))));
        this.currentCompositeMotion = this.currentLivingMotion;
    }

    protected final void commonAggressiveMobUpdateMotion(boolean considerInaction) {
        this.currentLivingMotion = ((Mob)this.original).getHealth() <= 0.0f ? LivingMotions.DEATH : (this.state.inaction() && considerInaction ? LivingMotions.IDLE : (((Mob)this.original).getVehicle() != null ? LivingMotions.MOUNT : (((Mob)this.original).getDeltaMovement().y < (double)-0.55f || this.isAirborneState() ? LivingMotions.FALL : (((Mob)this.original).walkAnimation.speed() > 0.08f ? (((Mob)this.original).isAggressive() ? LivingMotions.CHASE : LivingMotions.WALK) : LivingMotions.IDLE))));
        this.currentCompositeMotion = this.currentLivingMotion;
    }

    protected final void commonAggressiveRangedMobUpdateMotion(boolean considerInaction) {
        this.commonAggressiveMobUpdateMotion(considerInaction);
        UseAnim useAction = ((Mob)this.original).getItemInHand(((Mob)this.original).getUsedItemHand()).getUseAnimation();
        this.currentCompositeMotion = this.getClientAnimator().getCompositeLayer((Layer.Priority)Layer.Priority.MIDDLE).animationPlayer.getRealAnimation().get().isReboundAnimation() ? LivingMotions.SHOT : (((Mob)this.original).isUsingItem() ? (useAction == UseAnim.CROSSBOW ? LivingMotions.RELOAD : LivingMotions.AIM) : (CrossbowItem.isCharged((ItemStack)((Mob)this.original).getMainHandItem()) ? LivingMotions.AIM : this.currentLivingMotion));
    }

    @Override
    public void updateArmor(ArmorCapability fromCap, ArmorCapability toCap, EquipmentSlot slotType) {
        if (((Mob)this.original).getAttributes().hasAttribute(EpicFightAttributes.STUN_ARMOR)) {
            if (fromCap != null) {
                ((Mob)this.original).getAttributes().removeAttributeModifiers(fromCap.getAttributeModifiersForArmor());
            }
            if (toCap != null) {
                ((Mob)this.original).getAttributes().addTransientAttributeModifiers(toCap.getAttributeModifiersForArmor());
            }
        }
    }

    @Override
    public boolean isTargetInvulnerable(Entity entity) {
        MobPatch mobpatch = EpicFightCapabilities.getEntityPatch(entity, MobPatch.class);
        if (mobpatch != null && mobpatch.mobFaction.equals(this.mobFaction)) {
            if (this.getTarget() == null) {
                return true;
            }
            return !this.getTarget().is(entity);
        }
        return super.isTargetInvulnerable(entity);
    }

    @Override
    public AttackResult attack(EpicFightDamageSource damageSource, Entity target, InteractionHand hand) {
        boolean offhandValid = this.isOffhandItemValid();
        ItemStack mainHandItem = ((Mob)this.getOriginal()).getMainHandItem();
        ItemStack offHandItem = ((Mob)this.getOriginal()).getOffhandItem();
        List<AttributeModifier> mainHandAttributes = CapabilityItem.getAttributeModifiersAsWeapon((Holder<Attribute>)Attributes.ATTACK_DAMAGE, EquipmentSlot.MAINHAND, ((Mob)this.original).getMainHandItem(), this);
        Set<AttributeModifier> offHandAttributes = this.isOffhandItemValid() ? CapabilityItem.getAttributeModifiersAsWeapon((Holder<Attribute>)Attributes.ATTACK_DAMAGE, EquipmentSlot.MAINHAND, ((Mob)this.original).getOffhandItem(), this) : Set.of();
        this.epicFightDamageSource = damageSource;
        this.setOffhandDamage(hand, mainHandItem, offHandItem, offhandValid, mainHandAttributes, offHandAttributes);
        ((Mob)this.original).doHurtTarget(target);
        this.recoverMainhandDamage(hand, mainHandItem, offHandItem, mainHandAttributes, offHandAttributes);
        this.epicFightDamageSource = null;
        return super.attack(damageSource, target, hand);
    }

    @Override
    public LivingEntity getTarget() {
        return ((Mob)this.original).getTarget();
    }

    public void setAttakTargetSync(LivingEntity entityIn) {
        if (!((Mob)this.original).level().isClientSide()) {
            ((Mob)this.original).setTarget(entityIn);
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(new SPSetAttackTarget(((Mob)this.original).getId(), entityIn != null ? entityIn.getId() : -1), this.original, new CustomPacketPayload[0]);
        }
    }

    @Override
    public float getAttackDirectionPitch(float partialTick) {
        LivingEntity attackTarget = this.getTarget();
        if (attackTarget != null) {
            Vec3 target = attackTarget.getEyePosition(partialTick);
            Vec3 vector3d = ((Mob)this.original).getEyePosition(partialTick);
            double d0 = target.x - vector3d.x;
            double d1 = target.y - vector3d.y;
            double d2 = target.z - vector3d.z;
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            return Mth.clamp((float)Mth.wrapDegrees((float)((float)(Mth.atan2((double)d1, (double)d3) * 57.2957763671875))), (float)-30.0f, (float)30.0f);
        }
        return super.getAttackDirectionPitch(partialTick);
    }

    @Override
    public Faction getFaction() {
        return this.mobFaction;
    }
}

