/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.mob;

import java.util.Set;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.SwellGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.registry.entries.EpicFightAttributes;
import yesman.epicfight.world.capabilities.entitypatch.Factions;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.ai.goal.CreeperSwellStoppableGoal;

public class CreeperPatch
extends MobPatch<Creeper> {
    public CreeperPatch(Creeper creeper) {
        super(creeper, Factions.NEUTRAL);
    }

    public static void initAttributes(EntityAttributeModificationEvent event) {
        event.add(EntityType.CREEPER, EpicFightAttributes.STUN_ARMOR, 1.0);
    }

    @Override
    protected void selectGoalToRemove(Set<Goal> toRemove) {
        for (WrappedGoal wrappedGoal : ((Creeper)this.original).goalSelector.getAvailableGoals()) {
            Goal goal = wrappedGoal.getGoal();
            if (!(goal instanceof SwellGoal)) continue;
            toRemove.add(goal);
        }
    }

    @Override
    protected void initAI() {
        super.initAI();
        ((Creeper)this.original).goalSelector.addGoal(2, (Goal)new CreeperSwellStoppableGoal(this, (Creeper)this.original));
    }

    @Override
    public void initAnimator(Animator animator) {
        super.initAnimator(animator);
        animator.addLivingAnimation(LivingMotions.IDLE, Animations.CREEPER_IDLE);
        animator.addLivingAnimation(LivingMotions.WALK, Animations.CREEPER_WALK);
        animator.addLivingAnimation(LivingMotions.DEATH, Animations.CREEPER_DEATH);
    }

    @Override
    public void preTickServer(EntityTickEvent.Pre event) {
        super.preTickServer(event);
        if (this.getEntityState().inaction()) {
            for (WrappedGoal goal : ((Creeper)this.original).goalSelector.getAvailableGoals()) {
                if (!(goal.getGoal() instanceof CreeperSwellStoppableGoal) || !goal.isRunning()) continue;
                goal.stop();
            }
        }
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        super.commonMobUpdateMotion(considerInaction);
    }

    @Override
    public OpenMatrix4f getModelMatrix(float partialTicks) {
        OpenMatrix4f mat = super.getModelMatrix(partialTicks);
        if (this.isLogicalClient()) {
            float f = ((Creeper)this.original).getSwelling(partialTicks);
            float f1 = 1.0f + Mth.sin((float)(f * 100.0f)) * f * 0.01f;
            f = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
            f *= f;
            f *= f;
            float f2 = (1.0f + f * 0.4f) * f1;
            float f3 = (1.0f + f * 0.1f) / f1;
            OpenMatrix4f.scale(new Vec3f(f2, f3, f2), mat, mat);
        }
        return mat;
    }

    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getHitAnimation(StunType stunType) {
        if (stunType == StunType.LONG) {
            return Animations.CREEPER_HIT_LONG;
        }
        return Animations.CREEPER_HIT_SHORT;
    }
}

