/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.mob;

import com.google.common.collect.ImmutableMap;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Drowned;
import yesman.epicfight.gameasset.MobCombatBehaviors;
import yesman.epicfight.world.capabilities.entitypatch.HumanoidMobPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.ZombiePatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.ai.goal.AnimatedAttackGoal;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviors;
import yesman.epicfight.world.entity.ai.goal.TargetChasingGoal;

public class DrownedPatch
extends ZombiePatch<Drowned> {
    public DrownedPatch(Drowned original) {
        super(original);
    }

    @Override
    protected void setWeaponMotions() {
        super.setWeaponMotions();
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.TRIDENT, ImmutableMap.of((Object)CapabilityItem.Styles.COMMON, MobCombatBehaviors.DROWNED_TRIDENT));
    }

    @Override
    public void setAIAsInfantry(boolean holdingRanedWeapon) {
        CombatBehaviors.Builder<HumanoidMobPatch<?>> builder = this.getHoldingItemWeaponMotionBuilder();
        if (builder != null) {
            ((Drowned)this.original).goalSelector.addGoal(0, new AnimatedAttackGoal<DrownedPatch>(this, builder.build(this)));
            ((Drowned)this.original).goalSelector.addGoal(1, (Goal)new DrownedTargetChasingGoal(this, (PathfinderMob)this.getOriginal(), 1.0, true));
        }
    }

    static class DrownedTargetChasingGoal
    extends TargetChasingGoal {
        private final Drowned drowned;

        public DrownedTargetChasingGoal(DrownedPatch mobpatch, PathfinderMob pathfinderMob, double speedModifier, boolean longMemory) {
            super(mobpatch, pathfinderMob, speedModifier, longMemory);
            this.drowned = (Drowned)mobpatch.getOriginal();
        }

        public boolean canUse() {
            return super.canUse() && this.drowned.okTarget(this.drowned.getTarget());
        }

        public boolean canContinueToUse() {
            return super.canContinueToUse() && this.drowned.okTarget(this.drowned.getTarget());
        }
    }
}

