/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.player;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.neoevent.InnateSkillChangeEvent;
import yesman.epicfight.api.neoevent.playerpatch.DodgeSuccessEvent;
import yesman.epicfight.api.neoevent.playerpatch.PlayerPatchEvent;
import yesman.epicfight.api.neoevent.playerpatch.SetTargetEvent;
import yesman.epicfight.api.neoevent.playerpatch.TakeDamageEvent;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPChangeLivingMotion;
import yesman.epicfight.network.server.SPInitSkills;
import yesman.epicfight.network.server.SPModifyPlayerData;
import yesman.epicfight.network.server.SPSkillFeedback;
import yesman.epicfight.registry.entries.EpicFightAttributes;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.modules.HoldableSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;

public class ServerPlayerPatch
extends PlayerPatch<ServerPlayer> {
    private LivingEntity attackTarget;
    private boolean updatedMotionCurrentTick;

    public ServerPlayerPatch(ServerPlayer entity) {
        super(entity);
    }

    @Override
    public void onJoinWorld(ServerPlayer player, EntityJoinLevelEvent event) {
        super.onJoinWorld(player, event);
        EpicFightNetworkManager.sendToPlayer(new SPInitSkills(this.getPlayerSkills()), player, new CustomPacketPayload[0]);
    }

    @Override
    public void onStartTracking(ServerPlayer trackingPlayer) {
        EpicFightNetworkManager.PayloadBundleBuilder payloadBundleBuilder = EpicFightNetworkManager.PayloadBundleBuilder.create();
        SPChangeLivingMotion msg = new SPChangeLivingMotion(((ServerPlayer)this.getOriginal()).getId());
        msg.putEntries(((Animator)this.getAnimator()).getLivingAnimations().entrySet());
        payloadBundleBuilder.and(msg);
        this.getPlayerSkills().listSkillContainers().filter(skillContainer -> !skillContainer.isEmpty() && skillContainer.getSkill().getCategory().shouldSynchronize()).forEach(skillContainer -> {
            payloadBundleBuilder.and(skillContainer.createSyncPacketToRemotePlayer());
            skillContainer.getDataManager().onTracked(payloadBundleBuilder);
            skillContainer.getSkill().onTracked((SkillContainer)skillContainer, payloadBundleBuilder);
        });
        payloadBundleBuilder.and(SPModifyPlayerData.setPlayerMode(((ServerPlayer)this.getOriginal()).getId(), this.playerMode));
        payloadBundleBuilder.send((first, others) -> EpicFightNetworkManager.sendToPlayer(first, trackingPlayer, others));
    }

    @Override
    public void preTick(EntityTickEvent.Pre event) {
        super.preTick(event);
        this.updatedMotionCurrentTick = false;
    }

    @Override
    public void updateMotion(boolean considerInaction) {
    }

    @Override
    public void updateHeldItem(CapabilityItem fromCap, CapabilityItem toCap, ItemStack from, ItemStack to, InteractionHand hand) {
        if (this.isHoldingAny()) {
            this.getSkillContainerFor(this.holdingSkill.asSkill()).ifPresent(container -> {
                container.getSkill().cancelOnServer((SkillContainer)container, null);
                EpicFightNetworkManager.sendToPlayer(SPSkillFeedback.expired(container.getSlot()), (ServerPlayer)this.original, new CustomPacketPayload[0]);
            });
            this.resetHolding();
        }
        CapabilityItem mainHandCap = hand == InteractionHand.MAIN_HAND ? toCap : this.getHoldingItemCapability(InteractionHand.MAIN_HAND);
        mainHandCap.changeWeaponInnateSkill(this, hand == InteractionHand.MAIN_HAND ? to : ((ServerPlayer)this.original).getMainHandItem());
        NeoForge.EVENT_BUS.post((Event)new InnateSkillChangeEvent(this, from, fromCap, to, toCap, hand));
        if (hand == InteractionHand.OFF_HAND) {
            Multimap<Holder<Attribute>, AttributeModifier> modifiers;
            if (!from.isEmpty()) {
                from.getAttributeModifiers().forEach(EquipmentSlot.MAINHAND, (attribute, modifier) -> {
                    if (Attributes.ATTACK_SPEED.equals(attribute)) {
                        ((ServerPlayer)this.original).getAttribute(EpicFightAttributes.OFFHAND_ATTACK_SPEED).removeModifier(modifier);
                    }
                });
            }
            if (!fromCap.isEmpty()) {
                modifiers = fromCap.getAllAttributeModifiers();
                modifiers.get(EpicFightAttributes.ARMOR_NEGATION).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).getAttribute(EpicFightAttributes.OFFHAND_ARMOR_NEGATION)).removeModifier(arg_0));
                modifiers.get(EpicFightAttributes.IMPACT).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).getAttribute(EpicFightAttributes.OFFHAND_IMPACT)).removeModifier(arg_0));
                modifiers.get(EpicFightAttributes.MAX_STRIKES).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).getAttribute(EpicFightAttributes.OFFHAND_MAX_STRIKES)).removeModifier(arg_0));
                modifiers.get((Object)Attributes.ATTACK_SPEED).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).getAttribute(EpicFightAttributes.OFFHAND_ATTACK_SPEED)).removeModifier(arg_0));
            }
            if (!to.isEmpty()) {
                to.getAttributeModifiers().forEach(EquipmentSlot.MAINHAND, (attribute, modifier) -> {
                    if (Attributes.ATTACK_SPEED.equals(attribute)) {
                        ((ServerPlayer)this.original).getAttribute(EpicFightAttributes.OFFHAND_ATTACK_SPEED).addTransientModifier(modifier);
                    }
                });
            }
            if (!toCap.isEmpty()) {
                modifiers = toCap.getAttributeModifiers(this);
                modifiers.get(EpicFightAttributes.ARMOR_NEGATION).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).getAttribute(EpicFightAttributes.OFFHAND_ARMOR_NEGATION)).addTransientModifier(arg_0));
                modifiers.get(EpicFightAttributes.IMPACT).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).getAttribute(EpicFightAttributes.OFFHAND_IMPACT)).addTransientModifier(arg_0));
                modifiers.get(EpicFightAttributes.MAX_STRIKES).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).getAttribute(EpicFightAttributes.OFFHAND_MAX_STRIKES)).addTransientModifier(arg_0));
                modifiers.get((Object)Attributes.ATTACK_SPEED).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).getAttribute(EpicFightAttributes.OFFHAND_ATTACK_SPEED)).addTransientModifier(arg_0));
            }
        }
        this.modifyLivingMotionByCurrentItem(true);
        super.updateHeldItem(fromCap, toCap, from, to, hand);
    }

    public void modifyLivingMotionByCurrentItem() {
        this.modifyLivingMotionByCurrentItem(false);
    }

    public void modifyLivingMotionByCurrentItem(boolean checkOldAnimations) {
        if (this.updatedMotionCurrentTick && checkOldAnimations) {
            return;
        }
        Map<LivingMotion, AssetAccessor<? extends StaticAnimation>> oldLivingAnimations = ((Animator)this.getAnimator()).getLivingAnimations();
        HashMap newLivingAnimations = Maps.newHashMap();
        CapabilityItem mainhandCap = this.getHoldingItemCapability(InteractionHand.MAIN_HAND);
        CapabilityItem offhandCap = this.getAdvancedHoldingItemCapability(InteractionHand.OFF_HAND);
        HashMap<LivingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation>> livingMotionModifiers = new HashMap<LivingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation>>(mainhandCap.getLivingMotionModifier(this, InteractionHand.MAIN_HAND));
        livingMotionModifiers.putAll(offhandCap.getLivingMotionModifier(this, InteractionHand.OFF_HAND));
        for (Map.Entry entry : livingMotionModifiers.entrySet()) {
            AssetAccessor aniamtion = (AssetAccessor)entry.getValue();
            if (!oldLivingAnimations.containsKey(entry.getKey())) {
                this.updatedMotionCurrentTick = true;
            } else if (oldLivingAnimations.get(entry.getKey()) != aniamtion) {
                this.updatedMotionCurrentTick = true;
            }
            newLivingAnimations.put((LivingMotion)entry.getKey(), aniamtion);
        }
        for (LivingMotion oldLivingMotion : oldLivingAnimations.keySet()) {
            if (newLivingAnimations.containsKey(oldLivingMotion)) continue;
            this.updatedMotionCurrentTick = true;
            break;
        }
        if (this.updatedMotionCurrentTick || !checkOldAnimations) {
            ((Animator)this.getAnimator()).resetLivingAnimations();
            newLivingAnimations.forEach((arg_0, arg_1) -> this.getAnimator().addLivingAnimation(arg_0, arg_1));
            SPChangeLivingMotion msg = new SPChangeLivingMotion(((ServerPlayer)this.original).getId());
            msg.putEntries(newLivingAnimations.entrySet());
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(msg, (ServerPlayer)this.original, new CustomPacketPayload[0]);
        }
    }

    @Override
    public void sendToAllPlayersTrackingMe(CustomPacketPayload packet, CustomPacketPayload ... otherPackets) {
        if (!this.isLogicalClient()) {
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(packet, (ServerPlayer)this.original, otherPackets);
        }
    }

    @Override
    public void setModelYRot(float amount, boolean sendPacket) {
        super.setModelYRot(amount, sendPacket);
        if (sendPacket) {
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(SPModifyPlayerData.setPlayerYRot(((ServerPlayer)this.original).getId(), this.modelYRot), (ServerPlayer)this.original, new CustomPacketPayload[0]);
        }
    }

    @Override
    public void disableModelYRot(boolean sendPacket) {
        super.disableModelYRot(sendPacket);
        if (sendPacket) {
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(SPModifyPlayerData.disablePlayerYRot(((ServerPlayer)this.original).getId()), (ServerPlayer)this.original, new CustomPacketPayload[0]);
        }
    }

    @Override
    public AttackResult tryHurt(DamageSource damageSource, float amount) {
        if (((ServerPlayer)this.getOriginal()).getAbilities().invulnerable && !damageSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return AttackResult.missed(amount);
        }
        TakeDamageEvent.Income takeDamageEvent$pre = new TakeDamageEvent.Income(this, damageSource, amount);
        if (PlayerPatchEvent.postAndFireSkillListeners(takeDamageEvent$pre).isCanceled()) {
            return new AttackResult(takeDamageEvent$pre.getResult(), takeDamageEvent$pre.getDamage());
        }
        return super.tryHurt(damageSource, amount);
    }

    @Override
    public void onDodgeSuccess(DamageSource damageSource, Vec3 location) {
        super.onDodgeSuccess(damageSource, location);
        DodgeSuccessEvent dodgeSuccessEvent = new DodgeSuccessEvent(this, damageSource, location);
        PlayerPatchEvent.postAndFireSkillListeners(dodgeSuccessEvent);
    }

    @Override
    public void toVanillaMode(boolean synchronize) {
        super.toVanillaMode(synchronize);
        if (synchronize) {
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(SPModifyPlayerData.setPlayerMode(((ServerPlayer)this.original).getId(), PlayerPatch.PlayerMode.VANILLA), (ServerPlayer)this.original, new CustomPacketPayload[0]);
        }
    }

    @Override
    public void toEpicFightMode(boolean synchronize) {
        super.toEpicFightMode(synchronize);
        if (synchronize) {
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(SPModifyPlayerData.setPlayerMode(((ServerPlayer)this.original).getId(), PlayerPatch.PlayerMode.EPICFIGHT), (ServerPlayer)this.original, new CustomPacketPayload[0]);
        }
    }

    @Override
    public boolean isTargetInvulnerable(Entity target) {
        if (target instanceof Player && !((ServerPlayer)this.getOriginal()).server.isPvpAllowed()) {
            return true;
        }
        return super.isTargetInvulnerable(target);
    }

    @Override
    public void setLastAttackSuccess(boolean setter) {
        if (setter) {
            EpicFightNetworkManager.sendToPlayer(SPModifyPlayerData.setLastAttackResult(((ServerPlayer)this.original).getId(), true), (ServerPlayer)this.original, new CustomPacketPayload[0]);
        }
        this.isLastAttackSuccess = setter;
    }

    public void setAttackTarget(LivingEntity entity) {
        SetTargetEvent event = new SetTargetEvent(this, entity);
        if (((SetTargetEvent)NeoForge.EVENT_BUS.post((Event)event)).isCanceled()) {
            return;
        }
        this.attackTarget = event.getTarget();
    }

    @Override
    public boolean startSkillHolding(HoldableSkill chargingSkill) {
        if (super.startSkillHolding(chargingSkill)) {
            EpicFightNetworkManager.sendToPlayer(SPSkillFeedback.held(this.getSkillContainerFor(chargingSkill.asSkill()).get().getSlot()), (ServerPlayer)this.getOriginal(), new CustomPacketPayload[0]);
            return true;
        }
        return false;
    }

    @Override
    public LivingEntity getTarget() {
        return this.attackTarget;
    }

    @Override
    public void setGrapplingTarget(LivingEntity grapplingTarget) {
        super.setGrapplingTarget(grapplingTarget);
        EpicFightNetworkManager.sendToPlayer(SPModifyPlayerData.setGrapplingTarget(((ServerPlayer)this.original).getId(), (Entity)grapplingTarget), (ServerPlayer)this.original, new CustomPacketPayload[0]);
    }
}

