/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantments;
import net.neoforged.neoforge.registries.DeferredHolder;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.ColliderPreset;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPChangeSkill;
import yesman.epicfight.network.server.SPSetRemotePlayerSkill;
import yesman.epicfight.network.server.SPSetSkillContainerValue;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.registry.entries.EpicFightAttributes;
import yesman.epicfight.registry.entries.EpicFightParticles;
import yesman.epicfight.registry.entries.EpicFightSounds;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.guard.GuardSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.RangedWeaponCapability;
import yesman.epicfight.world.capabilities.item.Style;
import yesman.epicfight.world.capabilities.item.WeaponCategory;

public class CapabilityItem {
    public static CapabilityItem EMPTY = CapabilityItem.builder().build();
    protected static List<AnimationManager.AnimationAccessor<? extends AttackAnimation>> commonAutoAttackMotion = Lists.newArrayList();
    protected final WeaponCategory weaponCategory;
    protected Map<Style, Map<Holder<Attribute>, AttributeModifier>> attributeMap;
    protected Map<Style, ItemAttributeModifiers> modifiers;
    protected Collider collider;

    public static List<AnimationManager.AnimationAccessor<? extends AttackAnimation>> getBasicAutoAttackMotions() {
        return commonAutoAttackMotion;
    }

    public static List<AttributeModifier> getAttributeModifiersAsWeapon(Holder<Attribute> attribute, EquipmentSlot slot, ItemStack itemstack, @Nullable LivingEntityPatch<?> entitypatch) {
        ArrayList attributeModifiers = Lists.newArrayList();
        itemstack.getAttributeModifiers().forEach(slot, (attribute$1, modifier) -> {
            if (attribute$1 == attribute) {
                attributeModifiers.add(modifier);
            }
        });
        CapabilityItem itemCapability = EpicFightCapabilities.getItemStackCapability(itemstack);
        if (!itemCapability.isEmpty()) {
            itemCapability.getAttributeModifiers(entitypatch).forEach((attribute$1, modifier) -> {
                if (attribute$1 == attribute) {
                    attributeModifiers.add(modifier);
                }
            });
        }
        return attributeModifiers;
    }

    protected CapabilityItem(Builder<?> builder) {
        this.weaponCategory = builder.category;
        this.collider = builder.collider;
        ImmutableMap.Builder attributeMapbuilder = ImmutableMap.builder();
        for (Map.Entry<Style, Map<Holder<Attribute>, AttributeModifier>> entry : builder.attributeMap.entrySet()) {
            attributeMapbuilder.put((Object)entry.getKey(), entry.getValue());
        }
        this.attributeMap = attributeMapbuilder.build();
    }

    public void modifyItemTooltip(ItemStack itemstack, List<Component> itemTooltip, LivingEntityPatch<?> entitypatch) {
        Styles style = this instanceof RangedWeaponCapability ? Styles.RANGED : this.getStyle(entitypatch);
        itemTooltip.add(1, (Component)Component.translatable((String)("epicfight.style." + style.toString().toLowerCase(Locale.ROOT))).withStyle(ChatFormatting.DARK_GRAY));
        int index = 0;
        boolean modifyIn = false;
        int i = 0;
        while (i < itemTooltip.size()) {
            Component textComp = itemTooltip.get(i);
            index = i++;
            if (this.findComponentArgument(textComp, ((Attribute)Attributes.ATTACK_SPEED.value()).getDescriptionId()) == null) continue;
            modifyIn = true;
            break;
        }
        ++index;
        Map<Holder<Attribute>, AttributeModifier> attribute = this.getDamageAttributesInCondition(style);
        if (attribute != null) {
            double value;
            if (!modifyIn) {
                itemTooltip.add(index, (Component)Component.literal((String)""));
                itemTooltip.add(++index, (Component)Component.translatable((String)"epicfight.gui.attribute").withStyle(ChatFormatting.GRAY));
                ++index;
            }
            DeferredHolder<Attribute, Attribute> armorNegation = EpicFightAttributes.ARMOR_NEGATION;
            DeferredHolder<Attribute, Attribute> impact = EpicFightAttributes.IMPACT;
            DeferredHolder<Attribute, Attribute> maxStrikes = EpicFightAttributes.MAX_STRIKES;
            if (attribute.containsKey(armorNegation) && (value = attribute.get(armorNegation).amount() + ((LivingEntity)entitypatch.getOriginal()).getAttribute(armorNegation).getBaseValue()) > 0.0) {
                itemTooltip.add(index, (Component)Component.literal((String)" ").append((Component)Component.translatable((String)(((Attribute)armorNegation.value()).getDescriptionId() + ".value"), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(value)})));
            }
            if (attribute.containsKey(impact) && (value = attribute.get(impact).amount() + ((LivingEntity)entitypatch.getOriginal()).getAttribute(impact).getBaseValue()) > 0.0) {
                int i2 = itemstack.getEnchantmentLevel(((LivingEntity)entitypatch.getOriginal()).level().holderOrThrow(Enchantments.KNOCKBACK));
                itemTooltip.add(index++, (Component)Component.literal((String)" ").append((Component)Component.translatable((String)(((Attribute)impact.value()).getDescriptionId() + ".value"), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(value *= (double)(1.0f + (float)i2 * 0.12f))})));
            }
            if (attribute.containsKey(maxStrikes)) {
                value = attribute.get(maxStrikes).amount() + ((LivingEntity)entitypatch.getOriginal()).getAttribute(maxStrikes).getBaseValue();
                if (value > 0.0) {
                    itemTooltip.add(index++, (Component)Component.literal((String)" ").append((Component)Component.translatable((String)(((Attribute)maxStrikes.value()).getDescriptionId() + ".value"), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(value)})));
                }
            } else {
                itemTooltip.add(index++, (Component)Component.literal((String)" ").append((Component)Component.translatable((String)(((Attribute)maxStrikes.value()).getDescriptionId() + ".value"), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(((Attribute)maxStrikes.value()).getDefaultValue())})));
            }
        }
    }

    private Object findComponentArgument(Component component, String key) {
        Object[] objectArray = component.getContents();
        if (objectArray instanceof TranslatableContents) {
            TranslatableContents contents = (TranslatableContents)objectArray;
            if (contents.getKey().equals(key)) {
                return component;
            }
            if (contents.getArgs() != null) {
                for (Object arg : contents.getArgs()) {
                    Component argComponent;
                    Object ret;
                    if (!(arg instanceof Component) || (ret = this.findComponentArgument(argComponent = (Component)arg, key)) == null) continue;
                    return ret;
                }
            }
        }
        for (Component siblingComponent : component.getSiblings()) {
            Object ret = this.findComponentArgument(siblingComponent, key);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public List<AnimationManager.AnimationAccessor<? extends AttackAnimation>> getAutoAttackMotion(PlayerPatch<?> playerpatch) {
        return CapabilityItem.getBasicAutoAttackMotions();
    }

    public List<AnimationManager.AnimationAccessor<? extends AttackAnimation>> getMountAttackMotion() {
        return null;
    }

    @Nullable
    public Skill getInnateSkill(PlayerPatch<?> playerpatch, ItemStack itemstack) {
        return null;
    }

    @Nullable
    public Skill getPassiveSkill() {
        return null;
    }

    public WeaponCategory getWeaponCategory() {
        return this.weaponCategory;
    }

    public void changeWeaponInnateSkill(ServerPlayerPatch playerpatch, ItemStack itemstack) {
        Skill weaponInnateSkill = this.getInnateSkill(playerpatch, itemstack);
        SkillContainer weaponInnateSkillContainer = playerpatch.getSkill(SkillSlots.WEAPON_INNATE);
        EpicFightNetworkManager.PayloadBundleBuilder toLocal = EpicFightNetworkManager.PayloadBundleBuilder.create();
        EpicFightNetworkManager.PayloadBundleBuilder toRemote = EpicFightNetworkManager.PayloadBundleBuilder.create();
        if (weaponInnateSkill != null) {
            if (weaponInnateSkillContainer.getSkill() != weaponInnateSkill) {
                weaponInnateSkillContainer.setSkill(weaponInnateSkill);
            }
            toLocal.and(new SPChangeSkill(SkillSlots.WEAPON_INNATE, ((ServerPlayer)playerpatch.getOriginal()).getId(), weaponInnateSkill.holder()));
        } else {
            toLocal.and(SPSetSkillContainerValue.enable(SkillSlots.WEAPON_INNATE, true, ((ServerPlayer)playerpatch.getOriginal()).getId()));
        }
        weaponInnateSkillContainer.setDisabled(weaponInnateSkill == null);
        toRemote.and(new SPSetRemotePlayerSkill(SkillSlots.WEAPON_INNATE, ((ServerPlayer)playerpatch.getOriginal()).getId(), Skill.holderOrNull(weaponInnateSkill)));
        Skill passiveSkill = this.getPassiveSkill();
        SkillContainer passiveSkillContainer = playerpatch.getSkill(SkillSlots.WEAPON_PASSIVE);
        if (passiveSkill != null) {
            if (passiveSkillContainer.getSkill() != passiveSkill) {
                passiveSkillContainer.setSkill(passiveSkill);
                toLocal.and(new SPChangeSkill(SkillSlots.WEAPON_PASSIVE, ((ServerPlayer)playerpatch.getOriginal()).getId(), passiveSkill.holder()));
                toRemote.and(new SPSetRemotePlayerSkill(SkillSlots.WEAPON_PASSIVE, ((ServerPlayer)playerpatch.getOriginal()).getId(), passiveSkill.holder()));
            }
        } else {
            passiveSkillContainer.setSkill(null);
            toLocal.and(new SPChangeSkill(SkillSlots.WEAPON_PASSIVE, ((ServerPlayer)playerpatch.getOriginal()).getId(), null));
            toRemote.and(new SPSetRemotePlayerSkill(SkillSlots.WEAPON_PASSIVE, ((ServerPlayer)playerpatch.getOriginal()).getId(), null));
        }
        toLocal.send((first, others) -> EpicFightNetworkManager.sendToPlayer(first, (ServerPlayer)playerpatch.getOriginal(), others));
        toRemote.send((first, others) -> EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(first, (Entity)((ServerPlayer)playerpatch.getOriginal()), others));
    }

    public SoundEvent getSmashingSound() {
        return (SoundEvent)EpicFightSounds.WHOOSH.get();
    }

    public SoundEvent getHitSound() {
        return (SoundEvent)EpicFightSounds.BLUNT_HIT.get();
    }

    public Collider getWeaponCollider() {
        return this.collider != null ? this.collider : ColliderPreset.FIST;
    }

    public HitParticleType getHitParticle() {
        return (HitParticleType)((Object)EpicFightParticles.HIT_BLUNT.get());
    }

    public final Map<Holder<Attribute>, AttributeModifier> getDamageAttributesInCondition(Style style) {
        Map<Holder<Attribute>, AttributeModifier> attributes = this.attributeMap.getOrDefault(style, Maps.newHashMap());
        this.attributeMap.getOrDefault(Styles.COMMON, Maps.newHashMap()).forEach(attributes::putIfAbsent);
        return attributes;
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(@Nullable LivingEntityPatch<?> entitypatch) {
        Map<Holder<Attribute>, AttributeModifier> modifierMap;
        HashMultimap map = HashMultimap.create();
        if (entitypatch != null && (modifierMap = this.getDamageAttributesInCondition(this.getStyle(entitypatch))) != null) {
            for (Map.Entry<Holder<Attribute>, AttributeModifier> entry : modifierMap.entrySet()) {
                map.put(entry.getKey(), (Object)entry.getValue());
            }
        }
        return map;
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAllAttributeModifiers() {
        HashMultimap map = HashMultimap.create();
        for (Map<Holder<Attribute>, AttributeModifier> attrMap : this.attributeMap.values()) {
            for (Map.Entry<Holder<Attribute>, AttributeModifier> entry : attrMap.entrySet()) {
                map.put(entry.getKey(), (Object)entry.getValue());
            }
        }
        return map;
    }

    public Map<LivingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation>> getLivingMotionModifier(LivingEntityPatch<?> playerpatch, InteractionHand hand) {
        return Maps.newHashMap();
    }

    public Style getStyle(LivingEntityPatch<?> entitypatch) {
        return this.canBePlacedOffhand() ? Styles.ONE_HAND : Styles.TWO_HAND;
    }

    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getGuardMotion(GuardSkill skill, GuardSkill.BlockType blockType, PlayerPatch<?> playerpatch) {
        return null;
    }

    public boolean canBePlacedOffhand() {
        return true;
    }

    public boolean shouldCancelCombo(LivingEntityPatch<?> entitypatch) {
        return true;
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public CapabilityItem findRecursive(ItemStack item) {
        return this;
    }

    public boolean availableOnHorse() {
        return true;
    }

    public boolean checkOffhandValid(LivingEntityPatch<?> entitypatch) {
        return this.getStyle(entitypatch).canUseOffhand() && EpicFightCapabilities.getItemStackCapability(((LivingEntity)entitypatch.getOriginal()).getOffhandItem()).canHoldInOffhandAlone();
    }

    public boolean canHoldInOffhandAlone() {
        return true;
    }

    public float getReach() {
        return 0.0f;
    }

    public LivingMotion getLivingMotion(LivingEntityPatch<?> entitypatch, InteractionHand hand) {
        return null;
    }

    public void onStrike(LivingEntityPatch<?> entitypatch, AttackAnimation animation) {
    }

    public UseAnim getUseAnimation(LivingEntityPatch<?> entitypatch) {
        return UseAnim.NONE;
    }

    public ZoomInType getZoomInType() {
        return ZoomInType.NONE;
    }

    public static Builder<?> builder() {
        return new Builder();
    }

    static {
        commonAutoAttackMotion.add(Animations.FIST_AUTO1);
        commonAutoAttackMotion.add(Animations.FIST_AUTO2);
        commonAutoAttackMotion.add(Animations.FIST_AUTO3);
        commonAutoAttackMotion.add(Animations.FIST_DASH);
        commonAutoAttackMotion.add(Animations.FIST_AIR_SLASH);
    }

    public static class Builder<T extends Builder<T>> {
        Function<T, CapabilityItem> constructor = CapabilityItem::new;
        Map<Style, Map<Holder<Attribute>, AttributeModifier>> attributeMap = Maps.newHashMap();
        WeaponCategory category = WeaponCategories.FIST;
        Collider collider = ColliderPreset.FIST;

        protected Builder() {
        }

        public T constructor(Function<T, CapabilityItem> constructor) {
            this.constructor = constructor;
            return (T)this;
        }

        public T category(WeaponCategory category) {
            this.category = category;
            return (T)this;
        }

        public T collider(Collider collider) {
            this.collider = collider;
            return (T)this;
        }

        public T addStyleAttibutes(Style style, Holder<Attribute> attribute, AttributeModifier attributePair) {
            Map map = this.attributeMap.computeIfAbsent(style, key -> new HashMap());
            map.put(attribute, attributePair);
            return (T)this;
        }

        public final CapabilityItem build() {
            return this.constructor.apply(this);
        }

        public Collider getCollider() {
            return this.collider;
        }
    }

    public static enum Styles implements Style
    {
        COMMON(true),
        ONE_HAND(true),
        TWO_HAND(false),
        MOUNT(true),
        RANGED(false),
        SHEATH(false),
        OCHS(false);

        final boolean canUseOffhand;
        final int id = Style.ENUM_MANAGER.assign(this);

        private Styles(boolean canUseOffhand) {
            this.canUseOffhand = canUseOffhand;
        }

        @Override
        public int universalOrdinal() {
            return this.id;
        }

        @Override
        public boolean canUseOffhand() {
            return this.canUseOffhand;
        }
    }

    public static enum ZoomInType {
        NONE,
        ALWAYS,
        USE_TICK,
        AIMING,
        CUSTOM;

    }

    public static enum WeaponCategories implements WeaponCategory
    {
        NOT_WEAPON,
        AXE,
        FIST,
        GREATSWORD,
        HOE,
        PICKAXE,
        SHOVEL,
        SWORD,
        UCHIGATANA,
        SPEAR,
        TACHI,
        TRIDENT,
        LONGSWORD,
        DAGGER,
        SHIELD,
        RANGED;

        final int id = WeaponCategory.ENUM_MANAGER.assign(this);

        @Override
        public int universalOrdinal() {
            return this.id;
        }
    }
}

