/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.projectile;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.registry.entries.EpicFightEntityTypes;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.mob.WitherSkeletonPatch;
import yesman.epicfight.world.capabilities.projectile.ProjectilePatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightDamageSources;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.WitherSkeletonMinion;
import yesman.epicfight.world.gamerule.EpicFightGameRules;

public class WitherSkullPatch
extends ProjectilePatch<WitherSkull> {
    public WitherSkullPatch(WitherSkull original) {
        super(original);
    }

    @Override
    public void onJoinWorld(WitherSkull projectileEntity, EntityJoinLevelEvent event) {
        super.onJoinWorld(projectileEntity, event);
        this.impact = 1.0f;
    }

    @Override
    protected void setMaxStrikes(WitherSkull projectileEntity, int maxStrikes) {
    }

    @Override
    public boolean onProjectileImpact(ProjectileImpactEvent event) {
        if (event.getProjectile().level().isClientSide()) {
            return false;
        }
        HitResult hitResult = event.getRayTraceResult();
        if (!(hitResult instanceof EntityHitResult)) {
            Level level = event.getProjectile().level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (Math.random() < 0.2) {
                    Vec3 location = event.getRayTraceResult().getLocation();
                    BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos(location.x, location.y, location.z);
                    Projectile projectile = event.getProjectile();
                    EntityType entityType = (EntityType)EpicFightEntityTypes.WITHER_SKELETON_MINION.get();
                    if (SpawnPlacements.isSpawnPositionOk((EntityType)entityType, (LevelReader)serverLevel, (BlockPos)blockpos) && SpawnPlacements.checkSpawnRules((EntityType)entityType, (ServerLevelAccessor)serverLevel, (MobSpawnType)MobSpawnType.REINFORCEMENT, (BlockPos)blockpos, (RandomSource)serverLevel.random) && !EpicFightGameRules.NO_MOBS_IN_BOSSFIGHT.getRuleValue((Level)serverLevel).booleanValue()) {
                        WitherBoss summoner = projectile.getOwner() instanceof WitherBoss ? (WitherBoss)projectile.getOwner() : null;
                        WitherSkeletonMinion witherskeletonminion = new WitherSkeletonMinion((Level)serverLevel, summoner, projectile.getX(), projectile.getY() + 0.1, projectile.getZ());
                        witherskeletonminion.finalizeSpawn((ServerLevelAccessor)serverLevel, serverLevel.getCurrentDifficultyAt((BlockPos)blockpos), MobSpawnType.REINFORCEMENT, null);
                        witherskeletonminion.setYRot(projectile.getYRot() - 180.0f);
                        serverLevel.addFreshEntity((Entity)witherskeletonminion);
                        EpicFightCapabilities.getParameterizedEntityPatch((Entity)witherskeletonminion, WitherSkeletonMinion.class, WitherSkeletonPatch.class).ifPresent(witherskeletonpatch -> witherskeletonpatch.playAnimationInstantly(Animations.WITHER_SKELETON_SPECIAL_SPAWN));
                    }
                }
            }
        } else {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            return entityHitResult.getEntity() instanceof WitherSkeletonMinion;
        }
        return false;
    }

    @Override
    public EpicFightDamageSource createEpicFightDamageSource() {
        return EpicFightDamageSources.witherSkull((WitherSkull)this.original, ((WitherSkull)this.original).getOwner()).setStunType(StunType.SHORT).addRuntimeTag((TagKey<DamageType>)DamageTypeTags.IS_PROJECTILE).setBaseArmorNegation(this.armorNegation).setBaseImpact(this.impact).setInitialPosition(this.initialFirePosition);
    }
}

