/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.damagesource;

import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.WitherSkull;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightDamageTypes;

public final class EpicFightDamageSources {
    private EpicFightDamageSources() {
    }

    public static EpicFightDamageSource fromVanillaDamageSource(DamageSource damageSource) {
        return new EpicFightDamageSource(damageSource);
    }

    public static EpicFightDamageSource shockwave(LivingEntity owner) {
        return new EpicFightDamageSource(EpicFightDamageSources.getDamageTypeHolder((Entity)owner, EpicFightDamageTypes.SHOCKWAVE), (Entity)owner, (Entity)owner, null);
    }

    public static EpicFightDamageSource witherBeam(LivingEntity owner) {
        return new EpicFightDamageSource(EpicFightDamageSources.getDamageTypeHolder((Entity)owner, EpicFightDamageTypes.WITHER_BEAM), (Entity)owner, (Entity)owner, null);
    }

    public static EpicFightDamageSource arrow(AbstractArrow arrow, @Nullable Entity shooter) {
        return new EpicFightDamageSource(EpicFightDamageSources.getDamageTypeHolder((Entity)arrow, (ResourceKey<DamageType>)DamageTypes.ARROW), (Entity)arrow, shooter, null);
    }

    public static EpicFightDamageSource trident(Entity trident, Entity thrower) {
        return new EpicFightDamageSource(EpicFightDamageSources.getDamageTypeHolder(trident, (ResourceKey<DamageType>)DamageTypes.TRIDENT), trident, thrower, null);
    }

    public static EpicFightDamageSource witherSkull(WitherSkull witherSkull, Entity shooter) {
        return new EpicFightDamageSource(EpicFightDamageSources.getDamageTypeHolder((Entity)witherSkull, (ResourceKey<DamageType>)DamageTypes.WITHER_SKULL), (Entity)witherSkull, shooter, null);
    }

    public static EpicFightDamageSource mobAttack(LivingEntity owner) {
        return new EpicFightDamageSource(EpicFightDamageSources.getDamageTypeHolder((Entity)owner, (ResourceKey<DamageType>)DamageTypes.MOB_ATTACK), (Entity)owner, (Entity)owner, null);
    }

    public static EpicFightDamageSource playerAttack(Player owner) {
        return new EpicFightDamageSource(EpicFightDamageSources.getDamageTypeHolder((Entity)owner, (ResourceKey<DamageType>)DamageTypes.PLAYER_ATTACK), (Entity)owner, (Entity)owner, null);
    }

    public static EpicFightDamageSource enderDragonBreath(LivingEntity owner, Entity directEntity) {
        return EpicFightDamageSources.fromVanillaDamageSource(owner.level().damageSources().indirectMagic(directEntity, (Entity)owner));
    }

    private static Holder<DamageType> getDamageTypeHolder(Entity entity, ResourceKey<DamageType> damageTypeKey) {
        return entity.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(damageTypeKey);
    }
}

