/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ProjectileWeaponItem;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviors;

public class AnimatedCombatBehavior<T extends MobPatch<?>>
extends Behavior<Mob> {
    protected final T mobpatch;
    protected final CombatBehaviors<? super T> combatBehaviors;

    public AnimatedCombatBehavior(T mobpatch, CombatBehaviors<? super T> combatBehaviors) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT));
        this.mobpatch = mobpatch;
        this.combatBehaviors = combatBehaviors;
    }

    protected boolean checkExtraStartConditions(ServerLevel levelIn, Mob entityIn) {
        return !this.isHoldingRangeWeapon(entityIn) && this.isValidTarget(((MobPatch)this.mobpatch).getTarget());
    }

    protected boolean canStillUse(ServerLevel levelIn, Mob entityIn, long gameTimeIn) {
        return this.checkExtraStartConditions(levelIn, entityIn) && BehaviorUtils.canSee((LivingEntity)entityIn, (LivingEntity)((MobPatch)this.mobpatch).getTarget()) && !((LivingEntityPatch)this.mobpatch).getEntityState().hurt();
    }

    protected void tick(ServerLevel worldIn, Mob entityIn, long gameTimeIn) {
        CombatBehaviors.Behavior<T> result;
        EntityState state = ((LivingEntityPatch)this.mobpatch).getEntityState();
        this.combatBehaviors.tick();
        if (this.combatBehaviors.hasActivatedMove()) {
            CombatBehaviors.Behavior<T> result2;
            if (state.canBasicAttack() && (result2 = this.combatBehaviors.tryProceed()) != null) {
                result2.execute(this.mobpatch);
            }
        } else if (!state.inaction() && (result = this.combatBehaviors.selectRandomBehaviorSeries()) != null) {
            result.execute(this.mobpatch);
        }
    }

    private boolean isHoldingRangeWeapon(Mob mob) {
        return mob.isHolding(stack -> {
            Item item = stack.getItem();
            return item instanceof ProjectileWeaponItem && mob.canFireProjectileWeapon((ProjectileWeaponItem)item);
        });
    }

    protected boolean isValidTarget(LivingEntity attackTarget) {
        return attackTarget != null && attackTarget.isAlive() && (!(attackTarget instanceof Player) || !attackTarget.isSpectator() && !((Player)attackTarget).isCreative());
    }
}

