/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import yesman.epicfight.registry.entries.EpicFightBlockEntities;
import yesman.epicfight.world.level.block.FractureBlockState;
import yesman.epicfight.world.level.block.entity.FractureBlockEntity;

public class FractureBlock
extends BaseEntityBlock {
    protected final StateDefinition<Block, BlockState> stateDefinition;
    private static FractureBlockState fractureBlockState;

    public FractureBlock(BlockBehaviour.Properties properties) {
        super(properties);
        StateDefinition.Builder builder = new StateDefinition.Builder((Object)this);
        this.stateDefinition = builder.create(FractureBlock::getDefaultFractureBlockState, FractureBlockState::new);
        fractureBlockState = (FractureBlockState)this.stateDefinition.any();
    }

    public static FractureBlockState getDefaultFractureBlockState(Block block) {
        return fractureBlockState;
    }

    protected ImmutableMap<BlockState, VoxelShape> getShapeForEachState(Function<BlockState, VoxelShape> p_152459_) {
        return (ImmutableMap)this.stateDefinition.getPossibleStates().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), p_152459_));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? FractureBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)EpicFightBlockEntities.FRACTURE.get()), FractureBlockEntity::lifeTimeTick) : null;
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        if (blockState instanceof FractureBlockState) {
            FractureBlockState fractureBlockState = (FractureBlockState)blockState;
            return new FractureBlockEntity(blockPos, blockState, fractureBlockState);
        }
        return null;
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return Shapes.empty();
    }

    public RenderShape getRenderShape(BlockState p_50950_) {
        return RenderShape.MODEL;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return null;
    }
}

