/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.gui.screen;

import java.net.URI;
import net.bivrik.fancytoasts.client.gui.screen.CreditsScreen;
import net.bivrik.fancytoasts.client.gui.screen.GeneralConfigScreen;
import net.bivrik.fancytoasts.client.gui.screen.ToastConfigScreen;
import net.bivrik.fancytoasts.client.gui.screen.ToastsFilteringScreen;
import net.bivrik.fancytoasts.client.gui.screen.UniversalScreen;
import net.bivrik.fancytoasts.core.Managers;
import net.bivrik.fancytoasts.platform.utility.Components;
import net.bivrik.fancytoasts.platform.utility.GuiContext;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.PlainTextButton;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.NotNull;

public class FancyToastsScreen
extends UniversalScreen {
    private static final int TITLE_BUTTON_WIDTH = 180;
    private static final int HALF_TITLE_BUTTON_WIDTH = 90;
    private static final Component TITLE = Component.literal((String)"Fancy Toasts");
    private static final Component SUPPORT_LABEL = Components.of("label.support");
    private static final Component TOAST_SETTINGS = Components.of("gui.toast_settings");
    private static final Component GENERAL_SETTINGS = Components.of("gui.general_settings");
    private static final Component TOASTS_FILTERING = Components.of("gui.toasts_filtering");
    private static final Component CREDITS = Components.of("gui.credits");
    private static final URI BOOSTY_URI = URI.create("https://boosty.to/bivrik");
    private final String splash = Managers.getSplashManager().getSplash();
    private Button backButton;
    private Button toastConfigButton;
    private Button generalConfigButton;
    private Button toastsFilteringButton;
    private Button creditsButton;
    private PlainTextButton supportButton;

    public FancyToastsScreen(Screen parent) {
        super(TITLE, parent);
    }

    protected void init() {
        int xCenter = this.width / 2 - 90;
        int yCenter = this.height / 2;
        int supportButtonWidth = this.font.width((FormattedText)SUPPORT_LABEL);
        this.toastConfigButton = this.addFWidget(this.createButton(TOAST_SETTINGS, button -> this.openToastConfigScreen(), xCenter, yCenter - 20 - 8));
        this.generalConfigButton = this.addFWidget(this.createButton(GENERAL_SETTINGS, button -> this.openGeneralConfigScreen(), xCenter, yCenter));
        this.toastsFilteringButton = this.addFWidget(this.createButton(TOASTS_FILTERING, button -> this.openToastsFilteringScreen(), xCenter, yCenter + 20 + 8, 86, 20));
        this.creditsButton = this.addFWidget(this.createButton(CREDITS, button -> this.openCreditsScreen(), xCenter + 4 + 90, yCenter + 20 + 8, 86, 20));
        this.backButton = this.addFWidget(this.createButton(CommonComponents.GUI_BACK, button -> this.toParentScreen(), xCenter, this.height - 20 - 16));
        Button.OnPress supportButtonAction = ConfirmLinkScreen.confirmLink((Screen)this, (URI)BOOSTY_URI);
        this.supportButton = this.addFWidget(new PlainTextButton(this.width - supportButtonWidth - 1, this.height - 10, supportButtonWidth, 9, SUPPORT_LABEL, supportButtonAction, this.font));
    }

    @Override
    protected Button createButton(Component label, Button.OnPress action, int x, int y) {
        return super.createButton(label, action, x, y, 180, 20);
    }

    private void openToastConfigScreen() {
        this.openScreen(new ToastConfigScreen(this));
    }

    private void openGeneralConfigScreen() {
        this.openScreen(new GeneralConfigScreen(this));
    }

    private void openToastsFilteringScreen() {
        this.openScreen(new ToastsFilteringScreen(this));
    }

    private void openCreditsScreen() {
        this.openScreen(new CreditsScreen(this));
    }

    @Override
    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.drawSplash(guiGraphics);
    }

    private void drawSplash(@NotNull GuiGraphics guiGraphics) {
        float size = (float)(Math.abs(Math.cos((double)Util.getMillis() / 250.0) * (double)0.1f) + (double)0.9f);
        GuiContext context = new GuiContext(guiGraphics);
        context.push();
        context.scaleAround(size, this.width / 2, 25.5f);
        guiGraphics.drawCenteredString(this.font, this.splash, this.width / 2, 21, -256);
        context.pop();
    }
}

