/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.registry;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.bivrik.fancytoasts.core.Debug;
import net.bivrik.fancytoasts.utility.KeyBinding;
import net.minecraft.client.KeyMapping;
import org.slf4j.Logger;

public class KeyBindingRegistry {
    private static final Logger LOGGER = Debug.getLogger(KeyBindingRegistry.class);
    private static final Map<String, KeyBinding> KEY_BINDINGS = new HashMap<String, KeyBinding>();

    public static void register(String name, int keyCode, KeyBinding.keyExecutor executor) {
        String translatableName = "key.fancytoasts." + name;
        if (KeyBindingRegistry.isRegistered(translatableName)) {
            LOGGER.warn("{} already exists, could not add", (Object)translatableName);
            return;
        }
        KeyMapping key = new KeyMapping(translatableName, keyCode, "key.categories.misc");
        KeyBinding bind = new KeyBinding(key, executor);
        KEY_BINDINGS.put(translatableName, bind);
        LOGGER.info("Registered: {}", (Object)translatableName);
    }

    public static boolean isRegistered(String keyName) {
        return KEY_BINDINGS.containsKey(keyName);
    }

    public static KeyBinding[] keyBindings() {
        return KEY_BINDINGS.values().toArray(new KeyBinding[0]);
    }

    public static KeyMapping[] getExtendedKeys(KeyMapping[] builtinKeys) {
        KeyBinding[] modKeyBindings = KeyBindingRegistry.keyBindings();
        int builtinKeysLength = builtinKeys.length;
        int modKeyBindingsLength = modKeyBindings.length;
        KeyMapping[] extendedKeys = Arrays.copyOf(builtinKeys, builtinKeysLength + modKeyBindingsLength);
        for (int i = 0; i < modKeyBindingsLength; ++i) {
            extendedKeys[builtinKeysLength + i] = modKeyBindings[i].key();
        }
        LOGGER.info("Returned extended keys");
        return extendedKeys;
    }
}

