/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.toast.animation;

import net.bivrik.fancytoasts.client.toast.AnimationSetup;
import net.bivrik.fancytoasts.client.toast.Appearance;
import net.bivrik.fancytoasts.client.toast.animation.FancyToastAnimation;
import net.bivrik.fancytoasts.platform.utility.GuiContext;
import net.bivrik.fancytoasts.utility.MathEasing;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;

public class PlayfulAnimation
extends FancyToastAnimation {
    private final Appearance ICON_APPEARANCE = new Appearance(1000, 0);
    private final Appearance ICON_MOVEMENT = new Appearance(1500, 1000);
    private final Appearance BANNER_APPEARANCE = new Appearance(1000, 1500);
    private final Appearance BACKGROUND_APPEARANCE = new Appearance(800, 1600);
    private final Appearance TEXT_APPEARANCE = new Appearance(1000, 2000);
    private final int FADE_OUT_DURATION = 1500;
    private final int DURATION = 7500;

    @Override
    public void setup(AnimationSetup setup, Minecraft minecraft, int toastWidth, int toastHeight) {
        super.setup(setup, minecraft, toastWidth, toastHeight);
        this.setLines(this.displayInfo.getTitle(), this.displayInfo.getDescription());
    }

    @Override
    public void draw(GuiGraphics guiGraphics, long time) {
        float scale;
        super.draw(guiGraphics, time);
        float iconAppearProgress = this.ICON_APPEARANCE.getProgress(time);
        float iconMovementProgress = this.ICON_MOVEMENT.getProgress(time);
        float bannerAppearProgress = this.BANNER_APPEARANCE.getProgress(time);
        float backgroundAppearProgress = this.BACKGROUND_APPEARANCE.getProgress(time);
        float textAppearProgress = this.TEXT_APPEARANCE.getProgress(time);
        float fadeOutProgress = Appearance.getProgress(time, 1500, 6000);
        GuiContext context = new GuiContext(guiGraphics);
        float globalSinY = this.sinusoidLoop(time, 2.0f, 1.0f) - 3.0f;
        if (fadeOutProgress > 0.0f) {
            float fadeOutScale = MathEasing.easeInLerp(1.0f, 0.0f, fadeOutProgress);
            int toastCenterX = this.toastWidth / 2;
            int toastCenterY = this.toastHeight / 2;
            context.push();
            context.scaleAround(fadeOutScale, toastCenterX, toastCenterY);
        }
        if (backgroundAppearProgress > 0.0f) {
            context.push();
            if (backgroundAppearProgress != 1.0f) {
                scale = MathEasing.elasticEaseOutLerp(0.0f, 1.0f, backgroundAppearProgress);
                context.scaleAround(scale, 76.0f, 0.0f);
                float rotation = MathEasing.elasticEaseOutLerp(-1.0f, 0.0f, backgroundAppearProgress);
                context.rotateAround(rotation, 76.0f, 0.0f);
                float y = MathEasing.easeOutLerp(-20.0f, 0.0f, backgroundAppearProgress);
                context.translate(0.0f, y);
            }
            this.drawBackground(context);
            context.pop();
        }
        if (bannerAppearProgress > 0.0f) {
            context.push();
            if (bannerAppearProgress != 1.0f) {
                float scaleX = MathEasing.easeOutLerp(0.0f, 1.0f, bannerAppearProgress);
                context.scaleAround(scaleX, 1.0f, 15.0f, -12.0f);
            }
            context.translate(0.0f, globalSinY);
            this.drawBanner(context);
            context.pop();
        }
        if (iconAppearProgress > 0.0f) {
            context.push();
            if (iconAppearProgress != 1.0f) {
                scale = MathEasing.elasticEaseOutLerp(0.0f, 1.0f, iconAppearProgress);
                context.scaleAround(scale, 81.0f, 13.0f);
                float rotation = MathEasing.elasticEaseOutLerp(-1.0f, 0.0f, iconAppearProgress);
                context.rotateAround(rotation, 81.0f, 13.0f);
            } else if (iconMovementProgress > 0.0f) {
                float x = MathEasing.easeOutLerp(0.0f, -60.0f, iconMovementProgress);
                context.translate(x, 0.0f);
            }
            context.translate(0.0f, globalSinY - 5.0f);
            this.drawIcon(context);
            context.pop();
        }
        if (textAppearProgress > 0.05f) {
            this.drawTitle(guiGraphics, textAppearProgress);
            this.drawDescription(guiGraphics, textAppearProgress);
        }
        if (fadeOutProgress > 0.0f) {
            context.pop();
        }
    }

    @Override
    public int getDuration() {
        return 7500;
    }

    @Override
    public int getToastSoundTiming() {
        return this.TEXT_APPEARANCE.startPoint() + 200;
    }
}

