/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.compat;

import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.IconAnimation;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.gui.ToastQuestObject;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.registry.ModItems;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.bivrik.fancytoasts.platform.utility.FancyToastType;
import net.bivrik.fancytoasts.platform.utility.QuestToastDisplayInfo;
import net.bivrik.fancytoasts.platform.utility.ResourceLocations;
import net.bivrik.fancytoasts.platform.utility.ToastDisplayInfo;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class FTBQuestsCompat {
    private static final Map<Long, Long> REPEATABLE_QUESTS = new HashMap<Long, Long>(3);
    private static final int MINUTE = 60000;
    private static final int TIME = 180000;

    public static boolean isQuest(Toast toast) {
        return toast instanceof ToastQuestObject;
    }

    public static ToastDisplayInfo getDisplayInfo(Toast toast) {
        Item item;
        Icon questIcon;
        ToastQuestObject questToast = (ToastQuestObject)toast;
        FancyToastType toastType = !questToast.isImportant() ? FancyToastType.TASK : FancyToastType.CHALLENGE;
        Component title = questToast.getSubtitle();
        Component description = toastType.getDisplayAnnouncement();
        Component questAnnouncement = questToast.getTitle();
        ArrayList<ItemStack> icons = new ArrayList<ItemStack>(1);
        Quest quest = null;
        for (QuestObjectBase questObject : ClientQuestFile.INSTANCE.getAllObjects()) {
            Quest foundQuest;
            if (!questObject.getTitle().equals((Object)title) || (foundQuest = ClientQuestFile.INSTANCE.getQuest(questObject.id)) == null) continue;
            quest = foundQuest;
            description = foundQuest.getSubtitle();
            break;
        }
        long currentTime = System.currentTimeMillis();
        if (quest != null) {
            Long id = quest.id;
            REPEATABLE_QUESTS.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > 180000L);
            if (quest.canBeRepeated()) {
                if (REPEATABLE_QUESTS.containsKey(id)) {
                    return null;
                }
                REPEATABLE_QUESTS.put(id, currentTime);
            }
        }
        if ((questIcon = questToast.getIcon()) instanceof ItemIcon) {
            ItemIcon itemIcon = (ItemIcon)questIcon;
            icons.add(itemIcon.getStack());
        } else if (questIcon instanceof IconAnimation) {
            IconAnimation iconAnimation = (IconAnimation)questIcon;
            for (Icon icon : iconAnimation.list) {
                if (!(icon instanceof ItemIcon)) continue;
                ItemIcon itemIcon = (ItemIcon)icon;
                icons.add(itemIcon.getStack());
            }
        }
        if (icons.isEmpty() && (item = (Item)ModItems.ITEMS.getRegistrar().get(ResourceLocations.withNamespaceAndPath("ftbquests", "book"))) != null) {
            ItemStack icon = new ItemStack((ItemLike)item);
            icons.add(icon);
        }
        return new QuestToastDisplayInfo(icons, title, description, toastType, questAnnouncement);
    }
}

