/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.core;

import java.util.function.Supplier;
import net.bivrik.fancytoasts.client.gui.screen.FancyToastsScreen;
import net.bivrik.fancytoasts.client.registry.AnimationRegistry;
import net.bivrik.fancytoasts.client.registry.KeyBindingRegistry;
import net.bivrik.fancytoasts.client.registry.TextureRegistry;
import net.bivrik.fancytoasts.client.toast.DisplayData;
import net.bivrik.fancytoasts.client.toast.animation.FancyToastAnimation;
import net.bivrik.fancytoasts.client.toast.animation.OldlikeAnimation;
import net.bivrik.fancytoasts.client.toast.animation.PlayfulAnimation;
import net.bivrik.fancytoasts.client.toast.animation.QuirkyAnimation;
import net.bivrik.fancytoasts.client.toast.animation.StandardAnimation;
import net.bivrik.fancytoasts.core.Debug;
import net.bivrik.fancytoasts.core.Managers;
import net.bivrik.fancytoasts.platform.Services;
import net.bivrik.fancytoasts.platform.utility.Components;
import net.bivrik.fancytoasts.utility.DefaultLocations;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;

public class Common {
    public static void onModInit() {
        if (!Services.PLATFORM.isModLoaded("fancytoasts")) {
            return;
        }
        Debug.info("Initialization on {} in a {} environment", Services.PLATFORM.getName(), Services.PLATFORM.getEnvironmentName());
        Managers.init();
        Managers.onModInit();
    }

    public static void onMinecraftInit(Minecraft minecraft) {
        Managers.onMinecraftInit(minecraft);
    }

    public static void onTick() {
        Managers.onTick();
    }

    public static void registerKeyBindings() {
        KeyBindingRegistry.register("config_menu", 75, () -> Minecraft.getInstance().setScreen((Screen)new FancyToastsScreen(null)));
    }

    private static void registerTexture(ResourceLocation id, String name) {
        String translationKeyName = Components.stringOf("toast.texture." + name);
        TextureRegistry.register(id, new DisplayData(translationKeyName, "Fancy Toasts", translationKeyName + ".description", true));
    }

    private static void registerAnimation(ResourceLocation id, String name, Supplier<FancyToastAnimation> animation) {
        String translationKeyName = Components.stringOf("toast.animation." + name);
        AnimationRegistry.register(id, animation, new DisplayData(translationKeyName, "Fancy Toasts", translationKeyName + ".description", true));
    }

    static {
        Common.registerKeyBindings();
        Common.registerTexture(DefaultLocations.Textures.VANILLA, "vanilla");
        Common.registerTexture(DefaultLocations.Textures.NATURE, "nature");
        Common.registerTexture(DefaultLocations.Textures.OG, "og");
        Common.registerTexture(DefaultLocations.Textures.MODERN, "modern");
        Common.registerTexture(DefaultLocations.Textures.STEAMY, "steamy");
        Common.registerTexture(DefaultLocations.Textures.TERRACRAFT, "terracraft");
        Common.registerTexture(DefaultLocations.Textures.LANDSPAPER, "landspaper");
        Common.registerAnimation(DefaultLocations.Animations.STANDARD, "standard", StandardAnimation::new);
        Common.registerAnimation(DefaultLocations.Animations.PLAYFUL, "playful", PlayfulAnimation::new);
        Common.registerAnimation(DefaultLocations.Animations.QUIRKY, "quirky", QuirkyAnimation::new);
        Common.registerAnimation(DefaultLocations.Animations.OLDLIKE, "oldlike", OldlikeAnimation::new);
    }
}

