/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.core.manager;

import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.bivrik.fancytoasts.client.config.ToastScreenBehavior;
import net.bivrik.fancytoasts.client.config.data.GeneralConfigData;
import net.bivrik.fancytoasts.client.config.data.ToastConfigData;
import net.bivrik.fancytoasts.client.toast.FancyAdvancementToast;
import net.bivrik.fancytoasts.core.IManager;
import net.bivrik.fancytoasts.core.Managers;
import net.bivrik.fancytoasts.core.event.GeneralConfigDataEvent;
import net.bivrik.fancytoasts.core.event.ToastConfigDataEvent;
import net.bivrik.fancytoasts.core.manager.ConfigManager;
import net.bivrik.fancytoasts.core.manager.CustomTextureManager;
import net.bivrik.fancytoasts.core.manager.EventManager;
import net.bivrik.fancytoasts.platform.Services;
import net.bivrik.fancytoasts.platform.utility.GuiContext;
import net.bivrik.fancytoasts.platform.utility.ToastDisplayInfo;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import org.joml.Vector2d;

public class ToastManager
implements IManager {
    private final Deque<FancyAdvancementToast> toasts = new ConcurrentLinkedDeque<FancyAdvancementToast>();
    private Minecraft minecraft;
    private volatile FancyAdvancementToast currentToast;
    private long startingTimeOfToast;
    private CustomTextureManager customTextureManager;
    private GeneralConfigData generalConfigData;
    private ToastConfigData toastConfigData;

    @Override
    public void onMinecraftInit(Minecraft minecraft) {
        this.minecraft = minecraft;
        this.customTextureManager = Managers.getCustomTextureManager();
        ConfigManager configManager = Managers.getConfigManager();
        this.generalConfigData = configManager.getGeneralConfigData();
        this.toastConfigData = configManager.getToastConfigData();
        EventManager eventManager = Managers.getEventManager();
        eventManager.subscribeToEvent(GeneralConfigDataEvent.class, this::onGeneralConfigDataChanged);
        eventManager.subscribeToEvent(ToastConfigDataEvent.class, this::onToastConfigDataChanged);
    }

    private void onGeneralConfigDataChanged(GeneralConfigDataEvent event) {
        this.generalConfigData = event.generalConfigData();
    }

    private void onToastConfigDataChanged(ToastConfigDataEvent event) {
        this.toastConfigData = event.toastConfigData();
    }

    public void addToast(ToastDisplayInfo displayInfo) {
        if (displayInfo == null) {
            return;
        }
        FancyAdvancementToast fancyToast = new FancyAdvancementToast(this.minecraft, displayInfo, this.toastConfigData.getTextureId(), this.toastConfigData.getAnimationId());
        this.toasts.add(fancyToast);
        this.customTextureManager.addBeingUsed(this.toastConfigData.getTextureId(), fancyToast);
        if (this.generalConfigData.isJadeHiding()) {
            Services.JADE.tryDisable();
        }
    }

    public void update() {
        if (!this.isEmpty()) {
            if (this.generalConfigData.isJadeHiding() && Services.JADE.isEnabled()) {
                Services.JADE.tryEnable();
            }
            this.updateCurrentToast();
            if (this.currentToast.isEnded()) {
                this.removeCurrentToast();
                if (this.generalConfigData.isJadeHiding() && this.toasts.isEmpty()) {
                    Services.JADE.tryEnable();
                }
            }
            return;
        }
        if (!this.toasts.isEmpty()) {
            this.setNewCurrentToast();
        }
    }

    public void render(GuiGraphics guiGraphics) {
        if (!this.shouldRender()) {
            return;
        }
        int screenWidth = guiGraphics.guiWidth();
        int screenHeight = guiGraphics.guiHeight();
        Vector2d toastPosition = this.generalConfigData.getToastAnchor().getPosition(screenWidth, screenHeight, this.generalConfigData.getOffsetX(), -this.generalConfigData.getOffsetY());
        int xPos = (int)toastPosition.x() - this.currentToast.getWidth() / 2;
        int yPos = (int)toastPosition.y() - this.currentToast.getHeight() / 2;
        GuiContext context = new GuiContext(guiGraphics);
        context.push();
        context.translate(xPos, yPos, 4200.0f);
        this.currentToast.draw(guiGraphics);
        context.pop();
    }

    public void clear() {
        this.toasts.clear();
        this.removeCurrentToast();
        this.customTextureManager.clear();
        if (this.generalConfigData.isJadeHiding()) {
            Services.JADE.tryEnable();
        }
    }

    private void removeCurrentToast() {
        this.customTextureManager.removeBeingUsed(this.currentToast);
        this.currentToast = null;
    }

    private void updateCurrentToast() {
        long time = Util.getMillis() - this.startingTimeOfToast;
        this.currentToast.update(time);
    }

    private void setNewCurrentToast() {
        FancyAdvancementToast nextToast = this.toasts.pollFirst();
        if (nextToast != null) {
            this.currentToast = nextToast;
            this.startingTimeOfToast = Util.getMillis();
        }
    }

    private boolean shouldRender() {
        return !this.isEmpty() && !this.minecraft.options.hideGui;
    }

    public boolean isScreenOpened() {
        return this.minecraft.screen != null && !(this.minecraft.screen instanceof ChatScreen);
    }

    public boolean shouldRenderBehind() {
        return this.generalConfigData.getToastScreenBehavior() == ToastScreenBehavior.BEHIND && this.isScreenOpened();
    }

    public boolean isEmpty() {
        return this.currentToast == null;
    }
}

