/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.registry;

import dev.latvian.mods.kubejs.DevProperties;
import dev.latvian.mods.kubejs.error.KubeRuntimeException;
import dev.latvian.mods.kubejs.event.EventResult;
import dev.latvian.mods.kubejs.event.KubeStartupEvent;
import dev.latvian.mods.kubejs.registry.AdditionalObjectRegistry;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.registry.BuilderType;
import dev.latvian.mods.kubejs.registry.BuilderTypeRegistryHandler;
import dev.latvian.mods.kubejs.registry.CustomBuilderObject;
import dev.latvian.mods.kubejs.registry.RegistryObjectStorage;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.script.SourceLine;
import dev.latvian.mods.kubejs.util.KubeResourceLocation;
import dev.latvian.mods.rhino.Context;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;

public class RegistryKubeEvent<T>
implements KubeStartupEvent,
AdditionalObjectRegistry {
    private final ResourceKey<Registry<T>> registryKey;
    private final BuilderTypeRegistryHandler.Info<T> builderInfo;
    public final List<BuilderBase<? extends T>> created;

    public RegistryKubeEvent(ResourceKey<Registry<T>> registryKey) {
        this.registryKey = registryKey;
        this.builderInfo = BuilderTypeRegistryHandler.info(registryKey);
        this.created = new LinkedList<BuilderBase<? extends T>>();
    }

    public BuilderBase<? extends T> create(Context cx, KubeResourceLocation id, KubeResourceLocation type) {
        SourceLine sourceLine = SourceLine.of(cx);
        BuilderType<T> t = this.builderInfo.namedType(type.wrapped());
        if (t == null) {
            throw new KubeRuntimeException("Unknown type '" + String.valueOf(type) + "' for object '" + String.valueOf(id) + "'!").source(sourceLine);
        }
        BuilderBase b = t.factory().createBuilder(id.wrapped());
        if (b == null) {
            throw new KubeRuntimeException("Unknown type '" + String.valueOf(type) + "' for object '" + String.valueOf(id) + "'!").source(sourceLine);
        }
        if (this.builderInfo.directCodec() != null) {
            throw new KubeRuntimeException("Type '" + String.valueOf(type) + "' for object '" + String.valueOf(id) + "' is a datapack registry type!").source(sourceLine);
        }
        b.sourceLine = sourceLine;
        b.registryKey = this.registryKey;
        this.addBuilder(b);
        this.created.add(b);
        return b;
    }

    public BuilderBase<? extends T> create(Context cx, KubeResourceLocation id) {
        SourceLine sourceLine = SourceLine.of(cx);
        BuilderType<T> t = this.builderInfo.defaultType();
        if (t == null) {
            throw new KubeRuntimeException("Registry '" + String.valueOf(this.registryKey.location()) + "' doesn't have a default type registered!").source(sourceLine);
        }
        BuilderBase b = t.factory().createBuilder(id.wrapped());
        if (b == null) {
            throw new KubeRuntimeException("Unknown type '" + String.valueOf(t.type()) + "' for object '" + String.valueOf(id) + "'!").source(sourceLine);
        }
        b.sourceLine = sourceLine;
        b.registryKey = this.registryKey;
        this.addBuilder(b);
        this.created.add(b);
        return b;
    }

    public CustomBuilderObject createCustom(Context cx, KubeResourceLocation id, Supplier<Object> object) {
        SourceLine sourceLine = SourceLine.of(cx);
        if (object == null) {
            throw new KubeRuntimeException("Tried to register a null object with id: " + String.valueOf(id)).source(sourceLine);
        }
        CustomBuilderObject b = new CustomBuilderObject(id.wrapped(), object);
        b.sourceLine = sourceLine;
        b.registryKey = this.registryKey;
        this.addBuilder(b);
        this.created.add(b);
        return b;
    }

    @Override
    public void afterPosted(EventResult result) {
        for (BuilderBase<T> c : this.created) {
            c.createAdditionalObjects(this);
        }
    }

    public <R> void add(ResourceKey<Registry<R>> registry, BuilderBase<? extends R> builder) {
        builder.registryKey = registry;
        this.addBuilder(builder);
    }

    private <R> void addBuilder(BuilderBase<? extends R> builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Can't add null builder in registry '" + String.valueOf(builder.registryKey.location()) + "'!");
        }
        if (DevProperties.get().logRegistryEventObjects) {
            ConsoleJS.STARTUP.info("~ " + String.valueOf(builder.registryKey.location()) + " | " + String.valueOf(builder.id));
        }
        RegistryObjectStorage objStorage = RegistryObjectStorage.of(builder.registryKey);
        if (objStorage.objects.containsKey(builder.id)) {
            throw new IllegalArgumentException("Duplicate key '" + String.valueOf(builder.id) + "' in registry '" + String.valueOf(builder.registryKey.location()) + "'!");
        }
        objStorage.objects.put(builder.id, builder);
        RegistryObjectStorage.ALL_BUILDERS.add(builder);
    }
}

