/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.appexp.data;

import es.degrassi.appexp.data.BlockStateModelProvider;
import es.degrassi.appexp.data.BlockTagsProvider;
import es.degrassi.appexp.data.FluidTagsProvider;
import es.degrassi.appexp.data.ItemModelProvider;
import es.degrassi.appexp.data.ItemTagsProvider;
import es.degrassi.appexp.data.LootProvider;
import es.degrassi.appexp.data.RecipeProvider;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public class AppliedExperiencedDataGenerators {
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator.PackGenerator pack = event.getGenerator().getVanillaPack(true);
        ExistingFileHelper existing = event.getExistingFileHelper();
        pack.addProvider(output -> new ItemModelProvider(output, existing));
        pack.addProvider(output -> new BlockStateModelProvider(output, existing));
        CompletableFuture<HolderLookup.Provider> registries = CompletableFuture.supplyAsync(VanillaRegistries::createLookup, Util.backgroundExecutor());
        BlockTagsProvider blockTagsProvider = (BlockTagsProvider)pack.addProvider(output -> new BlockTagsProvider(output, registries, existing));
        pack.addProvider(output -> new FluidTagsProvider(output, registries, existing));
        pack.addProvider(output -> new ItemTagsProvider(output, registries, blockTagsProvider.contentsGetter(), existing));
        pack.addProvider(output -> new RecipeProvider(output, registries));
        LootTableProvider.SubProviderEntry blockDrops = new LootTableProvider.SubProviderEntry(LootProvider::new, LootContextParamSets.BLOCK);
        pack.addProvider(output -> new LootTableProvider(output, Set.of(), List.of(blockDrops), registries));
    }
}

