/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.butcher.block;

import net.mcreator.butcher.procedures.PlaceBrainInJarProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FilledJarBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public FilledJarBlock() {
        super(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.HAT).sound(SoundType.GLASS).strength(1.0f, 10.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> Shapes.or((VoxelShape)FilledJarBlock.box((double)6.0, (double)3.45, (double)5.95, (double)10.0, (double)6.45, (double)9.95), (VoxelShape[])new VoxelShape[]{FilledJarBlock.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0), FilledJarBlock.box((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0), FilledJarBlock.box((double)5.0, (double)8.6, (double)5.0, (double)11.0, (double)9.6, (double)11.0)});
            case Direction.NORTH -> Shapes.or((VoxelShape)FilledJarBlock.box((double)6.0, (double)3.45, (double)6.05, (double)10.0, (double)6.45, (double)10.05), (VoxelShape[])new VoxelShape[]{FilledJarBlock.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0), FilledJarBlock.box((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0), FilledJarBlock.box((double)5.0, (double)8.6, (double)5.0, (double)11.0, (double)9.6, (double)11.0)});
            case Direction.EAST -> Shapes.or((VoxelShape)FilledJarBlock.box((double)5.95, (double)3.45, (double)6.0, (double)9.95, (double)6.45, (double)10.0), (VoxelShape[])new VoxelShape[]{FilledJarBlock.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0), FilledJarBlock.box((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0), FilledJarBlock.box((double)5.0, (double)8.6, (double)5.0, (double)11.0, (double)9.6, (double)11.0)});
            case Direction.WEST -> Shapes.or((VoxelShape)FilledJarBlock.box((double)6.05, (double)3.45, (double)6.0, (double)10.05, (double)6.45, (double)10.0), (VoxelShape[])new VoxelShape[]{FilledJarBlock.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0), FilledJarBlock.box((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0), FilledJarBlock.box((double)5.0, (double)8.6, (double)5.0, (double)11.0, (double)9.6, (double)11.0)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public InteractionResult useWithoutItem(BlockState blockstate, Level world, BlockPos pos, Player entity, BlockHitResult hit) {
        super.useWithoutItem(blockstate, world, pos, entity, hit);
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        double hitX = hit.getLocation().x;
        double hitY = hit.getLocation().y;
        double hitZ = hit.getLocation().z;
        Direction direction = hit.getDirection();
        PlaceBrainInJarProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        return InteractionResult.SUCCESS;
    }
}

