/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.butcher.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HangingGoatSkeletonBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public HangingGoatSkeletonBlock() {
        super(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASEDRUM).sound(SoundType.BONE_BLOCK).strength(1.0f, 10.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> Shapes.or((VoxelShape)HangingGoatSkeletonBlock.box((double)7.48435, (double)-2.19489, (double)-0.6681, (double)8.48435, (double)-0.89489, (double)0.3319), (VoxelShape)HangingGoatSkeletonBlock.box((double)4.175, (double)-0.90936, (double)-1.23436, (double)11.875, (double)13.91564, (double)8.56564));
            case Direction.NORTH -> Shapes.or((VoxelShape)HangingGoatSkeletonBlock.box((double)7.51565, (double)-2.19489, (double)15.6681, (double)8.51565, (double)-0.89489, (double)16.6681), (VoxelShape)HangingGoatSkeletonBlock.box((double)4.125, (double)-0.90936, (double)7.43436, (double)11.825, (double)13.91564, (double)17.23436));
            case Direction.EAST -> Shapes.or((VoxelShape)HangingGoatSkeletonBlock.box((double)-0.6681, (double)-2.19489, (double)7.51565, (double)0.3319, (double)-0.89489, (double)8.51565), (VoxelShape)HangingGoatSkeletonBlock.box((double)-1.23436, (double)-0.90936, (double)4.125, (double)8.56564, (double)13.91564, (double)11.825));
            case Direction.WEST -> Shapes.or((VoxelShape)HangingGoatSkeletonBlock.box((double)15.6681, (double)-2.19489, (double)7.48435, (double)16.6681, (double)-0.89489, (double)8.48435), (VoxelShape)HangingGoatSkeletonBlock.box((double)7.43436, (double)-0.90936, (double)4.175, (double)17.23436, (double)13.91564, (double)11.875));
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

