/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.butcher.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HangingPigSkeletonBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public HangingPigSkeletonBlock() {
        super(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASEDRUM).sound(SoundType.BONE_BLOCK).strength(1.0f, 10.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> Shapes.or((VoxelShape)HangingPigSkeletonBlock.box((double)3.35223, (double)-1.00411, (double)0.54482, (double)13.15223, (double)14.79589, (double)8.34482), (VoxelShape)HangingPigSkeletonBlock.box((double)7.22805, (double)-2.05141, (double)2.35, (double)9.22805, (double)-0.05141, (double)4.35));
            case Direction.NORTH -> Shapes.or((VoxelShape)HangingPigSkeletonBlock.box((double)2.84777, (double)-1.00411, (double)7.65518, (double)12.64777, (double)14.79589, (double)15.45518), (VoxelShape)HangingPigSkeletonBlock.box((double)6.77195, (double)-2.05141, (double)11.65, (double)8.77195, (double)-0.05141, (double)13.65));
            case Direction.EAST -> Shapes.or((VoxelShape)HangingPigSkeletonBlock.box((double)0.54482, (double)-1.00411, (double)2.84777, (double)8.34482, (double)14.79589, (double)12.64777), (VoxelShape)HangingPigSkeletonBlock.box((double)2.35, (double)-2.05141, (double)6.77195, (double)4.35, (double)-0.05141, (double)8.77195));
            case Direction.WEST -> Shapes.or((VoxelShape)HangingPigSkeletonBlock.box((double)7.65518, (double)-1.00411, (double)3.35223, (double)15.45518, (double)14.79589, (double)13.15223), (VoxelShape)HangingPigSkeletonBlock.box((double)11.65, (double)-2.05141, (double)7.22805, (double)13.65, (double)-0.05141, (double)9.22805));
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

