/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.butcher.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HangingRabbitSkeletonBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public HangingRabbitSkeletonBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.HONEY_BLOCK).strength(1.0f, 10.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> Shapes.or((VoxelShape)HangingRabbitSkeletonBlock.box((double)5.57487, (double)2.72119, (double)5.44632, (double)11.57487, (double)12.72119, (double)10.44632), (VoxelShape)HangingRabbitSkeletonBlock.box((double)6.07487, (double)-0.95971, (double)5.49182, (double)11.07487, (double)4.04029, (double)9.49182));
            case Direction.NORTH -> Shapes.or((VoxelShape)HangingRabbitSkeletonBlock.box((double)4.42513, (double)2.72119, (double)5.55368, (double)10.42513, (double)12.72119, (double)10.55368), (VoxelShape)HangingRabbitSkeletonBlock.box((double)4.92513, (double)-0.95971, (double)6.50818, (double)9.92513, (double)4.04029, (double)10.50818));
            case Direction.EAST -> Shapes.or((VoxelShape)HangingRabbitSkeletonBlock.box((double)5.44632, (double)2.72119, (double)4.42513, (double)10.44632, (double)12.72119, (double)10.42513), (VoxelShape)HangingRabbitSkeletonBlock.box((double)5.49182, (double)-0.95971, (double)4.92513, (double)9.49182, (double)4.04029, (double)9.92513));
            case Direction.WEST -> Shapes.or((VoxelShape)HangingRabbitSkeletonBlock.box((double)5.55368, (double)2.72119, (double)5.57487, (double)10.55368, (double)12.72119, (double)11.57487), (VoxelShape)HangingRabbitSkeletonBlock.box((double)6.50818, (double)-0.95971, (double)6.07487, (double)10.50818, (double)4.04029, (double)11.07487));
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

