/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.setup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.silentchaos512.gems.block.teleporter.TeleporterBlockEntity;
import net.silentchaos512.gems.setup.GemsBlocks;
import net.silentchaos512.gems.util.Gems;

public class GemsBlockEntityTypes {
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"silentgems");
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<TeleporterBlockEntity>> TELEPORTER = GemsBlockEntityTypes.register("teleporter", TeleporterBlockEntity::new, (DeferredBlock[])GemsBlockEntityTypes.getAllTeleporters().toArray(DeferredBlock[]::new));

    private static <T extends BlockEntity> DeferredHolder<BlockEntityType<?>, BlockEntityType<T>> register(String name, BlockEntityType.BlockEntitySupplier<T> factory, DeferredBlock<?> ... blocks) {
        return BLOCK_ENTITY_TYPES.register(name, () -> {
            Block[] validBlocks = (Block[])Arrays.stream(blocks).map(DeferredHolder::get).toArray(Block[]::new);
            return BlockEntityType.Builder.of((BlockEntityType.BlockEntitySupplier)factory, (Block[])validBlocks).build(null);
        });
    }

    private static List<DeferredBlock<?>> getAllTeleporters() {
        ArrayList list = new ArrayList();
        for (Gems gem : Gems.values()) {
            list.add(gem.getTeleporter());
            list.add(gem.getRedstoneTeleporter());
        }
        list.add(GemsBlocks.TELEPORTER_ANCHOR);
        return list;
    }
}

