/*
 * Decompiled with CFR 0.152.
 */
package glitchcore.event;

import com.google.common.collect.ImmutableSet;
import glitchcore.event.Event;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.jodah.typetools.TypeResolver;

public class EventManager {
    private static Map<Class<? extends Event>, Consumer<? extends Event>[]> listeners = new HashMap<Class<? extends Event>, Consumer<? extends Event>[]>();
    private static final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Event> void addListener(Consumer<T> listener) {
        Class<T> eventClass = EventManager.getEventClass(listener);
        Object object = lock;
        synchronized (object) {
            if (listeners.containsKey(eventClass)) {
                Consumer<? extends Event>[] arr = listeners.get(eventClass);
                int len = arr.length;
                arr = Arrays.copyOf(arr, len + 1);
                arr[len] = listener;
                listeners.replace(eventClass, arr);
            } else {
                listeners.computeIfAbsent(eventClass, key -> new Consumer[]{listener});
            }
        }
    }

    public static <T extends Event> void fire(T event) {
        Class<?> eventClass = event.getClass();
        for (Consumer listener : Optional.ofNullable(listeners.get(eventClass)).orElse(new Consumer[0])) {
            listener.accept(event);
            if (event.isCancellable() && event.isCancelled()) break;
        }
    }

    public static ImmutableSet<Class<? extends Event>> getRequiredEvents() {
        return ImmutableSet.copyOf(listeners.keySet());
    }

    private static <T extends Event> Class<T> getEventClass(Consumer<T> consumer) {
        Class eventClass = TypeResolver.resolveRawArgument(Consumer.class, consumer.getClass());
        if (eventClass == TypeResolver.Unknown.class) {
            throw new IllegalStateException("Failed to resolve consumer event type: " + consumer.toString());
        }
        return eventClass;
    }
}

