/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.entity;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.entity.ThrownSwordEntity;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class LivyatanEntity
extends ThrownSwordEntity {
    public int slownessDuration;

    public LivyatanEntity(EntityType<? extends LivyatanEntity> entityType, Level world) {
        super(entityType, world);
    }

    public LivyatanEntity(Level world, LivingEntity owner, ItemStack stack) {
        super(world, owner, stack);
        this.stack = stack;
    }

    @Override
    public void tick() {
        this.returnToPlayer = true;
        super.tick();
    }

    @Override
    protected void damageOnReturn(double radius, float damage) {
        Entity entity;
        if (this.level().isClientSide()) {
            return;
        }
        if (this.stack == null || this.stack.isEmpty()) {
            return;
        }
        ServerLevel world = (ServerLevel)this.level();
        if (this.getOwner() != null && (entity = this.getOwner()) instanceof ServerPlayer) {
            ServerPlayer user = (ServerPlayer)entity;
            DamageSource damageSource = user.damageSources().trident((Entity)this, (Entity)user);
            float returnDamage = EnchantmentHelper.modifyDamage((ServerLevel)world, (ItemStack)this.stack, (Entity)this, (DamageSource)damageSource, (float)damage);
            AABB box = new AABB(this.getX() + radius, this.getY() + radius, this.getZ() + radius, this.getX() - radius, this.getY() - radius, this.getZ() - radius);
            for (Entity entity2 : world.getEntities((Entity)this, box, EntitySelector.LIVING_ENTITY_STILL_ALIVE)) {
                LivingEntity le;
                if (!(entity2 instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entity2, (LivingEntity)user) || le.tickCount % 5 != 0) continue;
                HelperMethods.damageThroughIframes((Entity)le, damageSource, returnDamage);
                world.playSound(null, (Entity)user, (SoundEvent)SoundRegistry.ELEMENTAL_SWORD_ICE_ATTACK_01.get(), user.getSoundSource(), 0.2f, 1.5f);
                le.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, this.slownessDuration, 2), (Entity)user);
                HelperMethods.spawnOrbitParticles(world, this.position(), (ParticleOptions)ParticleTypes.POOF, 0.5, 3);
            }
        }
    }

    @Override
    protected void doEffects(ServerLevel serverWorld, float baseDamage, Entity entity) {
        int bonusParticles = (int)baseDamage / 2;
        HelperMethods.spawnOrbitParticles(serverWorld, this.position(), (ParticleOptions)ParticleTypes.POOF, 0.5, 3 + bonusParticles);
        HelperMethods.spawnOrbitParticles(serverWorld, this.position(), (ParticleOptions)ParticleTypes.CRIT, 0.5, 5 + bonusParticles);
        HelperMethods.spawnOrbitParticles(serverWorld, this.position(), (ParticleOptions)ParticleTypes.SNOWFLAKE, 0.5, 2 + bonusParticles);
        if (baseDamage > this.primaryBaseDamage) {
            serverWorld.playSound(null, entity, (SoundEvent)SoundRegistry.MAGIC_SWORD_PARRY_VARIOUS_HITS.get(), this.getSoundSource(), 0.3f, 1.2f);
        }
    }

    @Override
    protected SoundEvent getReturnSound() {
        return (SoundEvent)SoundRegistry.ELEMENTAL_BOW_ICE_SHOOT_IMPACT_01.get();
    }

    @Override
    public ItemStack getPickupItemStackOrigin() {
        return this.stack;
    }

    @Override
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)ItemsRegistry.FROSTFALL.get());
    }

    @Override
    protected byte getLoyalty() {
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            return 3;
        }
        return 0;
    }
}

