/*
 * Decompiled with CFR 0.152.
 */
package cn.dancingsnow.bigger_ae2.client;

import appeng.block.crafting.ICraftingUnitType;
import appeng.client.render.crafting.AbstractCraftingUnitModelProvider;
import appeng.client.render.crafting.LightBakedModel;
import appeng.core.AppEng;
import cn.dancingsnow.bigger_ae2.BiggerAE2Mod;
import cn.dancingsnow.bigger_ae2.block.ModCraftingUnitType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.world.inventory.InventoryMenu;

public class ModCraftingUnitModelProvider
extends AbstractCraftingUnitModelProvider<ModCraftingUnitType> {
    private static final List<Material> MATERIALS = new ArrayList<Material>();
    private static final Material RING_CORNER = ModCraftingUnitModelProvider.aeTexture("ring_corner");
    private static final Material RING_SIDE_HOR = ModCraftingUnitModelProvider.aeTexture("ring_side_hor");
    private static final Material RING_SIDE_VER = ModCraftingUnitModelProvider.aeTexture("ring_side_ver");
    private static final Material LIGHT_BASE = ModCraftingUnitModelProvider.aeTexture("light_base");
    private static final Material ACCELERATOR_4_LIGHT = ModCraftingUnitModelProvider.texture("4_core_crafting_accelerator_light");
    private static final Material ACCELERATOR_16_LIGHT = ModCraftingUnitModelProvider.texture("16_core_crafting_accelerator_light");
    private static final Material ACCELERATOR_64_LIGHT = ModCraftingUnitModelProvider.texture("64_core_crafting_accelerator_light");
    private static final Material ACCELERATOR_256_LIGHT = ModCraftingUnitModelProvider.texture("256_core_crafting_accelerator_light");
    private static final Material ACCELERATOR_1024_LIGHT = ModCraftingUnitModelProvider.texture("1024_core_crafting_accelerator_light");

    public ModCraftingUnitModelProvider(ModCraftingUnitType type) {
        super((ICraftingUnitType)type);
    }

    public TextureAtlasSprite getLightMaterial(Function<Material, TextureAtlasSprite> textureGetter) {
        return switch ((ModCraftingUnitType)this.type) {
            default -> throw new MatchException(null, null);
            case ModCraftingUnitType.ACCELERATOR_4 -> textureGetter.apply(ACCELERATOR_4_LIGHT);
            case ModCraftingUnitType.ACCELERATOR_16 -> textureGetter.apply(ACCELERATOR_16_LIGHT);
            case ModCraftingUnitType.ACCELERATOR_64 -> textureGetter.apply(ACCELERATOR_64_LIGHT);
            case ModCraftingUnitType.ACCELERATOR_256 -> textureGetter.apply(ACCELERATOR_256_LIGHT);
            case ModCraftingUnitType.ACCELERATOR_1024 -> textureGetter.apply(ACCELERATOR_1024_LIGHT);
        };
    }

    public List<Material> getMaterials() {
        return Collections.unmodifiableList(MATERIALS);
    }

    public BakedModel getBakedModel(Function<Material, TextureAtlasSprite> spriteGetter) {
        TextureAtlasSprite ringCorner = spriteGetter.apply(RING_CORNER);
        TextureAtlasSprite ringSideHor = spriteGetter.apply(RING_SIDE_HOR);
        TextureAtlasSprite ringSideVer = spriteGetter.apply(RING_SIDE_VER);
        TextureAtlasSprite lightBase = spriteGetter.apply(LIGHT_BASE);
        return new LightBakedModel(ringCorner, ringSideHor, ringSideVer, lightBase, this.getLightMaterial(spriteGetter));
    }

    private static Material texture(String name) {
        Material material = new Material(InventoryMenu.BLOCK_ATLAS, BiggerAE2Mod.of("block/crafting/" + name));
        MATERIALS.add(material);
        return material;
    }

    private static Material aeTexture(String name) {
        Material material = new Material(InventoryMenu.BLOCK_ATLAS, AppEng.makeId((String)("block/crafting/" + name)));
        MATERIALS.add(material);
        return material;
    }
}

