/*
 * Decompiled with CFR 0.152.
 */
package cn.dancingsnow.bigger_ae2.integration.appliedflux.item;

import appeng.api.stacks.KeyCounter;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.StorageCell;
import appeng.core.localization.PlayerMessages;
import appeng.util.InteractionUtil;
import cn.dancingsnow.bigger_ae2.integration.appliedflux.AppliedFluxItems;
import com.glodblock.github.appflux.common.items.ItemFECell;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class AdvancedItemFECell
extends ItemFECell {
    private final ItemLike coreItem;

    public AdvancedItemFECell(ItemLike coreItem, int kilobytes, double idleDrain) {
        super(coreItem, kilobytes, idleDrain);
        this.coreItem = coreItem;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        this.disassembleDrive(player.getItemInHand(hand), level, player);
        return new InteractionResultHolder(InteractionResult.sidedSuccess((boolean)level.isClientSide()), (Object)player.getItemInHand(hand));
    }

    private boolean disassembleDrive(ItemStack stack, Level level, Player player) {
        if (InteractionUtil.isInAlternateUseMode((Player)player)) {
            if (level.isClientSide()) {
                return false;
            }
            Inventory playerInventory = player.getInventory();
            StorageCell inv = StorageCells.getCellInventory((ItemStack)stack, null);
            if (inv != null && playerInventory.getSelected() == stack) {
                KeyCounter list = inv.getAvailableStacks();
                if (list.isEmpty()) {
                    playerInventory.setItem(playerInventory.selected, ItemStack.EMPTY);
                    playerInventory.placeItemBackInInventory(new ItemStack(this.coreItem));
                    for (ItemStack upgrade : this.getUpgrades(stack)) {
                        playerInventory.placeItemBackInInventory(upgrade);
                    }
                    playerInventory.placeItemBackInInventory(new ItemStack((ItemLike)AppliedFluxItems.ADVANCED_FLUX_CELL_HOUSING.asItem()));
                    return true;
                }
                player.displayClientMessage((Component)PlayerMessages.OnlyEmptyCellsCanBeDisassembled.text(), true);
            }
        }
        return false;
    }
}

